/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.signature;

import java.awt.Rectangle;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;

public class Signature {
    int internalIndex = -1;
    private byte[] certificateRawData;
    private Instant signatureDate = null;
    private byte[] signatureImage = null;
    private Rectangle signatureImageRectangle = null;
    private String signingContact = null;
    private String signingLocation = null;
    private String signingReason = null;
    private String password = null;
    private String timeStampUrl = null;

    public Signature(String filePathToCertificate, String password) throws IOException {
        this(Files.readAllBytes(Paths.get(filePathToCertificate, new String[0])), password);
    }

    public Signature(Path filePathToCertificate, String password) throws IOException {
        this(Files.readAllBytes(filePathToCertificate), password);
    }

    public Signature(byte[] certificateRawData, String password) {
        this.certificateRawData = certificateRawData;
        this.password = password;
    }

    public Signature(byte[] certificateRawData, String password, Instant signatureDate, byte[] signatureImage, String signingContact, String signingLocation, String signingReason, Rectangle signatureImageRectangle) {
        this.certificateRawData = certificateRawData;
        this.password = password;
        this.signatureDate = signatureDate;
        this.signatureImage = signatureImage;
        this.signingContact = signingContact;
        this.signingLocation = signingLocation;
        this.signingReason = signingReason;
        this.signatureImageRectangle = signatureImageRectangle;
    }

    public byte[] getCertificateRawData() {
        return this.certificateRawData;
    }

    public void setCertificateRawData(byte[] certificateRawData) {
        this.certificateRawData = certificateRawData;
    }

    public Instant getSignatureDate() {
        return this.signatureDate;
    }

    public void setSignatureDate(Instant signatureDate) {
        this.signatureDate = signatureDate;
    }

    public byte[] getSignatureImage() {
        return this.signatureImage;
    }

    public Rectangle getSignatureImageRectangle() {
        return this.signatureImageRectangle;
    }

    public void setSignatureImageRectangle(Rectangle rectangle) {
        this.signatureImageRectangle = rectangle;
    }

    public void setSignatureImage(byte[] signatureImage, Rectangle rectangle) {
        this.signatureImage = signatureImage;
        this.signatureImageRectangle = rectangle;
    }

    public String getSigningContact() {
        return this.signingContact;
    }

    public void setSigningContact(String signingContact) {
        this.signingContact = signingContact;
    }

    public String getSigningLocation() {
        return this.signingLocation;
    }

    public void setSigningLocation(String signingLocation) {
        this.signingLocation = signingLocation;
    }

    public String getSigningReason() {
        return this.signingReason;
    }

    public void setSigningReason(String signingReason) {
        this.signingReason = signingReason;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimeStampUrl() {
        return this.timeStampUrl;
    }

    public void setTimeStampUrl(String timeStampUrl) {
        this.timeStampUrl = timeStampUrl;
    }

    public int getInternalIndex() {
        return this.internalIndex;
    }
}

