package com.ironsoftware.ironpdf;
/**
 * Natural Languages Specification
 */
public enum NaturalLanguages {
    //region Non-specific Region

        /**
         * Arabic Language
         */
        Arabic(1),
        /**
         * Bengali Language
         */
        Bengali(2),
        /**
         * Chamorro Language
         */
        Chamorro(3),
        /**
         * Danish Language
         */
        Danish(4),
        /**
         * German Language
         */
        German(5),
        /**
         * Greek Language
         */
        Greek(6),
        /**
         * English Language
         */
        English(7),
        /**
         * Spanish Language
         */
        Spanish(8),
        /**
         * French Language
         */
        French(9),
        /**
         * Irish Language
         */
        Irish(10),
        /**
         * Croatian Language
         */
        Croatian(11),
        /**
         * Hungarian Language
         */
        Hungarian(12),
        /**
         * Italian Language
         */
        Italian(13),
        /**
         * Korean Language
         */
        Korean(14),
        /**
         * Lingala Language
         */
        Lingala(15),
        /**
         * Malay Language
         */
        Malay(16),
        /**
         * Dutch Language
         */
        Dutch(17),
        /**
         * Portuguese Language
         */
        Portuguese(18),
        /**
         * Sindhi Language
         */
        Sindhi(19),
        /**
         * Serbian Language
         */
        Serbian(20),
        /**
         * Swati Language
         */
        Swati(21),
        /**
         * Swedish Language
         */
        Swedish(22),
        /**
         * Swahili Language
         */
        Swahili(23),
        /**
         * Tamil Language
         */
        Tamil(24),
        /**
         * Tswana Language
         */
        Tswana(25),
        /**
         * Turkish Language
         */
        Turkish(26),
        /**
         * Urdu Language
         */
        Urdu(27),
        /**
         * Mandarin Chinese Language
         */
        MandarinChinese(28),

    //endregion

    //region Specific Region

        //region Arabic
        /**
         * Arabic Language for United Arab Emirates Region
         */
        Arabic_UnitedArabEmirates(29),
        /**
         * Arabic Language for Bahrain Region
         */
        Arabic_Bahrain(30),
        /**
         * Arabic Language for Algeria Region
         */
        Arabic_Algeria(31),
        /**
         * Arabic Language for Egypt Region
         */
        Arabic_Egypt(32),
        /**
         * Arabic Language for Israel Region
         */
        Arabic_Israel(33),
        /**
         * Arabic Language for Iraq Region
         */
        Arabic_Iraq(34),
        /**
         * Arabic Language for Jordan Region
         */
        Arabic_Jordan(35),
        /**
         * Arabic Language for Kuwait Region
         */
        Arabic_Kuwait(36),
        /**
         * Arabic Language for Lebanon Region
         */
        Arabic_Lebanon(37),
        /**
         * Arabic Language for Libya Region
         */
        Arabic_Libya(38),
        /**
         * Arabic Language for Morocco Region
         */
        Arabic_Morocco(39),
        /**
         * Arabic Language for Mauritania Region
         */
        Arabic_Mauritania(40),
        /**
         * Arabic Language for Oman Region
         */
        Arabic_Oman(41),
        /**
         * Arabic Language for Palestinian West Bank and Gaza Region
         */
        Arabic_PalestinianWestBankAndGaza(42),
        /**
         * Arabic Language for Qatar Region
         */
        Arabic_Qatar(43),
        /**
         * Arabic Language for Saudi Arabia Region
         */
        Arabic_SaudiArabia(44),
        /**
         * Arabic Language for Sudan Region
         */
        Arabic_Sudan(45),
        /**
         * Arabic Language for Somalia Region
         */
        Arabic_Somalia(46),
        /**
         * Arabic Language for Syria Region
         */
        Arabic_Syria(47),
        /**
         * Arabic Language for Chad Region
         */
        Arabic_Chad(48),
        /**
         * Arabic Language for Tunisia Region
         */
        Arabic_Tunisia(49),
        /**
         * Arabic Language for Yemen Region
         */
        Arabic_Yemen(50),
        //endregion

        //region Bengali
        /**
         * Bengali Language for Bangladesh Region
         */
        Bengali_Bangladesh(51),
        /**
         * Bengali Language for India Region
         */
        Bengali_India(52),
        /**
         * Bengali Language for Singapore Region
         */
        Bengali_Singapore(53),
        //endregion

        //region Chamorro
        /**
         * Chamorro Language for Guam Region
         */
        Chamorro_Guam(54),
        /**
         * Chamorro Language for Northern Mariana Islands Region
         */
        Chamorro_NorthernMarianaIslands(55),
        //endregion

        //region Welsh
        /**
         * Welsh Language for United Kingdom Region
         */
        Welsh_UnitedKingdom(56),
        //endregion

        //region Danish
        /**
         * Danish Language for Denmark Region
         */
        Danish_Denmark(57),
        /**
         * Danish Language for Greenland Region
         */
        Danish_Greenland(58),
        //endregion

        //region German
        /**
         * German Language for Austria Region
         */
        German_Austria(59),
        /**
         * German Language for Belgium Region
         */
        German_Belgium(60),
        /**
         * German Language for Switzerland Region
         */
        German_Switzerland(61),
        /**
         * German Language for Germany Region
         */
        German_Germany(62),
        /**
         * German Language for Denmark Region
         */
        German_Denmark(63),
        /**
         * German Language for Liechtensein Region
         */
        German_Liechtensein(64),
        /**
         * German Language for Luxembourg Region
         */
        German_Luxembourg(65),
        //endregion

        //region Greek
        /**
         * Greek Language for Cyprus Region
         */
        Greek_Cyprus(66),
        /**
         * Greek Language for Greece Region
         */
        Greek_Greece(67),
        //endregion

        //region English
        /**
         * English Language for Antigua and Barbuda Region
         */
        English_AntiguaAndBarbuda(68),
        /**
         * English Language for Anguilla Region
         */
        English_Anguilla(69),
        /**
         * English Language for American Samoa Region
         */
        English_AmericanSamoa(70),
        /**
         * English Language for Australia Region
         */
        English_Australia(71),
        /**
         * English Language for Barbados Region
         */
        English_Barbados(72),
        /**
         * English Language for Bermuda Region
         */
        English_Bermuda(73),
        /**
         * English Language for Brunei Region
         */
        English_Brunei(74),
        /**
         * English Language for Bahamas Region
         */
        English_Bahamas(75),
        /**
         * English Language for Botswana Region
         */
        English_Botswana(76),
        /**
         * English Language for Belize Region
         */
        English_Belize(77),
        /**
         * English Language for Canada Region
         */
        English_Canada(78),
        /**
         * English Language for Cook Islands Region
         */
        English_CookIslands(79),
        /**
         * English Language for Cameroon Region
         */
        English_Cameroon(80),
        /**
         * English Language for Dominica Region
         */
        English_Dominica(81),
        /**
         * English Language for Eritrea Region
         */
        English_Eritrea(82),
        /**
         * English Language for Ethiopia Region
         */
        English_Ethiopia(83),
        /**
         * English Language for Fiji Region
         */
        English_Fiji(84),
        /**
         * English Language for Falkland Islands Region
         */
        English_FalklandIslands(85),
        /**
         * English Language for Micronesia Region
         */
        English_Micronesia(86),
        /**
         * English Language for United Kingdom Region
         */
        English_UnitedKingdom(87),
        /**
         * English Language for Grenada Region
         */
        English_Grenada(88),
        /**
         * English Language for Ghana Region
         */
        English_Ghana(89),
        /**
         * English Language for Gibraltar Region
         */
        English_Gibraltar(90),
        /**
         * English Language for Gambia Region
         */
        English_Gambia(91),
        /**
         * English Language for Guam Region
         */
        English_Guam(92),
        /**
         * English Language for Guyana Region
         */
        English_Guyana(93),
        /**
         * English Language for Ireland Region
         */
        English_Ireland(94),
        /**
         * English Language for Israel Region
         */
        English_Israel(95),
        /**
         * English Language for British Indian Ocean Territ Region
         */
        English_BritishIndianOceanTerrit(96),
        /**
         * English Language for Jamaica Region
         */
        English_Jamaica(97),
        /**
         * English Language for Kenya Region
         */
        English_Kenya(98),
        /**
         * English Language for Kiribati Region
         */
        English_Kiribati(99),
        /**
         * English Language for St. Kitts-Nevis Region
         */
        English_StKittsNevis(100),
        /**
         * English Language for Cayman Islands Region
         */
        English_CaymanIslands(101),
        /**
         * English Language for St. Lucia Region
         */
        English_StLucia(102),
        /**
         * English Language for Liberia Region
         */
        English_Liberia(103),
        /**
         * English Language for Lesotho Region
         */
        English_Lesotho(104),
        /**
         * English Language for Northern Mariana Islands Region
         */
        English_NorthernMarianaIslands(105),
        /**
         * English Language for Montserrat Region
         */
        English_Montserrat(106),
        /**
         * English Language for Malta Region
         */
        English_Malta(107),
        /**
         * English Language for Mauritius Region
         */
        English_Mauritius(108),
        /**
         * English Language for Malawi Region
         */
        English_Malawi(109),
        /**
         * English Language for Namibia Region
         */
        English_Namibia(110),
        /**
         * English Language for Norfolk Island Region
         */
        English_NorfolkIsland(111),
        /**
         * English Language for Nigeria Region
         */
        English_Nigeria(112),
        /**
         * English Language for Nauru Region
         */
        English_Nauru(113),
        /**
         * English Language for Niue Region
         */
        English_Niue(114),
        /**
         * English Language for New Zealand Region
         */
        English_NewZealand(115),
        /**
         * English Language for Papua New Guinea Region
         */
        English_PapuaNewGuinea(116),
        /**
         * English Language for Philippines Region
         */
        English_Philippines(117),
        /**
         * English Language for Pakistan Region
         */
        English_Pakistan(118),
        /**
         * English Language for Pitcairn Region
         */
        English_Pitcairn(119),
        /**
         * English Language for Puerto Rico Region
         */
        English_PuertoRico(120),
        /**
         * English Language for Palau Region
         */
        English_Palau(121),
        /**
         * English Language for Rwanda Region
         */
        English_Rwanda(122),
        /**
         * English Language for Solomon Islands Region
         */
        English_SolomonIslands(123),
        /**
         * English Language for Seychelles Region
         */
        English_Seychelles(124),
        /**
         * English Language for Singapore Region
         */
        English_Singapore(125),
        /**
         * English Language for St. Helena Region
         */
        English_StHelena(126),
        /**
         * English Language for Sierra Leone Region
         */
        English_SierraLeone(127),
        /**
         * English Language for Somalia Region
         */
        English_Somalia(128),
        /**
         * English Language for Swaziland Region
         */
        English_Swaziland(129),
        /**
         * English Language for Turks and Caicos Islands Region
         */
        English_TurksAndCaicosIslands(130),
        /**
         * English Language for Tokelau Region
         */
        English_Tokelau(131),
        /**
         * English Language for Tonga Region
         */
        English_Tonga(132),
        /**
         * English Language for Trinidad and Tobago Region
         */
        English_TrinidadAndTobago(133),
        /**
         * English Language for Uganda Region
         */
        English_Uganda(134),
        /**
         * English Language for United States of America Region
         */
        English_USA(135),
        /**
         * English Language for St. Vincent and the Grenadi Region
         */
        English_StVincentAndTheGrenadi(136),
        /**
         * English Language for British Virgin Islands Region
         */
        English_BritishVirginIslands(137),
        /**
         * English Language for U.S. Virgin Islands Region
         */
        English_USVirginIslands(138),
        /**
         * English Language for Vanuatu Region
         */
        English_Vanuatu(139),
        /**
         * English Language for Western Samoa Region
         */
        English_WesternSamoa(140),
        /**
         * English Language for South Africa Region
         */
        English_SouthAfrica(141),
        /**
         * English Language for Zambia Region
         */
        English_Zambia(142),
        /**
         * English Language for Zimbabwe Region
         */
        English_Zimbabwe(143),
        //endregion

        //region Spanish
        /**
         * Spanish Language for Argentina Region
         */
        Spanish_Argentina(144),
        /**
         * Spanish Language for Bolivia Region
         */
        Spanish_Bolivia(145),
        /**
         * Spanish Language for Chile Region
         */
        Spanish_Chile(146),
        /**
         * Spanish Language for Colombia Region
         */
        Spanish_Colombia(147),
        /**
         * Spanish Language for Costa Rica Region
         */
        Spanish_CostaRica(148),
        /**
         * Spanish Language for Cuba Region
         */
        Spanish_Cuba(149),
        /**
         * Spanish Language for Dominican Republic Region
         */
        Spanish_DominicanRepublic(150),
        /**
         * Spanish Language for Ecuador Region
         */
        Spanish_Ecuador(151),
        /**
         * Spanish Language for Spain Region
         */
        Spanish_Spain(152),
        /**
         * Spanish Language for Equatorial Guinea Region
         */
        Spanish_EquatorialGuinea(153),
        /**
         * Spanish Language for Guatemala Region
         */
        Spanish_Guatemala(154),
        /**
         * Spanish Language for Honduras Region
         */
        Spanish_Honduras(155),
        /**
         * Spanish Language for Mexico Region
         */
        Spanish_Mexico(156),
        /**
         * Spanish Language for Nicaragua Region
         */
        Spanish_Nicaragua(157),
        /**
         * Spanish Language for Panama Region
         */
        Spanish_Panama(158),
        /**
         * Spanish Language for Peru Region
         */
        Spanish_Peru(159),
        /**
         * Spanish Language for Puerto Rico Region
         */
        Spanish_PuertoRico(160),
        /**
         * Spanish Language for Paraguay Region
         */
        Spanish_Paraguay(161),
        /**
         * Spanish Language for El Salvador Region
         */
        Spanish_ElSalvador(162),
        /**
         * Spanish Language for United States of America Region
         */
        Spanish_USA(163),
        /**
         * Spanish Language for Uruguay Region
         */
        Spanish_Uruguay(164),
        /**
         * Spanish Language for Venezuela Region
         */
        Spanish_Venezuela(165),
        //endregion

        //region French
        /**
         * French Language for Andorra Region
         */
        French_Andorra(166),
        /**
         * French Language for Belgium Region
         */
        French_Belgium(167),
        /**
         * French Language for Burkina Faso Region
         */
        French_BurkinaFaso(168),
        /**
         * French Language for Burundi Region
         */
        French_Burundi(169),
        /**
         * French Language for Benin Region
         */
        French_Benin(170),
        /**
         * French Language for Canada Region
         */
        French_Canada(171),
        /**
         * French Language for Democratic Republic of Congo Region
         */
        French_DemocraticRepublicOfCongo(172),
        /**
         * French Language for Central African Republic Region
         */
        French_CentralAfricanRepublic(173),
        /**
         * French Language for Congo Region
         */
        French_Congo(174),
        /**
         * French Language for Switzerland Region
         */
        French_Switzerland(175),
        /**
         * French Language for Cote d'Ivoire Region
         */
        French_CoteDIvoire(176),
        /**
         * French Language for Cameroon Region
         */
        French_Cameroon(177),
        /**
         * French Language for Djibouti Region
         */
        French_Djibouti(178),
        /**
         * French Language for France Region
         */
        French_France(179),
        /**
         * French Language for Gabon Region
         */
        French_Gabon(180),
        /**
         * French Language for United Kingdom Region
         */
        French_UnitedKingdom(181),
        /**
         * French Language for French Guiana Region
         */
        French_FrenchGuiana(182),
        /**
         * French Language for Guinea Region
         */
        French_Guinea(183),
        /**
         * French Language for Guadeloupe Region
         */
        French_Guadeloupe(184),
        /**
         * French Language for Haiti Region
         */
        French_Haiti(185),
        /**
         * French Language for Italy Region
         */
        French_Italy(186),
        /**
         * French Language for Comoros Islands Region
         */
        French_ComorosIslands(187),
        /**
         * French Language for Lebanon Region
         */
        French_Lebanon(188),
        /**
         * French Language for Luxembourg Region
         */
        French_Luxembourg(189),
        /**
         * French Language for Monaco Region
         */
        French_Monaco(190),
        /**
         * French Language for Madagascar Region
         */
        French_Madagascar(191),
        /**
         * French Language for Mali Region
         */
        French_Mali(192),
        /**
         * French Language for Martinique Region
         */
        French_Martinique(193),
        /**
         * French Language for New Caledonia Region
         */
        French_NewCaledonia(194),
        /**
         * French Language for French Polynesia Region
         */
        French_FrenchPolynesia(195),
        /**
         * French Language for St. Pierre and Miquelon Region
         */
        French_StPierreAndMiquelon(196),
        /**
         * French Language for Reunion Region
         */
        French_Reunion(197),
        /**
         * French Language for Rwanda Region
         */
        French_Rwanda(198),
        /**
         * French Language for Seychelles Region
         */
        French_Seychelles(199),
        /**
         * French Language for Chad Region
         */
        French_Chad(200),
        /**
         * French Language for Togo Region
         */
        French_Togo(201),
        /**
         * French Language for Vanuatu Region
         */
        French_Vanuatu(202),
        /**
         * French Language for Wallis and Futuna Region
         */
        French_WallisAndFutuna(203),
        /**
         * French Language for Mayotte Region
         */
        French_Mayotte(204),
        //endregion

        //region Irish
        /**
         * Irish Language for United Kingdom Region
         */
        Irish_UnitedKingdom(205),
        /**
         * Irish Language for Ireland Region
         */
        Irish_Ireland(206),
        //endregion

        //region Gaelic
        /**
         * Gaelic Language for United Kingdom Region
         */
        Gaelic_UnitedKingdom(207),
        //endregion

        //region Manx
        /**
         * Manx Language for United Kingdom Region
         */
        Manx_UnitedKingdom(208),
        //endregion

        //region Croatian
        /**
         * Croatian Language for Bosnia-Herzegovina Region
         */
        Croatian_BosniaHerzegovina(209),
        /**
         * Croatian Language for Croatia Region
         */
        Croatian_Croatia(210),
        //endregion

        //region Hungarian
        /**
         * Hungarian Language for Hungary Region
         */
        Hungarian_Hungary(211),
        /**
         * Hungarian Language for Slovenia Region
         */
        Hungarian_Slovenia(212),
        //endregion

        //region Italian
        /**
         * Italian Language for Switzerland Region
         */
        Italian_Switzerland(213),
        /**
         * Italian Language for Croatia Region
         */
        Italian_Croatia(214),
        /**
         * Italian Language for Italy Region
         */
        Italian_Italy(215),
        /**
         * Italian Language for Slovenia Region
         */
        Italian_Slovenia(216),
        /**
         * Italian Language for San Marino Region
         */
        Italian_SanMarino(217),
        //endregion

        //region Korean
        /**
         * Korean Language for Korea, North Region
         */
        Korean_KoreaNorth(218),
        /**
         * Korean Language for Korea, South Region
         */
        Korean_KoreaSouth(219),
        //endregion

        //region Cornish
        /**
         * Cornish Language for United Kingdom Region
         */
        Cornish_UnitedKingdom(220),
        //endregion

        //region Lingala
        /**
         * Lingala Language for Democratic Republic of Congo Region
         */
        Lingala_DemocraticRepublicOfCongo(221),
        /**
         * Lingala Language for Congo Region
         */
        Lingala_Congo(222),
        //endregion

        //region Malay
        /**
         * Malay Language for Brunei Region
         */
        Malay_Brunei(223),
        /**
         * Malay Language for Malaysia Region
         */
        Malay_Malaysia(224),
        /**
         * Malay Language for Singapore Region
         */
        Malay_Singapore(225),
        //endregion

        //region Dutch
        /**
         * Dutch Language for Netherlands Antilles Region
         */
        Dutch_NetherlandsAntilles(226),
        /**
         * Dutch Language for Aruba Region
         */
        Dutch_Aruba(227),
        /**
         * Dutch Language for Belgium Region
         */
        Dutch_Belgium(228),
        /**
         * Dutch Language for Netherlands Region
         */
        Dutch_Netherlands(229),
        /**
         * Dutch Language for Suriname Region
         */
        Dutch_Suriname(230),
        //endregion

        //region Portuguese
        /**
         * Portuguese Language for Angola Region
         */
        Portuguese_Angola(231),
        /**
         * Portuguese Language for Brazil Region
         */
        Portuguese_Brazil(232),
        /**
         * Portuguese Language for Cape Verde Islands Region
         */
        Portuguese_CapeVerdeIslands(233),
        /**
         * Portuguese Language for Guinea-Bissau Region
         */
        Portuguese_GuineaBissau(234),
        /**
         * Portuguese Language for Mozambique Region
         */
        Portuguese_Mozambique(235),
        /**
         * Portuguese Language for Portugal Region
         */
        Portuguese_Portugal(236),
        /**
         * Portuguese Language for São Tomé e Principe Region
         */
        Portuguese_SaoTomeEPrincipe(237),
        //endregion

        //region Sindhi
        /**
         * Sindhi Language for India Region
         */
        Sindhi_India(238),
        /**
         * Sindhi Language for Pakistan Region
         */
        Sindhi_Pakistan(239),
        //endregion

        //region Serbian
        /**
         * Serbian Language for Bosnia-Herzegovina Region
         */
        Serbian_BosniaHerzegovina(240),
        /**
         * Serbian Language for Yugoslavia Region
         */
        Serbian_Yugoslavia(241),
        //endregion

        //region Swati
        /**
         * Swati Language for Swaziland Region
         */
        Swati_Swaziland(242),
        /**
         * Swati Language for South Africa Region
         */
        Swati_SouthAfrica(243),
        //endregion

        //region Swedish
        /**
         * Swedish Language for Finland Region
         */
        Swedish_Finland(244),
        /**
         * Swedish Language for Sweden Region
         */
        Swedish_Sweden(245),
        //endregion

        //region Swahili
        /**
         * Swahili Language for Kenya Region
         */
        Swahili_Kenya(246),
        /**
         * Swahili Language for Tanzania Region
         */
        Swahili_Tanzania(247),
        //endregion

        //region Tamil
        /**
         * Tamil Language for India Region
         */
        Tamil_India(248),
        /**
         * Tamil Language for Singapore Region
         */
        Tamil_Singapore(249),
        //endregion

        //region Tswana
        /**
         * Tswana Language for Botswana Region
         */
        Tswana_Botswana(250),
        /**
         * Tswana Language for South Africa Region
         */
        Tswana_SouthAfrica(251),
        //endregion

        //region Turkish
        /**
         * Turkish Language for Bulgaria Region
         */
        Turkish_Bulgaria(252),
        /**
         * Turkish Language for Cyprus Region
         */
        Turkish_Cyprus(253),
        /**
         * Turkish Language for Turkey Region
         */
        Turkish_Turkey(254),
        //endregion

        //region Urdu
        /**
         * Urdu Language for India Region
         */
        Urdu_India(255),
        /**
         * Urdu Language for Pakistan Region
         */
        Urdu_Pakistan(256),
        //endregion

        //region Mandarin Chinese
        /**
         * Mandarin Chinese Language for China Region
         */
        MandarinChinese_China(257),
        /**
         * Mandarin Chinese Language for Singapore Region
         */
        MandarinChinese_Singapore(258),
        /**
         * Mandarin Chinese Language for Taiwan Region
         */
        MandarinChinese_Taiwan(259);
        //endregion

        private final int value;

        private NaturalLanguages(int value){
            this.value = value;
        }

        public int getValue() {
            return value;
        }

    //endregion
}