/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.IronPdfEngineConnection;
import com.ironsoftware.ironpdf.internal.proto.HandshakeRequestP;
import com.ironsoftware.ironpdf.internal.proto.HandshakeResponseP;
import com.ironsoftware.ironpdf.internal.staticapi.ConfigLoader;
import com.ironsoftware.ironpdf.internal.staticapi.DownloadInputStream;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.License_Api;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Setting_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_StringHelper;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.okhttp.OkHttpChannelBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Access {
    static final Logger logger = LoggerFactory.getLogger(Access.class);
    static final Logger engineLogger = LoggerFactory.getLogger((String)"com.ironsoftware.ironpdf.IronPdfEngine");
    static RpcClient client = null;
    static boolean isTryDownloaded = false;
    private static ManagedChannel channel = null;
    private static Process ironPdfProcess = null;
    private static boolean tryAgain = true;
    private static BufferedReader stdInput;
    private static BufferedReader stdError;
    private static CountDownLatch serverReady;
    private static final int MAX_RETRY_ATTEMPTS = 20;

    Access() {
    }

    private static ManagedChannel createChannel() {
        int attempts = 0;
        Exception lastException = new Exception("unknown reason");
        while (attempts < 20) {
            try {
                if (Setting_Api.useDeprecatedConnectionSettings) {
                    return ManagedChannelBuilder.forAddress((String)Setting_Api.subProcessHost, (int)Setting_Api.subProcessPort).usePlaintext().build();
                }
                logger.info("Connecting to " + Setting_Api.connectionMode.toString());
                switch (Setting_Api.connectionMode.getMode()) {
                    case SUBPROCESS: 
                    case HOST_PORT: {
                        if (Access.isAndroid()) {
                            return OkHttpChannelBuilder.forAddress((String)Setting_Api.connectionMode.getHost(), (int)Setting_Api.connectionMode.getPort()).usePlaintext().build();
                        }
                        return ManagedChannelBuilder.forAddress((String)Setting_Api.connectionMode.getHost(), (int)Setting_Api.connectionMode.getPort()).usePlaintext().build();
                    }
                    case TARGET: 
                    case OFFICIAL_CLOUD: {
                        if (Access.isAndroid()) {
                            SSLContext sslContext = SSLContext.getInstance("TLS");
                            sslContext.init(null, InsecureTrustManagerFactory.INSTANCE.getTrustManagers(), null);
                            return OkHttpChannelBuilder.forTarget((String)Setting_Api.connectionMode.getTarget()).sslSocketFactory(sslContext.getSocketFactory()).build();
                        }
                        return NettyChannelBuilder.forTarget((String)Setting_Api.connectionMode.getTarget()).negotiationType(NegotiationType.TLS).useTransportSecurity().sslContext(GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build()).build();
                    }
                    case CUSTOM: {
                        return Setting_Api.connectionMode.getCustomChannel();
                    }
                }
            }
            catch (Exception e) {
                lastException = e;
                logger.info("Failed to connect IronPdfEngine. (Retry " + ++attempts + "/" + 20 + ")");
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (Setting_Api.useDeprecatedConnectionSettings) {
            throw new RuntimeException(String.format("Cannot connected to IronPdfEngine: %s:%d", Setting_Api.subProcessHost, Setting_Api.subProcessPort), lastException);
        }
        throw new RuntimeException(String.format("Cannot connected to %s", Setting_Api.connectionMode.toString()), lastException);
    }

    private static HandshakeResponseP handshakeWithRetry(RpcClient newClient) {
        HandshakeRequestP.Builder handshakeRequest = HandshakeRequestP.newBuilder();
        handshakeRequest.setExpectedVersion("2025.6.5");
        handshakeRequest.setProgLang("java");
        int attempts = 0;
        Exception lastException = new Exception("unknown reason");
        while (attempts < 20) {
            try {
                return newClient.GetBlockingStub("handshake").handshake(handshakeRequest.build());
            }
            catch (Exception exception) {
                lastException = exception;
                logger.info("Waiting for IronPdfEngine is ready. (Retry " + ++attempts + "/" + 20 + ")");
                try {
                    TimeUnit.SECONDS.sleep(4L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw new RuntimeException(String.format("Cannot handshake with IronPdfEngine: %s:%d due to:", Setting_Api.subProcessHost, Setting_Api.subProcessPort), lastException);
    }

    static synchronized RpcClient ensureConnection() {
        if (client != null) {
            return client;
        }
        if (Setting_Api.useDeprecatedConnectionSettings) {
            if (!Setting_Api.isIronPdfEngineDocker) {
                Access.startServer();
            }
        } else if (Setting_Api.connectionMode.getMode() == IronPdfEngineConnection.ConnectionMode.SUBPROCESS) {
            Access.startServer();
        }
        if (channel == null) {
            channel = Access.createChannel();
        }
        RpcClient newClient = new RpcClient(channel);
        logger.debug("Handshaking, Expected IronPdfEngine Version : 2025.6.5");
        HandshakeResponseP handshakeResult = Access.handshakeWithRetry(newClient);
        logger.debug("Handshake result:" + handshakeResult);
        switch (handshakeResult.getResultOrExceptionCase()) {
            case SUCCESS: {
                client = newClient;
                Access.setLicenseKey();
                return client;
            }
            case REQUIREDVERSION: {
                logger.warn(String.format("Mismatch IronPdfEngine version expected: %s but found: %s", "2025.6.5", handshakeResult.getRequiredVersion()));
                if (tryAgain) {
                    if (Setting_Api.useDeprecatedConnectionSettings) {
                        if (!Setting_Api.isIronPdfEngineDocker) {
                            tryAgain = false;
                            Access.stopIronPdfEngine();
                            Access.downloadIronPdfEngine();
                            return Access.ensureConnection();
                        }
                    } else if (Setting_Api.connectionMode.getMode() == IronPdfEngineConnection.ConnectionMode.SUBPROCESS) {
                        tryAgain = false;
                        Access.stopIronPdfEngine();
                        Access.downloadIronPdfEngine();
                        return Access.ensureConnection();
                    }
                }
                client = newClient;
                Access.setLicenseKey();
                return client;
            }
            case EXCEPTION: {
                throw Exception_Converter.fromProto(handshakeResult.getException());
            }
        }
        throw new RuntimeException("Unexpected result from handshake");
    }

    static void setLicenseKey() {
        String lk;
        String string = lk = Utils_StringHelper.isNullOrWhiteSpace(Setting_Api.licenseKey) ? new ConfigLoader().getProperty("IRONPDF_LICENSE_KEY") : Setting_Api.licenseKey;
        if (!Utils_StringHelper.isNullOrWhiteSpace(lk)) {
            License_Api.SetLicensed(lk);
        }
    }

    static synchronized void downloadIronPdfEngine() {
        try {
            if (isTryDownloaded) {
                return;
            }
            Path zipFilePath = Paths.get(Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath().toString(), Setting_Api.getIronPdfEngineZipName());
            Utils_Util.logInfoOrSystemOut(logger, "Download IronPdfEngine to working dir: " + zipFilePath.toAbsolutePath());
            Utils_Util.logInfoOrSystemOut(logger, "You can skip this downloading step by adding IronPdfEngine as a Maven dependency. see: https://github.com/iron-software/IronPDF-for-Java#install-ironpdf-engine-as-a-maven-dependency");
            isTryDownloaded = true;
            URL downloadUrl = new URL("https://ironpdfengine.azurewebsites.net/api/IronPdfEngineDownload?version=2025.6.5&platform=" + Setting_Api.currentOsFullName() + "&architect=" + Setting_Api.currentOsArch());
            try (InputStream stream = downloadUrl.openStream();){
                long downloadSize = stream.available();
                try (DownloadInputStream pis = new DownloadInputStream(stream, downloadSize, logger);){
                    FileUtils.copyInputStreamToFile((InputStream)pis, (File)zipFilePath.toFile());
                }
            }
            Path unzippedFolder = Paths.get(Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath().toString(), Setting_Api.getIronPdfEngineFolderName());
            Utils_Util.logInfoOrSystemOut(logger, "Unzipping IronPdfEngine to dir: " + unzippedFolder);
            Access.unzip(zipFilePath.toAbsolutePath().toString(), unzippedFolder.toAbsolutePath().toString());
            logger.info("Delete zip file: " + zipFilePath.toAbsolutePath());
            Files.deleteIfExists(zipFilePath.toAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Failed to download IronPdfEngine binary", (Throwable)e);
            throw new RuntimeException("Failed to download IronPdfEngine binary", e);
        }
    }

    static void unzip(String zipFilePath, String destDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(entryDestination.toPath(), new FileAttribute[0]);
                    Access.setPermission(entryDestination);
                    continue;
                }
                File parentDir = entryDestination.getParentFile();
                Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
                Access.setPermission(parentDir);
                InputStream in = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    OutputStream out = Files.newOutputStream(entryDestination.toPath(), new OpenOption[0]);
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    static synchronized void startServer() {
        block13: {
            try {
                String serverHost = Setting_Api.useDeprecatedConnectionSettings ? Setting_Api.subProcessHost : Setting_Api.connectionMode.getHost();
                int serverPort = Setting_Api.useDeprecatedConnectionSettings ? Setting_Api.subProcessPort : Setting_Api.connectionMode.getPort();
                Optional<File> selectedFile = Access.getAvailableIronPdfEngineFile();
                if (selectedFile.isPresent()) {
                    logger.info("Using IronPdfEngine from: " + selectedFile.get().getAbsolutePath());
                    try {
                        try {
                            File parentDir = selectedFile.get().getParentFile();
                            Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
                            Access.setPermission(parentDir);
                        }
                        catch (Exception e) {
                            logger.warn("Cannot set IronPdfEngine parent folder permission ", (Throwable)e);
                        }
                        Arrays.stream((Object[])Objects.requireNonNull(selectedFile.get().getParentFile().listFiles())).forEach(file -> {
                            try {
                                Access.setPermission(file);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.warn("Cannot set IronPdfEngine files permission ", (Throwable)e);
                    }
                    ArrayList<String> cmdList = new ArrayList<String>();
                    cmdList.add(selectedFile.get().toPath().toAbsolutePath().toString());
                    cmdList.add("host=" + serverHost);
                    cmdList.add("port=" + serverPort);
                    cmdList.add("enable_debug=" + Setting_Api.enableDebug);
                    cmdList.add("log_path=" + Setting_Api.logPath);
                    cmdList.add("programming_language=java");
                    cmdList.add("single_process=" + (Setting_Api.singleProcess || Setting_Api.currentOsFullName().equalsIgnoreCase("MacOS")));
                    cmdList.add("docker_build=false");
                    cmdList.add("linux_and_docker_auto_config=" + Setting_Api.linuxAndDockerAutoConfig);
                    cmdList.add("skip_initialization=false");
                    cmdList.add("chrome_browser_limit=" + Setting_Api.chromeBrowserLimit);
                    if (Setting_Api.chromeBrowserCachePath != null) {
                        cmdList.add("chrome_cache_path=" + Setting_Api.chromeBrowserCachePath.toAbsolutePath());
                    }
                    cmdList.add("chrome_gpu_mode=" + Setting_Api.chromeGpuMode);
                    if (Setting_Api.tempFolderPath != null) {
                        cmdList.add("temp_folder_path=" + Setting_Api.tempFolderPath.toAbsolutePath());
                    }
                    if (!Utils_StringHelper.isNullOrWhiteSpace(Setting_Api.licenseKey)) {
                        cmdList.add("license_key=" + Setting_Api.licenseKey);
                    } else {
                        cmdList.add("license_key=" + new ConfigLoader().getProperty("IRONPDF_LICENSE_KEY"));
                    }
                    serverReady = new CountDownLatch(1);
                    ProcessBuilder pb = new ProcessBuilder(cmdList);
                    logger.info("Start IronPdfEngine");
                    if (Setting_Api.enableDebug) {
                        logger.debug("options: " + cmdList);
                    }
                    Process proc = pb.start();
                    Access.catchServerMessage(proc);
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                        Access.shutdownChanel();
                        logger.info("Shutdown IronPdfEngine process");
                        proc.destroy();
                    }));
                    boolean ignored = serverReady.await(60L, TimeUnit.SECONDS);
                    ironPdfProcess = proc;
                    break block13;
                }
                logger.debug("Cannot find IronPdfEngine from ironPdf working dir:" + Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath());
                if (tryAgain) {
                    Access.downloadIronPdfEngine();
                    logger.info("Try to start IronPdfEngine again");
                    tryAgain = false;
                    Access.startServer();
                    break block13;
                }
                throw new RuntimeException(String.format("Cannot locate IronPdfEngine. at %1$s", Setting_Api.getIronPdfEngineExecutablePath(Setting_Api.ironPdfEngineWorkingDirectory).toAbsolutePath()) + " An alternative approach is to install one of ironpdf-engine packages https://search.maven.org/search?q=ironpdf%20engine, more information: https://github.com/iron-software/IronPDF-for-Java#install-ironpdf-engine-as-a-maven-dependency");
            }
            catch (Exception e) {
                logger.error("Cannot start IronPdfEngine (working dir: " + Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath() + ")", (Throwable)e);
                e.printStackTrace();
                throw new RuntimeException("Cannot start IronPdfEngine due to " + e.getMessage(), e);
            }
        }
    }

    private static void catchServerMessage(Process proc) {
        stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        Thread threadInput = new Thread(() -> {
            engineLogger.debug("listening IronPdfEngine");
            stdInput.lines().forEach(line -> {
                if (line.trim().equalsIgnoreCase("IronPdfEngine is up")) {
                    serverReady.countDown();
                }
                if (Setting_Api.enableDebug) {
                    engineLogger.info("[IronPdfEngine]" + line);
                }
            });
        });
        threadInput.setDaemon(true);
        threadInput.start();
        stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        Thread threadError = new Thread(() -> stdError.lines().forEach(line -> {}));
        threadError.setDaemon(true);
        threadError.start();
    }

    private static void shutdownChanel() {
        if (channel != null && !channel.isShutdown() && !channel.isTerminated()) {
            channel.shutdown();
            channel = null;
        }
    }

    public static void stopIronPdfEngine() {
        Access.shutdownChanel();
        if (ironPdfProcess != null) {
            ironPdfProcess.destroy();
        }
        ironPdfProcess = null;
        client = null;
    }

    private static void setPermission(File file) {
        try {
            boolean setExecutablePermissionResult = file.setExecutable(true, false);
            boolean setWritablePermissionResult = file.setWritable(true, false);
            boolean setReadablePermissionResult = file.setReadable(true, false);
            logger.debug(file.getAbsolutePath() + " permission status:" + System.lineSeparator() + " Executable:" + setExecutablePermissionResult + System.lineSeparator() + " Writable:" + setWritablePermissionResult + System.lineSeparator() + " Readable:" + setReadablePermissionResult);
        }
        catch (Exception exception) {
            logger.warn("Set permission failed : " + file.getAbsolutePath(), (Throwable)exception);
        }
    }

    private static Optional<File> getAvailableIronPdfEngineFile() {
        Path binFromWorkingDir = Setting_Api.getIronPdfEngineExecutablePath(Setting_Api.ironPdfEngineWorkingDirectory);
        try {
            if (Files.exists(binFromWorkingDir, new LinkOption[0])) {
                logger.info("IronPdfEngine found at: " + binFromWorkingDir);
                return Optional.of(binFromWorkingDir.toFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("IronPdfEngine not found at IronPdfEngine working directory: " + binFromWorkingDir.toAbsolutePath());
        try {
            String engineResourceClassName = "com.ironsoftware.ironpdf.internal.EngineResource" + Setting_Api.currentOsFullName() + Setting_Api.currentOsArch();
            try (InputStream inputStream = Class.forName(engineResourceClassName).getResourceAsStream("/" + Setting_Api.getIronPdfEngineFolderName() + ".zip");){
                Path zipFilePath = Paths.get(Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath().toString(), Setting_Api.getIronPdfEngineFolderName() + ".zip");
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)zipFilePath.toFile());
                Path unzipTargetPath = Paths.get(Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath().toString(), Setting_Api.getIronPdfEngineFolderName() + "/");
                Utils_Util.logInfoOrSystemOut(logger, "Unzipping IronPdfEngine (from dependency) to dir: " + unzipTargetPath);
                Access.unzip(zipFilePath.toAbsolutePath().toString(), unzipTargetPath.toAbsolutePath().toString());
                Files.deleteIfExists(zipFilePath.toAbsolutePath());
            }
            if (Files.exists(binFromWorkingDir, new LinkOption[0])) {
                logger.info("IronPdfEngine found (extracted from ironpdf-engine package) (EngineResource) at: " + binFromWorkingDir);
                return Optional.of(binFromWorkingDir.toFile());
            }
        }
        catch (ClassNotFoundException ignored) {
            logger.debug("Cannot detect IronPdfEngine from ironpdf-engine package, skipped");
        }
        catch (Exception e) {
            logger.debug("IronPdfEngine from ironpdf-engine package not found", (Throwable)e);
        }
        Path binFromUserDir = Setting_Api.getIronPdfEngineExecutablePath(Paths.get(System.getProperty("user.dir"), new String[0]));
        try {
            if (Files.exists(binFromUserDir, new LinkOption[0])) {
                logger.info("IronPdfEngine found at: " + binFromUserDir);
                return Optional.of(binFromUserDir.toFile());
            }
        }
        catch (Exception inputStream) {
            // empty catch block
        }
        logger.debug("IronPdfEngine not found at: (System.getProperty(\"user.dir\")): " + binFromUserDir.toAbsolutePath());
        Path binFromCurrentDir = Setting_Api.getIronPdfEngineExecutablePath(Paths.get(".", new String[0]));
        try {
            if (Files.exists(binFromCurrentDir, new LinkOption[0])) {
                logger.info("IronPdfEngine found at: " + binFromCurrentDir);
                return Optional.of(binFromCurrentDir.toFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("IronPdfEngine not found at current dir: " + binFromCurrentDir.toAbsolutePath());
        return Optional.empty();
    }

    public static boolean isAndroid() {
        try {
            Class.forName("android.os.Build");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

