/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.google.protobuf.ByteString;
import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.IronPdfServiceGrpc;
import com.ironsoftware.ironpdf.internal.proto.PdfiumAddPdfAttachmentRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumAddPdfAttachmentResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetPdfAttachmentCountRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetPdfAttachmentCountResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetPdfAttachmentDataRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetPdfAttachmentDataResultStreamP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetPdfAttachmentNameRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetPdfAttachmentNameResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumRemovePdfAttachmentRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumSetPdfAttachmentDataRequestStreamP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_ReceivingCustomStreamObserver;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Attachment_Api {
    public static List<String> getPdfAttachmentCollection(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        IronPdfServiceGrpc.IronPdfServiceBlockingStub stub = client.GetBlockingStub("getPdfAttachmentCollection");
        PdfiumGetPdfAttachmentCountResultP countResultP = stub.pdfiumAttachmentGetPdfAttachmentCount(PdfiumGetPdfAttachmentCountRequestP.newBuilder().setDocument(internalPdfDocument.remoteDocument).build());
        if (countResultP.hasException()) {
            throw Exception_Converter.fromProto(countResultP.getException());
        }
        return IntStream.range(0, countResultP.getResult()).mapToObj(attachmentIndex -> {
            PdfiumGetPdfAttachmentNameRequestP.Builder req = PdfiumGetPdfAttachmentNameRequestP.newBuilder();
            req.setDocument(internalPdfDocument.remoteDocument);
            req.setIndex(attachmentIndex);
            PdfiumGetPdfAttachmentNameResultP res = stub.pdfiumAttachmentGetPdfAttachmentName(req.build());
            if (res.getResultOrExceptionCase() == PdfiumGetPdfAttachmentNameResultP.ResultOrExceptionCase.EXCEPTION) {
                throw Exception_Converter.fromProto(res.getException());
            }
            return res.getResult();
        }).collect(Collectors.toList());
    }

    public static byte[] getPdfAttachmentData(InternalPdfDocument internalPdfDocument, String name) {
        int index = Attachment_Api.getPdfAttachmentCollection(internalPdfDocument).indexOf(name);
        if (index == -1) {
            throw new RuntimeException(String.format("not found Attachment name: %s", name));
        }
        return Attachment_Api.getPdfAttachmentData(internalPdfDocument, index);
    }

    public static byte[] getPdfAttachmentData(InternalPdfDocument internalPdfDocument, int index) {
        RpcClient client = Access.ensureConnection();
        PdfiumGetPdfAttachmentDataRequestP.Builder req = PdfiumGetPdfAttachmentDataRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setIndex(index);
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList msgChunks = new ArrayList();
        client.GetStub("getPdfAttachmentData").pdfiumAttachmentGetPdfAttachmentData(req.build(), new Utils_ReceivingCustomStreamObserver<PdfiumGetPdfAttachmentDataResultStreamP>(finishLatch, msgChunks));
        Utils_Util.waitAndCheck(finishLatch, msgChunks);
        List<byte[]> bytesChunks = msgChunks.stream().map(res -> {
            if (res.getResultOrExceptionCase() == PdfiumGetPdfAttachmentDataResultStreamP.ResultOrExceptionCase.EXCEPTION) {
                throw Exception_Converter.fromProto(res.getException());
            }
            return res.getResultChunk().toByteArray();
        }).collect(Collectors.toList());
        return Utils_Util.combineChunk(bytesChunks);
    }

    public static void addPdfAttachment(InternalPdfDocument internalPdfDocument, String name, byte[] attachmentBytes) {
        RpcClient client = Access.ensureConnection();
        PdfiumAddPdfAttachmentResultP addPdfAttachmentResultP = client.GetBlockingStub("addPdfAttachment").pdfiumAttachmentAddPdfAttachment(PdfiumAddPdfAttachmentRequestP.newBuilder().setDocument(internalPdfDocument.remoteDocument).setName(name).build());
        if (addPdfAttachmentResultP.hasException()) {
            throw Exception_Converter.fromProto(addPdfAttachmentResultP.getException());
        }
        int attachmentIndex = addPdfAttachmentResultP.getResult();
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<EmptyResultP> resultChunks = new ArrayList<EmptyResultP>();
        StreamObserver<PdfiumSetPdfAttachmentDataRequestStreamP> requestStream = client.GetStub("addPdfAttachment").pdfiumAttachmentSetPdfAttachmentData(new Utils_ReceivingCustomStreamObserver<EmptyResultP>(finishLatch, resultChunks));
        PdfiumSetPdfAttachmentDataRequestStreamP.InfoP.Builder info = PdfiumSetPdfAttachmentDataRequestStreamP.InfoP.newBuilder();
        info.setDocument(internalPdfDocument.remoteDocument);
        info.setIndex(attachmentIndex);
        PdfiumSetPdfAttachmentDataRequestStreamP.Builder infoMsg = PdfiumSetPdfAttachmentDataRequestStreamP.newBuilder();
        infoMsg.setInfo(info);
        requestStream.onNext((Object)infoMsg.build());
        Iterator<byte[]> it = Utils_Util.chunk(attachmentBytes);
        while (it.hasNext()) {
            byte[] bytes = it.next();
            PdfiumSetPdfAttachmentDataRequestStreamP.Builder attachmentDataMsg = PdfiumSetPdfAttachmentDataRequestStreamP.newBuilder();
            attachmentDataMsg.setAttachmentChunk(ByteString.copyFrom((byte[])bytes));
            requestStream.onNext((Object)attachmentDataMsg.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        Utils_Util.handleEmptyResultChunks(resultChunks);
    }

    public static void removePdfAttachment(InternalPdfDocument internalPdfDocument, String name) {
        int index = Attachment_Api.getPdfAttachmentCollection(internalPdfDocument).indexOf(name);
        if (index == -1) {
            throw new RuntimeException(String.format("not found Attachment name: %s", name));
        }
        Attachment_Api.removePdfAttachment(internalPdfDocument, index);
    }

    public static void removePdfAttachment(InternalPdfDocument internalPdfDocument, int index) {
        RpcClient client = Access.ensureConnection();
        PdfiumRemovePdfAttachmentRequestP.Builder req = PdfiumRemovePdfAttachmentRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setIndex(index);
        EmptyResultP res = client.GetBlockingStub("removePdfAttachment").pdfiumAttachmentRemovePdfAttachment(req.build());
        Utils_Util.handleEmptyResult(res);
    }
}

