/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumCopyPagesRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetPagesRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetPagesResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfDocumentInsertRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfDocumentMergeRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumRemovePagesRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumRemovePagesResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumResizePageRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumSetPagesRotationRequestP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Page_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.page.PageInfo;
import com.ironsoftware.ironpdf.page.PageRotation;
import java.util.List;
import java.util.stream.Collectors;

public final class Page_Api {
    public static void removePage(InternalPdfDocument internalPdfDocument, List<Integer> pageIndexes) {
        RpcClient client = Access.ensureConnection();
        PdfiumRemovePagesRequestP.Builder req = PdfiumRemovePagesRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.addAllPageIndexes(pageIndexes);
        PdfiumRemovePagesResultP res = client.GetBlockingStub("removePage").pdfiumPageRemovePages(req.build());
        if (res.getResultOrExceptionCase() == PdfiumRemovePagesResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
    }

    public static InternalPdfDocument mergePage(List<InternalPdfDocument> pdfDocuments) {
        RpcClient client = Access.ensureConnection();
        PdfiumPdfDocumentMergeRequestP.Builder req = PdfiumPdfDocumentMergeRequestP.newBuilder();
        req.addAllDocuments(pdfDocuments.stream().map(x -> x.remoteDocument).collect(Collectors.toList()));
        PdfDocumentResultP res = client.GetBlockingStub("mergePage").pdfiumPageMerge(req.build());
        return Utils_Util.handlePdfDocumentResult(res);
    }

    public static void insertPage(InternalPdfDocument internalPdfDocument, InternalPdfDocument anotherPdf) {
        Page_Api.insertPage(internalPdfDocument, anotherPdf, 0);
    }

    public static void insertPage(InternalPdfDocument internalPdfDocument, InternalPdfDocument anotherPdf, int atIndex) {
        RpcClient client = Access.ensureConnection();
        PdfiumPdfDocumentInsertRequestP.Builder req = PdfiumPdfDocumentInsertRequestP.newBuilder();
        req.setMainDocument(internalPdfDocument.remoteDocument);
        req.setInsertionIndex(atIndex);
        req.setInsertedDocument(anotherPdf.remoteDocument);
        EmptyResultP res = client.GetBlockingStub("insertPage").pdfiumPageInsertPdf(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void appendPdf(InternalPdfDocument mainPdfDocument, InternalPdfDocument anotherPdf) {
        RpcClient client = Access.ensureConnection();
        PdfiumPdfDocumentInsertRequestP.Builder req = PdfiumPdfDocumentInsertRequestP.newBuilder();
        req.setMainDocument(mainPdfDocument.remoteDocument);
        req.setInsertionIndex(Page_Api.getPagesInfo(mainPdfDocument).size());
        req.setInsertedDocument(anotherPdf.remoteDocument);
        EmptyResultP res = client.GetBlockingStub("appendPdf").pdfiumPageInsertPdf(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static List<PageInfo> getPagesInfo(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        PdfiumGetPagesRequestP.Builder req = PdfiumGetPagesRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        PdfiumGetPagesResultP res = client.GetBlockingStub("getPagesInfo").pdfiumPageGetPages(req.build());
        if (res.getResultOrExceptionCase() == PdfiumGetPagesResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        return res.getResult().getPagesList().stream().map(Page_Converter::fromProto).collect(Collectors.toList());
    }

    public static void setPageRotation(InternalPdfDocument internalPdfDocument, PageRotation pageRotation) {
        Page_Api.setPageRotation(internalPdfDocument, pageRotation, null);
    }

    public static void setPageRotation(InternalPdfDocument internalPdfDocument, PageRotation pageRotation, List<Integer> pageIndexes) {
        RpcClient client = Access.ensureConnection();
        PdfiumSetPagesRotationRequestP.Builder req = PdfiumSetPagesRotationRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setPageRotation(Page_Converter.toProto(pageRotation));
        if (pageIndexes == null || pageIndexes.isEmpty()) {
            pageIndexes = Page_Api.getPagesInfo(internalPdfDocument).stream().map(PageInfo::getPageIndex).collect(Collectors.toList());
        }
        req.addAllPageIndexes(pageIndexes);
        EmptyResultP res = client.GetBlockingStub("setPageRotation").pdfiumPageSetPagesRotation(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static InternalPdfDocument copyPage(InternalPdfDocument internalPdfDocument, List<Integer> pageIndexes) {
        RpcClient client = Access.ensureConnection();
        PdfiumCopyPagesRequestP.Builder req = PdfiumCopyPagesRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.addAllPageIndexes(pageIndexes);
        PdfDocumentResultP res = client.GetBlockingStub("copyPage").pdfiumPageCopyPages(req.build());
        return Utils_Util.handlePdfDocumentResult(res);
    }

    public static void resizePage(InternalPdfDocument internalPdfDocument, double pageWidth, double pageHeight, Integer pageIndex) {
        RpcClient client = Access.ensureConnection();
        PdfiumResizePageRequestP.Builder req = PdfiumResizePageRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setPageHeight(pageHeight);
        req.setPageWidth(pageWidth);
        req.setPageIndex(pageIndex);
        EmptyResultP res = client.GetBlockingStub("resizePage").pdfiumPageResizePage(req.build());
        Utils_Util.handleEmptyResult(res);
    }
}

