/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.google.protobuf.ByteString;
import com.ironsoftware.ironpdf.PdfDocument;
import com.ironsoftware.ironpdf.edit.ChangeTrackingModes;
import com.ironsoftware.ironpdf.internal.proto.BytesResultStreamP;
import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumConvertToPdfARequestStreamP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumConvertToPdfUARequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetBinaryDataRequestStreamP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetRevisionRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfDocumentConstructorStreamP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfSignatureCollectionP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfSignatureP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumRawSignatureChunkWithIndexP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Signature_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_ReceivingCustomStreamObserver;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_StringHelper;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.signature.Signature;
import com.ironsoftware.ironpdf.standard.PdfAVersions;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PdfDocument_Api {
    static final Logger logger = LoggerFactory.getLogger(PdfDocument.class);

    public static InternalPdfDocument fromFile(String pdfFilePath) throws IOException {
        return PdfDocument_Api.fromFile(pdfFilePath, null, null, ChangeTrackingModes.AUTO_CHANGE_TRACKING);
    }

    public static InternalPdfDocument fromFile(String pdfFilePath, String password) throws IOException {
        return PdfDocument_Api.fromFile(pdfFilePath, password, null, ChangeTrackingModes.AUTO_CHANGE_TRACKING);
    }

    public static InternalPdfDocument fromFile(String pdfFilePath, String password, String ownerPassword, ChangeTrackingModes trackChanges) throws IOException {
        if (Utils_StringHelper.isNullOrWhiteSpace(pdfFilePath)) {
            throw new IllegalArgumentException("Value 'pdfFilePath' cannot be null or empty.");
        }
        String absoluteFilePath = new File(pdfFilePath).getAbsolutePath();
        if (!new File(absoluteFilePath).isFile()) {
            throw new IOException(String.format("%1$s is not a valid PDF file path. That file does not exist.", absoluteFilePath));
        }
        byte[] pdfData = Files.readAllBytes(Paths.get(pdfFilePath, new String[0]));
        if (pdfData.length == 0) {
            throw new IOException(String.format("PdfData Stream is null or empty.  Can not create a PDF document from invalid data. %1$s", pdfFilePath));
        }
        return PdfDocument_Api.fromBytes(pdfData, password, ownerPassword, trackChanges);
    }

    public static InternalPdfDocument fromBytes(byte[] pdfFileBytes, String userPassword, String ownerPassword, ChangeTrackingModes trackChanges) {
        RpcClient client = Access.ensureConnection();
        logger.info("open PDF");
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResultP> resultChunks = new ArrayList<PdfDocumentResultP>();
        StreamObserver<PdfiumPdfDocumentConstructorStreamP> requestStream = client.GetStub("fromBytes").pdfiumFromBytes(new Utils_ReceivingCustomStreamObserver<PdfDocumentResultP>(finishLatch, resultChunks));
        PdfiumPdfDocumentConstructorStreamP.Builder pdfDocumentConstructor_info = PdfiumPdfDocumentConstructorStreamP.newBuilder();
        PdfiumPdfDocumentConstructorStreamP.InfoP.Builder info = PdfiumPdfDocumentConstructorStreamP.InfoP.newBuilder();
        if (!Utils_StringHelper.isNullOrWhiteSpace(userPassword) || !Utils_StringHelper.isNullOrWhiteSpace(ownerPassword)) {
            info.setUserPassword(!Utils_StringHelper.isNullOrWhiteSpace(userPassword) ? userPassword : "");
            info.setOwnerPassword(!Utils_StringHelper.isNullOrWhiteSpace(ownerPassword) ? ownerPassword : "");
        }
        info.setTrackChanges(trackChanges.ordinal());
        pdfDocumentConstructor_info.setInfo(info);
        requestStream.onNext((Object)pdfDocumentConstructor_info.build());
        Iterator<byte[]> it = Utils_Util.chunk(pdfFileBytes);
        while (it.hasNext()) {
            byte[] bytes = it.next();
            PdfiumPdfDocumentConstructorStreamP.Builder pdfDocumentConstructor_data = PdfiumPdfDocumentConstructorStreamP.newBuilder();
            pdfDocumentConstructor_data.setPdfBytesChunk(ByteString.copyFrom((byte[])bytes));
            requestStream.onNext((Object)pdfDocumentConstructor_data.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        InternalPdfDocument doc = Utils_Util.handlePdfDocumentChunks(resultChunks);
        doc.userPassword = userPassword;
        doc.ownerPassword = ownerPassword;
        return doc;
    }

    public static void saveAs(InternalPdfDocument internalPdfDocument, String filePath) throws IOException {
        byte[] data = PdfDocument_Api.getBytes(internalPdfDocument, false);
        PdfDocument_Api.saveAs(data, filePath);
    }

    public static void saveAsRevision(InternalPdfDocument internalPdfDocument, String filePath) throws IOException {
        byte[] data = PdfDocument_Api.getBytes(internalPdfDocument, true);
        PdfDocument_Api.saveAs(data, filePath);
    }

    public static byte[] getBytes(InternalPdfDocument internalPdfDocument, boolean isIncremental) {
        RpcClient client = Access.ensureConnection();
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<BytesResultStreamP> resultChunks = new ArrayList<BytesResultStreamP>();
        PdfiumGetBinaryDataRequestStreamP.InfoP.Builder infoP = PdfiumGetBinaryDataRequestStreamP.InfoP.newBuilder();
        infoP.setDocument(internalPdfDocument.remoteDocument);
        infoP.setIsIncremental(isIncremental);
        StreamObserver<PdfiumGetBinaryDataRequestStreamP> requestStream = client.GetStub("getBytes").pdfiumGetBinaryData(new Utils_ReceivingCustomStreamObserver<BytesResultStreamP>(finishLatch, resultChunks));
        requestStream.onNext((Object)PdfiumGetBinaryDataRequestStreamP.newBuilder().setInfo(infoP).build());
        PdfiumPdfSignatureCollectionP.Builder collectionP = PdfiumPdfSignatureCollectionP.newBuilder();
        for (int sigObjIndex : IntStream.range(0, internalPdfDocument.signatures.size()).toArray()) {
            Signature sigObj = internalPdfDocument.signatures.get(sigObjIndex);
            Iterator<byte[]> it = Utils_Util.chunk(sigObj.getCertificateRawData());
            while (it.hasNext()) {
                byte[] chunk = it.next();
                PdfiumGetBinaryDataRequestStreamP.Builder msg = PdfiumGetBinaryDataRequestStreamP.newBuilder();
                msg.setRawSignaturesChunk(PdfiumRawSignatureChunkWithIndexP.newBuilder().setRawSignatureChunk(ByteString.copyFrom((byte[])chunk)).setSignatureIndex(sigObjIndex).build());
                requestStream.onNext((Object)msg.build());
            }
            PdfiumPdfSignatureP signatureP = Signature_Converter.toProto(sigObj);
            collectionP.addSignature(signatureP);
        }
        requestStream.onNext((Object)PdfiumGetBinaryDataRequestStreamP.newBuilder().setSignatures(collectionP).build());
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handleByteChunks(resultChunks);
    }

    public static byte[] getRevision(InternalPdfDocument internalPdfDocument, int index) {
        RpcClient client = Access.ensureConnection();
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<BytesResultStreamP> resultChunks = new ArrayList<BytesResultStreamP>();
        PdfiumGetRevisionRequestP.Builder req = PdfiumGetRevisionRequestP.newBuilder();
        req.setIndex(index);
        req.setDocument(internalPdfDocument.remoteDocument);
        client.GetStub("getRevision").pdfiumGetRevision(req.build(), new Utils_ReceivingCustomStreamObserver<BytesResultStreamP>(finishLatch, resultChunks));
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handleByteChunks(resultChunks);
    }

    public static void saveAs(byte[] pdfData, String filePath) throws IOException {
        File parent;
        logger.info("save PDF to file: " + filePath);
        File file = new File(filePath);
        if (!file.exists() && (parent = file.getParentFile()) != null) {
            Files.createDirectories(parent.toPath(), new FileAttribute[0]);
        }
        try (FileOutputStream stream = new FileOutputStream(filePath);){
            stream.write(pdfData);
        }
    }

    public static InternalPdfDocument fromBytes(byte[] pdfFileBytes, String userPassword) {
        return PdfDocument_Api.fromBytes(pdfFileBytes, userPassword, null, ChangeTrackingModes.AUTO_CHANGE_TRACKING);
    }

    public static InternalPdfDocument fromBytes(byte[] pdfFileBytes) {
        return PdfDocument_Api.fromBytes(pdfFileBytes, null, null, ChangeTrackingModes.AUTO_CHANGE_TRACKING);
    }

    public static InternalPdfDocument toPdfA(InternalPdfDocument internalPdfDocument, byte[] customICCFileBytes, PdfAVersions pdfAVersion) {
        RpcClient client = Access.ensureConnection();
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResultP> resultChunks = new ArrayList<PdfDocumentResultP>();
        int convtVer = 3;
        boolean isAVariant = true;
        switch (pdfAVersion) {
            case PdfA1b: {
                convtVer = 1;
                isAVariant = false;
                break;
            }
            case PdfA2b: {
                convtVer = 2;
                isAVariant = false;
                break;
            }
            case PdfA3b: {
                convtVer = 3;
                isAVariant = false;
                break;
            }
            case PdfA1a: {
                convtVer = 1;
                isAVariant = true;
                break;
            }
            case PdfA2a: {
                convtVer = 2;
                isAVariant = true;
                break;
            }
            case PdfA3a: {
                convtVer = 3;
                isAVariant = true;
            }
        }
        PdfiumConvertToPdfARequestStreamP.InfoP.Builder infoP = PdfiumConvertToPdfARequestStreamP.InfoP.newBuilder();
        infoP.setDocument(internalPdfDocument.remoteDocument);
        infoP.setConvtVer(convtVer);
        infoP.setIsAVariant(isAVariant);
        PdfiumConvertToPdfARequestStreamP.Builder req = PdfiumConvertToPdfARequestStreamP.newBuilder();
        req.setInfo(infoP);
        StreamObserver<PdfiumConvertToPdfARequestStreamP> requestStream = client.GetStub("toPdfA").pdfiumConvertToPdfA(new Utils_ReceivingCustomStreamObserver<PdfDocumentResultP>(finishLatch, resultChunks));
        requestStream.onNext((Object)req.build());
        Iterator<byte[]> it = Utils_Util.chunk(customICCFileBytes);
        while (it.hasNext()) {
            byte[] bytes = it.next();
            PdfiumConvertToPdfARequestStreamP.Builder pdfDocumentConstructor_data = PdfiumConvertToPdfARequestStreamP.newBuilder();
            pdfDocumentConstructor_data.setIccBytesChunk(ByteString.copyFrom((byte[])bytes));
            requestStream.onNext((Object)pdfDocumentConstructor_data.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        InternalPdfDocument doc = Utils_Util.handlePdfDocumentChunks(resultChunks);
        doc.userPassword = internalPdfDocument.userPassword;
        doc.ownerPassword = internalPdfDocument.ownerPassword;
        return doc;
    }

    public static InternalPdfDocument toPdfUA(InternalPdfDocument internalPdfDocument, int naturalLanguages) {
        RpcClient client = Access.ensureConnection();
        PdfiumConvertToPdfUARequestP.Builder req = PdfiumConvertToPdfUARequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setLang(naturalLanguages);
        EmptyResultP res = client.GetBlockingStub("toPdfUA").pdfiumConvertToPdfUA(req.build());
        Utils_Util.handleEmptyResult(res);
        return internalPdfDocument;
    }
}

