/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.internal.proto.BooleanResultP;
import com.ironsoftware.ironpdf.internal.proto.BytesResultStreamP;
import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.ImageResultStreamP;
import com.ironsoftware.ironpdf.internal.proto.ImagesResultStreamP;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentResultP;
import com.ironsoftware.ironpdf.internal.proto.RawImageChunkWithIndexP;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Setting_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_StringHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;

final class Utils_Util {
    static final int CHUNK_SIZE = 65536;

    Utils_Util() {
    }

    static String enumComparable(String input) {
        return input.toUpperCase().trim().replace("_", "").replace("-", "");
    }

    static String nullGuard(String input) {
        if (Utils_StringHelper.isNullOrEmpty(input)) {
            return "";
        }
        return input;
    }

    static String nullIfEmpty(String input) {
        return Utils_StringHelper.isNullOrEmpty(input) ? null : input;
    }

    static <T> List<T[]> chunk(T[] data) {
        return Utils_Util.chunk(data, 65536);
    }

    static <T> List<T[]> chunk(T[] data, int chunkSize) {
        return IntStream.iterate(0, i -> i + chunkSize).limit((data.length + chunkSize - 1) / chunkSize).mapToObj(i -> Arrays.copyOfRange(data, i, Math.min(i + chunkSize, data.length))).collect(Collectors.toList());
    }

    static Iterator<byte[]> chunk(byte[] data) {
        return Utils_Util.chunk(data, 65536);
    }

    static Iterator<byte[]> chunk(byte[] data, int chunkSize) {
        return IntStream.iterate(0, i -> i + chunkSize).limit((data.length + chunkSize - 1) / chunkSize).mapToObj(i -> Arrays.copyOfRange(data, i, Math.min(i + chunkSize, data.length))).iterator();
    }

    static Iterator<char[]> chunk(char[] data) {
        return Utils_Util.chunk(data, 65536);
    }

    static Iterator<char[]> chunk(char[] data, int chunkSize) {
        return IntStream.iterate(0, i -> i + chunkSize).limit((data.length + chunkSize - 1) / chunkSize).mapToObj(i -> Arrays.copyOfRange(data, i, Math.min(i + chunkSize, data.length))).iterator();
    }

    static void handleEmptyResult(EmptyResultP emptyResult) {
        if (emptyResult.getResultOrExceptionCase() == EmptyResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(emptyResult.getException());
        }
    }

    static void handleEmptyResultChunks(List<EmptyResultP> emptyResultChunks) {
        if (emptyResultChunks.size() == 0) {
            throw new RuntimeException("No response from IronPdf.");
        }
        EmptyResultP res = (EmptyResultP)emptyResultChunks.stream().findFirst().get();
        Utils_Util.handleEmptyResult(res);
    }

    static boolean handleBooleanResult(BooleanResultP booleanResult) {
        if (booleanResult.getResultOrExceptionCase() == BooleanResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(booleanResult.getException());
        }
        return booleanResult.getResult();
    }

    static List<byte[]> handleImagesResult(List<ImagesResultStreamP> resultChunks) throws IOException {
        if (resultChunks.size() == 0) {
            throw new IOException("No response from IronPdf.");
        }
        resultChunks.stream().filter(ImagesResultStreamP::hasException).findFirst().ifPresent(x -> {
            throw Exception_Converter.fromProto(x.getException());
        });
        Map grouped = resultChunks.stream().map(ImagesResultStreamP::getRawImagesChunk).collect(Collectors.groupingBy(RawImageChunkWithIndexP::getImageIndex, Collectors.mapping(c -> c.getRawImageChunk().toByteArray(), Collectors.toList())));
        return grouped.values().stream().map(Utils_Util::combineChunk).collect(Collectors.toList());
    }

    static byte[] handleImageResult(List<ImageResultStreamP> resultChunks) throws IOException {
        if (resultChunks.size() == 0) {
            throw new IOException("No response from IronPdf.");
        }
        resultChunks.stream().filter(ImageResultStreamP::hasException).findFirst().ifPresent(x -> {
            throw Exception_Converter.fromProto(x.getException());
        });
        List<byte[]> chunks = resultChunks.stream().map(c -> c.getRawImageChunk().toByteArray()).collect(Collectors.toList());
        return Utils_Util.combineChunk(chunks);
    }

    static byte[] combineChunk(List<byte[]> chunks) {
        int totalLength = 0;
        for (byte[] chunk : chunks) {
            totalLength += chunk.length;
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, result, offset, chunk.length);
            offset += chunk.length;
        }
        return result;
    }

    static InternalPdfDocument handlePdfDocumentResult(PdfDocumentResultP res) {
        if (res.getResultOrExceptionCase() == PdfDocumentResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        return new InternalPdfDocument(res.getResult());
    }

    static InternalPdfDocument handlePdfDocumentChunks(List<PdfDocumentResultP> resChunks) {
        if (resChunks.size() == 0) {
            throw new RuntimeException("No response from IronPdf.");
        }
        PdfDocumentResultP res = (PdfDocumentResultP)resChunks.stream().findFirst().get();
        return Utils_Util.handlePdfDocumentResult(res);
    }

    static byte[] handleByteChunks(List<BytesResultStreamP> resultChunks) {
        List<byte[]> bytesChunks = resultChunks.stream().map(res -> {
            if (res.getResultOrExceptionCase() == BytesResultStreamP.ResultOrExceptionCase.EXCEPTION) {
                throw Exception_Converter.fromProto(res.getException());
            }
            return res.getResultChunk().toByteArray();
        }).collect(Collectors.toList());
        return Utils_Util.combineChunk(bytesChunks);
    }

    static <T> void waitAndCheck(CountDownLatch finishLatch, List<T> resultChunks) {
        try {
            finishLatch.await(Setting_Api.ironPdfEngineTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (resultChunks.size() == 0) {
            throw new RuntimeException("No response from IronPdfEngine.");
        }
    }

    static void logInfoOrSystemOut(Logger logger, String msg) {
        if (logger.isInfoEnabled()) {
            logger.info(msg);
        } else {
            System.out.println(msg);
        }
    }
}

