/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.metadata;

import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Metadata_Api;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public class MetadataManager {
    private final InternalPdfDocument static_pdfDocument;

    public MetadataManager(InternalPdfDocument internalPdfDocument) {
        this.static_pdfDocument = internalPdfDocument;
    }

    public String getAuthor() {
        return this.getAnyMetadata("Author");
    }

    public String getAnyMetadata(String key) {
        return Metadata_Api.getMetadata(this.static_pdfDocument, key);
    }

    public void setAuthor(String value) {
        this.setAnyMetadata("Author", value);
    }

    public void setAnyMetadata(String key, String value) {
        Metadata_Api.setMetadata(this.static_pdfDocument, key, value);
    }

    public OffsetDateTime getCreationDate() {
        return this.ConvertPdfDateFormatStringToOffsetDateTime(this.getAnyMetadata("CreationDate"));
    }

    @Deprecated
    public void setCreationDate(String value) {
        this.setAnyMetadata("CreationDate", value);
    }

    public void setCreationDate(OffsetDateTime value) {
        this.setAnyMetadata("CreationDate", this.ConvertOffsetDateTimeToPdfDateFormat(value, "yyyyMMddHHmmss"));
    }

    public OffsetDateTime getModifiedDate() {
        return this.ConvertPdfDateFormatStringToOffsetDateTime(this.getAnyMetadata("ModDate"));
    }

    @Deprecated
    public void setModifiedDate(String value) {
        this.setAnyMetadata("ModDate", value);
    }

    public void setModifiedDate(OffsetDateTime value) {
        this.setAnyMetadata("ModDate", this.ConvertOffsetDateTimeToPdfDateFormat(value, "yyyyMMddHHmmss"));
    }

    public String getCreator() {
        return this.getAnyMetadata("Creator");
    }

    public void setCreator(String value) {
        this.setAnyMetadata("Creator", value);
    }

    public String getKeywords() {
        return this.getAnyMetadata("Keywords");
    }

    public void setKeywords(String value) {
        this.setAnyMetadata("Keywords", value);
    }

    public String getProducer() {
        return this.getAnyMetadata("Producer");
    }

    public void setProducer(String value) {
        this.setAnyMetadata("Producer", value);
    }

    public String getSubject() {
        return this.getAnyMetadata("Subject");
    }

    public void setSubject(String value) {
        this.setAnyMetadata("Subject", value);
    }

    public String getTitle() {
        return this.getAnyMetadata("Title");
    }

    public void setTitle(String value) {
        this.setAnyMetadata("Title", value);
    }

    private String ConvertOffsetDateTimeToPdfDateFormat(OffsetDateTime dateTime, String pattern) {
        String offsetPart;
        if (dateTime == null) {
            return "";
        }
        DateTimeFormatter baseFormatter = DateTimeFormatter.ofPattern(pattern);
        String dateTimePart = dateTime.format(baseFormatter);
        ZoneOffset offset = dateTime.getOffset();
        if (offset.getTotalSeconds() == 0) {
            offsetPart = "Z";
        } else {
            int totalSeconds = offset.getTotalSeconds();
            long hours = totalSeconds / 3600;
            long minutes = Math.abs(totalSeconds) / 60 % 60;
            offsetPart = String.format("%+03d'%02d'", hours, minutes);
        }
        return "D:" + dateTimePart + offsetPart;
    }

    private OffsetDateTime ConvertPdfDateFormatStringToOffsetDateTime(String dateTime) {
        if (dateTime == null || dateTime.isEmpty()) {
            return null;
        }
        String parsableDateTime = dateTime;
        if (parsableDateTime.startsWith("D:")) {
            parsableDateTime = parsableDateTime.substring(2);
        }
        parsableDateTime = parsableDateTime.replace("'", "");
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").optionalStart().appendPattern("X").optionalEnd().parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter();
        return OffsetDateTime.parse(parsableDateTime, formatter);
    }

    public void removeMetadata(String key) {
        Metadata_Api.removeMetadata(this.static_pdfDocument, key);
    }
}

