/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.mojo;

import java.util.List;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBaseMojo.class);
    @Parameter(readonly=true, defaultValue="${repositorySystemSession}")
    protected RepositorySystemSession repositorySystemSession;
    @Component
    protected ModelBuilder modelBuilder;
    @Component
    protected MavenProject project;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    protected RemoteRepositoryManager remoteRepositoryManager;
    @Component
    protected Settings settings;
    @Component
    private SettingsDecrypter settingsDecrypter;

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    public UsernamePasswordCredentials getCredentials(String serverId) {
        Server server = this.getDecryptedServer(serverId);
        String username = null;
        String password = null;
        if (server != null) {
            username = server.getUsername();
            password = server.getPassword();
            return new UsernamePasswordCredentials(username, password);
        }
        return null;
    }

    protected Authentication getAuthentication(String serverId) {
        Authentication authentication = null;
        Server server = this.getDecryptedServer(serverId);
        if (server != null) {
            authentication = new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).addPrivateKey(server.getPrivateKey(), server.getPassphrase()).build();
        }
        return authentication;
    }

    private Server getDecryptedServer(String id) {
        DefaultSettingsDecryptionRequest settingsDecryptionRequest = new DefaultSettingsDecryptionRequest();
        settingsDecryptionRequest.setServers(this.settings.getServers());
        SettingsDecryptionResult decrypt = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)settingsDecryptionRequest);
        List servers = decrypt.getServers();
        for (Server server : servers) {
            if (!server.getId().equals(id)) continue;
            return server;
        }
        return null;
    }
}

