/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.mojo;

import com.isomorphic.maven.mojo.AbstractBaseMojo;
import com.isomorphic.maven.packaging.Distribution;
import com.isomorphic.maven.packaging.Downloads;
import com.isomorphic.maven.packaging.License;
import com.isomorphic.maven.packaging.Module;
import com.isomorphic.maven.packaging.Product;
import com.isomorphic.maven.util.HttpRequestManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectModelResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPackagerMojo
extends AbstractBaseMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPackagerMojo.class);
    private static final HttpHost HOST = new HttpHost("www.smartclient.com", -1, "https");
    private HttpRequestManager httpWorker;
    @Parameter(property="includeAnalytics", defaultValue="false")
    protected Boolean includeAnalytics;
    @Parameter(property="buildDate")
    protected String buildDate;
    @Parameter(property="buildNumber", required=true)
    protected String buildNumber;
    @Parameter(property="license", required=true)
    protected License license;
    @Parameter(property="includeMessaging", defaultValue="false")
    protected Boolean includeMessaging;
    @Parameter(property="overwrite", defaultValue="false")
    protected Boolean overwrite;
    @Parameter(property="copyToLatestFolder", defaultValue="false")
    protected Boolean copyToLatestFolder;
    @Parameter(property="skipDownload", defaultValue="false")
    protected Boolean skipDownload;
    @Parameter(property="skipExtraction", defaultValue="false")
    protected Boolean skipExtraction;
    @Parameter(property="product", defaultValue="SMARTGWT")
    protected Product product;
    @Parameter(property="snapshots", defaultValue="true")
    protected Boolean snapshots;
    @Parameter(property="workdir", defaultValue="${java.io.tmpdir}/${project.artifactId}")
    protected File workdir;
    @Parameter(property="serverId", defaultValue="smartclient-developer")
    protected String serverId;

    public abstract void doExecute(Set<Module> var1) throws MojoExecutionException, MojoFailureException;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        String buildNumberFormat;
        UsernamePasswordCredentials credentials = this.getCredentials(this.serverId);
        if (credentials == null) {
            LOGGER.warn("No server configured with id '{}'.  Will be unable to authenticate.", (Object)this.serverId);
        }
        if (!this.buildNumber.matches(buildNumberFormat = "\\d.*\\.\\d.*[d|p]")) {
            throw new MojoExecutionException(String.format("buildNumber '%s' must take the form [major].[minor].[d|p].  e.g., 4.1d", this.buildNumber, buildNumberFormat));
        }
        this.httpWorker = new HttpRequestManager(HOST, credentials, this.settings.getActiveProxy());
        Downloads dl = new Downloads(this.httpWorker);
        try {
            this.httpWorker.login();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            dateFormat.setLenient(false);
            if (this.buildDate == null) {
                Distribution d = Distribution.get(this.product, this.license);
                LOGGER.info("No buildDate provided.  Contacting Isomorphic build server to look for the most recent distribution...");
                String link = dl.findCurrentBuild(d, this.buildNumber);
                if (link == null) {
                    throw new MojoExecutionException("No build found for the given distribution.");
                }
                LOGGER.debug("Extracting date from server response: '{}'", (Object)link);
                this.buildDate = StringUtils.substringAfterLast((String)link, (String)"/");
                LOGGER.info("buildDate set to '{}'", (Object)this.buildDate);
            }
            dateFormat.parse(this.buildDate);
            File basedir = FileUtils.getFile((File)this.workdir, (String[])new String[]{this.product.toString(), this.license.toString(), this.buildNumber, this.buildDate});
            ArrayList<License> licenses = new ArrayList<License>();
            licenses.add(this.license);
            if (this.license == License.POWER || this.license == License.ENTERPRISE) {
                if (this.includeAnalytics.booleanValue()) {
                    licenses.add(License.ANALYTICS_MODULE);
                }
                if (this.includeMessaging.booleanValue()) {
                    licenses.add(License.MESSAGING_MODULE);
                }
            }
            Set<Module> artifacts = this.collect(licenses, basedir);
            String[] executables = new String[]{"bat", "sh", "command"};
            Collection scripts = FileUtils.listFiles((File)basedir, (String[])executables, (boolean)true);
            if (this.copyToLatestFolder.booleanValue()) {
                File bookmarkable = new File(basedir.getParent(), "latest");
                LOGGER.info("Copying distribution to '{}'", (Object)bookmarkable.getAbsolutePath());
                try {
                    FileUtils.forceMkdir((File)bookmarkable);
                    FileUtils.cleanDirectory((File)bookmarkable);
                    FileUtils.copyDirectory((File)basedir, (File)bookmarkable, (FileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"zip")));
                    scripts.addAll(FileUtils.listFiles((File)bookmarkable, (String[])executables, (boolean)true));
                }
                catch (IOException e) {
                    throw new MojoFailureException("Unable to copy distribution contents", (Throwable)e);
                }
            }
            for (File script : scripts) {
                script.setExecutable(true);
                LOGGER.debug("Enabled execute permissions on file '{}'", (Object)script.getAbsolutePath());
            }
            this.doExecute(artifacts);
        }
        catch (ParseException e) {
            throw new MojoExecutionException(String.format("buildDate '%s' must take the form yyyy-MM-dd.", this.buildDate));
        }
        finally {
            this.httpWorker.logout();
        }
    }

    private Set<Module> collect(List<License> downloads, File basedir) throws MojoExecutionException {
        File downloadTo = new File(basedir, "zip");
        downloadTo.mkdirs();
        Downloads downloadManager = new Downloads(this.httpWorker);
        downloadManager.setToFolder(downloadTo);
        downloadManager.setOverwriteExistingFiles(this.overwrite);
        File[] existing = downloadTo.listFiles();
        ArrayList<Object> distributions = new ArrayList<Object>();
        try {
            Collection files;
            if (!this.skipDownload.booleanValue()) {
                distributions.addAll(downloadManager.fetch(this.product, this.buildNumber, this.buildDate, downloads.toArray(new License[0])));
            } else if (existing != null) {
                LOGGER.info("Creating local distribution from '{}'", (Object)downloadTo.getAbsolutePath());
                Distribution distribution = Distribution.get(this.product, this.license);
                distribution.getFiles().addAll(Arrays.asList(existing));
                distributions.add(distribution);
            }
            if (!this.skipExtraction.booleanValue()) {
                LOGGER.info("Unpacking downloaded file/s to '{}'", (Object)basedir);
                for (Distribution distribution : distributions) {
                    distribution.unpack(basedir);
                }
            }
            if ((files = FileUtils.listFiles((File)basedir, (IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"jar"), FileFilterUtils.suffixFileFilter((String)"xml"), FileFilterUtils.suffixFileFilter((String)"zip")}), (IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.nameFileFilter((String)"lib"), FileFilterUtils.nameFileFilter((String)"pom"), FileFilterUtils.nameFileFilter((String)"assembly")}))).isEmpty()) {
                throw new MojoExecutionException(String.format("There don't appear to be any files to work with at '%s'.  Check earlier log entries for clues.", basedir.getAbsolutePath()));
            }
            TreeSet<Module> treeSet = new TreeSet<Module>();
            for (File file : files) {
                try {
                    String base = FilenameUtils.getBaseName((String)file.getName().replaceAll("_", "-"));
                    if ("xml".equals(FilenameUtils.getExtension((String)file.getName()))) {
                        treeSet.add(new Module(this.getModelFromFile(file)));
                        continue;
                    }
                    WildcardFileFilter filter = new WildcardFileFilter(base + ".pom");
                    Collection poms = FileUtils.listFiles((File)basedir, (IOFileFilter)filter, (IOFileFilter)TrueFileFilter.INSTANCE);
                    if (poms.size() != 1) {
                        LOGGER.warn("Expected to find exactly 1 POM matching artifact with name '{}', but found {}.  Skpping installation.", (Object)base, (Object)poms.size());
                        continue;
                    }
                    Model model = this.getModelFromFile((File)poms.iterator().next());
                    Module module = new Module(model, file);
                    int index = base.indexOf("-");
                    String prefix = base.substring(0, index);
                    Collection doc = FileUtils.listFiles((File)new File(basedir, "doc"), (IOFileFilter)FileFilterUtils.prefixFileFilter((String)prefix), (IOFileFilter)FileFilterUtils.nameFileFilter((String)"lib"));
                    if (doc.size() != 1) {
                        LOGGER.debug("Found {} javadoc attachments with prefix '{}'.  Skipping attachment.", (Object)doc.size(), (Object)prefix);
                    } else {
                        module.attach((File)doc.iterator().next(), "javadoc");
                    }
                    treeSet.add(module);
                }
                catch (ModelBuildingException e) {
                    throw new MojoExecutionException("Error building model from POM", (Exception)((Object)e));
                }
            }
            return treeSet;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure during assembly collection", (Exception)e);
        }
    }

    private Model getModelFromFile(File pom) throws ModelBuildingException, IOException {
        if (this.buildNumber.endsWith("d") && !this.snapshots.booleanValue()) {
            LOGGER.info("Rewriting file to remove SNAPSHOT qualifier from development POM '{}'", (Object)pom.getName());
            String content = FileUtils.readFileToString((File)pom);
            content = content.replaceAll("-SNAPSHOT", "");
            FileUtils.write((File)pom, (CharSequence)content);
        }
        ProjectModelResolver resolver = new ProjectModelResolver(this.repositorySystemSession, null, this.repositorySystem, this.remoteRepositoryManager, this.project.getRemoteProjectRepositories(), ProjectBuildingRequest.RepositoryMerging.POM_DOMINANT, null);
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        request.setModelResolver((ModelResolver)resolver);
        request.setPomFile(pom);
        Model model = (Model)this.modelBuilder.buildRawModel(pom, 0, false).get();
        Parent parent = model.getParent();
        if (parent != null) {
            model.setGroupId(parent.getGroupId());
            model.setVersion(parent.getVersion());
        }
        return model;
    }
}

