/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.packaging;

import com.isomorphic.maven.packaging.Distribution;
import com.isomorphic.maven.packaging.License;
import com.isomorphic.maven.packaging.Product;
import com.isomorphic.maven.util.HttpRequestManager;
import com.isomorphic.maven.util.LoggingCountingOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloads {
    private static final Logger LOGGER = LoggerFactory.getLogger(Downloads.class);
    private static HttpRequestManager httpWorker;
    private File toFolder = new File(System.getProperty("java.io.tmpdir"));
    private Boolean overwriteExistingFiles = Boolean.FALSE;

    public Downloads(HttpRequestManager worker) {
        httpWorker = worker;
    }

    public void setToFolder(File toFolder) {
        this.toFolder = toFolder;
    }

    public void setOverwriteExistingFiles(Boolean overwriteExistingFiles) {
        this.overwriteExistingFiles = overwriteExistingFiles;
    }

    public List<Distribution> fetch(Product product, String buildNumber, String buildDate, License ... licenses) throws MojoExecutionException {
        ArrayList<Distribution> result = new ArrayList<Distribution>();
        for (License license : licenses) {
            Distribution distribution = Distribution.get(product, license);
            this.download(distribution, buildNumber, buildDate);
            result.add(distribution);
        }
        return result;
    }

    public String findCurrentBuild(Distribution distribution, String buildNumber) throws MojoExecutionException {
        String selector;
        String url = distribution.getRemoteIndex(buildNumber, null);
        String[] links = this.list(url, selector = "a[href~=[0-9]{4}-[0-9]{2}-[0-9]{2}]");
        if (links.length > 0) {
            return links[0];
        }
        return null;
    }

    private void download(Distribution distribution, String buildNumber, String buildDate) throws MojoExecutionException {
        String[] links;
        String url = distribution.getRemoteIndex(buildNumber, buildDate);
        String selector = distribution.getRemoteIndexFilter();
        for (String link : links = this.list(url, selector)) {
            HttpResponse response;
            String filename = FilenameUtils.getName((String)link);
            File file = new File(this.toFolder, filename);
            if (file.exists() && !this.overwriteExistingFiles.booleanValue()) {
                LOGGER.info("Existing archive found at '{}'.  Skipping download.", (Object)file.getAbsolutePath());
                distribution.getFiles().add(file);
                continue;
            }
            HttpGet httpget = new HttpGet(link);
            try {
                response = httpWorker.execute((HttpRequestBase)httpget);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error issuing GET request for bundle at '" + httpget + "'", e);
            }
            HttpEntity entity = response.getEntity();
            if (!this.toFolder.mkdirs() && !this.toFolder.exists()) {
                throw new MojoExecutionException("Could not create specified working directory '" + this.toFolder.getAbsolutePath() + "'");
            }
            FileUtils.deleteQuietly((File)file);
            LoggingCountingOutputStream outputStream = null;
            try {
                LOGGER.info("Downloading file to '{}'", (Object)file.getAbsolutePath());
                outputStream = new LoggingCountingOutputStream(new FileOutputStream(file), entity.getContentLength());
                entity.writeTo((OutputStream)((Object)outputStream));
                distribution.getFiles().add(file);
            }
            catch (Exception e) {
                try {
                    throw new MojoExecutionException("Error writing file to '" + file.getAbsolutePath() + "'", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)((Object)outputStream));
        }
    }

    private String[] list(String url, String selector) throws MojoExecutionException {
        Document doc;
        HttpResponse response;
        HttpGet request = new HttpGet(url);
        try {
            LOGGER.debug("Requesting list of files from '{}{}'", (Object)httpWorker.getHostName(), (Object)url);
            response = httpWorker.execute((HttpRequestBase)request);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error issuing GET request for bundle at '" + request + "'", e);
        }
        try {
            String html = EntityUtils.toString((HttpEntity)response.getEntity());
            doc = Jsoup.parse((String)html);
            doc.outputSettings().prettyPrint(true);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing response from '" + request + "'", e);
        }
        ArrayList<String> result = new ArrayList<String>();
        Elements links = doc.select(selector);
        for (Element element : links) {
            String href = element.attr("href");
            result.add(href);
        }
        if (result.isEmpty()) {
            String msg = String.format("No downloads found at '%s%s'.  Response from server: \n\n%s\n", httpWorker.getHostName(), url, doc.html());
            LOGGER.warn(msg);
        }
        return result.toArray(new String[0]);
    }
}

