/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ArchiveUtils {
    public static void jar(File directory, File output) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        output.getParentFile().mkdirs();
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(output), manifest);
        ArchiveUtils.zip(directory, directory, target);
        target.close();
    }

    public static void zip(File directory, File output) throws IOException {
        output.getParentFile().mkdirs();
        ZipOutputStream target = new ZipOutputStream(new FileOutputStream(output));
        ArchiveUtils.zip(directory, directory, target);
        target.close();
    }

    public static void unzip(File source, File target) throws IOException {
        ZipFile zip = new ZipFile(source);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = new File(target, entry.getName());
            FileUtils.copyInputStreamToFile((InputStream)zip.getInputStream(entry), (File)file);
        }
    }

    public static String rewritePath(String oldValue, String newValue) {
        String filename;
        String path = newValue;
        if ("".equals(FilenameUtils.getExtension((String)newValue))) {
            filename = FilenameUtils.getName((String)oldValue);
        } else {
            path = FilenameUtils.getPath((String)newValue);
            filename = FilenameUtils.getName((String)newValue);
        }
        Pattern p = Pattern.compile("(.*?)#(.*?)(?:$|(/.*))");
        Matcher m = p.matcher(path);
        if (m.find()) {
            String prefix = m.group(1);
            String dir = m.group(2);
            String suffix = m.group(3);
            int index = oldValue.indexOf(dir);
            int length = dir.length();
            String remainder = FilenameUtils.getPath((String)oldValue.substring(index + length));
            path = prefix != null && !prefix.equals("") ? prefix + remainder : remainder;
            if (suffix != null && !suffix.equals("")) {
                path = path + suffix;
            }
        }
        return FilenameUtils.normalize((String)(path + "/" + filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(File root, File source, ZipOutputStream target) throws IOException {
        BufferedInputStream in;
        String relativePath;
        block5: {
            relativePath = root.toURI().relativize(source.toURI()).getPath().replace("\\", "/");
            in = null;
            try {
                if (!source.isDirectory()) break block5;
                if (!relativePath.endsWith("/")) {
                    relativePath = relativePath + "/";
                }
                ZipEntry entry = ZipEntryFactory.get(target, relativePath);
                entry.setTime(source.lastModified());
                target.putNextEntry(entry);
                target.closeEntry();
                for (File nestedFile : source.listFiles()) {
                    ArchiveUtils.zip(root, nestedFile, target);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return;
        }
        ZipEntry entry = ZipEntryFactory.get(target, relativePath);
        entry.setTime(source.lastModified());
        target.putNextEntry(entry);
        in = new BufferedInputStream(FileUtils.openInputStream((File)source));
        IOUtils.copy((InputStream)in, (OutputStream)target);
        target.closeEntry();
        IOUtils.closeQuietly((InputStream)in);
    }

    private static class ZipEntryFactory {
        private ZipEntryFactory() {
        }

        static ZipEntry get(ZipOutputStream target, String name) {
            if (target instanceof JarOutputStream) {
                return new JarEntry(name);
            }
            return new ZipEntry(name);
        }
    }
}

