/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestManager.class);
    private UsernamePasswordCredentials credentials;
    private HttpHost host;
    private String loginUrl = "/devlogin/login.jsp";
    private String logoutUrl = "/logout.jsp";
    private DefaultHttpClient httpClient = new DefaultHttpClient();

    public HttpRequestManager(HttpHost host, UsernamePasswordCredentials credentials, Proxy proxyConfiguration) throws MojoExecutionException {
        this.host = host;
        this.credentials = credentials;
        try {
            if (proxyConfiguration != null && this.isProxied(proxyConfiguration)) {
                if (proxyConfiguration.getUsername() != null) {
                    this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyConfiguration.getHost(), proxyConfiguration.getPort()), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.getUsername(), proxyConfiguration.getPassword()));
                }
                HttpHost proxy = new HttpHost(proxyConfiguration.getHost(), proxyConfiguration.getPort());
                this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to setup HTTP proxy", e);
        }
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public String getHostName() {
        return this.host.getHostName();
    }

    public void login() throws MojoExecutionException {
        if (this.credentials == null) {
            return;
        }
        String username = this.credentials.getUserName();
        String password = this.credentials.getPassword();
        LOGGER.debug("Authenticating to '{}' with username: '{}'", (Object)(this.host.getHostName() + this.loginUrl), (Object)username);
        HttpPost login = new HttpPost(this.loginUrl);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("USERNAME", username));
        nvps.add(new BasicNameValuePair("PASSWORD", password));
        try {
            login.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            CloseableHttpResponse response = this.httpClient.execute(this.host, (HttpRequest)login);
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during POST request for authentication", (Exception)e);
        }
    }

    public void logout() {
        HttpPost logout = new HttpPost(this.logoutUrl);
        LOGGER.debug("Logging off at '{}'", (Object)(this.host.getHostName() + this.logoutUrl));
        try {
            CloseableHttpResponse response = this.httpClient.execute(this.host, (HttpRequest)logout);
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            LOGGER.debug("Error at logout ", (Throwable)e);
        }
    }

    private boolean isProxied(Proxy proxyConfig) throws MalformedURLException {
        String nonProxyHostsAsString = proxyConfig.getNonProxyHosts();
        String domain = this.host.getHostName();
        for (String nonProxyHost : StringUtils.split((String)nonProxyHostsAsString, (String)",;|")) {
            if (StringUtils.contains((String)nonProxyHost, (String)"*")) {
                int pos = nonProxyHost.indexOf(42);
                String nonProxyHostPrefix = nonProxyHost.substring(0, pos);
                String nonProxyHostSuffix = nonProxyHost.substring(pos + 1);
                if (StringUtils.isNotEmpty((String)nonProxyHostPrefix) && domain.startsWith(nonProxyHostPrefix) && StringUtils.isEmpty((String)nonProxyHostSuffix)) {
                    return false;
                }
                if (StringUtils.isEmpty((String)nonProxyHostPrefix) && StringUtils.isNotEmpty((String)nonProxyHostSuffix) && domain.endsWith(nonProxyHostSuffix)) {
                    return false;
                }
                if (!StringUtils.isNotEmpty((String)nonProxyHostPrefix) || !domain.startsWith(nonProxyHostPrefix) || !StringUtils.isNotEmpty((String)nonProxyHostSuffix) || !domain.endsWith(nonProxyHostSuffix)) continue;
                return false;
            }
            if (!domain.equals(nonProxyHost)) continue;
            return false;
        }
        return true;
    }

    public HttpResponse execute(HttpRequestBase request) {
        try {
            return this.httpClient.execute(this.host, (HttpRequest)request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

