/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.mojo.reify;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.isomorphic.maven.mojo.AbstractBaseMojo;
import com.isomorphic.maven.util.ArchiveUtils;
import com.isomorphic.maven.util.HttpRequestManager;
import com.isomorphic.maven.util.LoggingCountingOutputStream;
import com.isomorphic.tools.ReifyDataSourceValidator;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

@Mojo(name="reify-import", requiresProject=false)
public class ImportMojo
extends AbstractBaseMojo {
    @Parameter(property="serverUrl", defaultValue="https://create.reify.com")
    protected String serverUrl;
    @Parameter(property="serverId", defaultValue="smartclient-developer")
    protected String serverId;
    @Parameter(property="workdir", defaultValue="${project.build.directory}/reify")
    protected File workdir;
    @Parameter(property="webappDir", defaultValue="${project.basedir}/src/main/webapp")
    protected File webappDir;
    @Parameter(property="smartclientRuntimeDir", defaultValue="${project.build.directory}/${project.build.finalName}/isomorphic")
    protected File smartclientRuntimeDir;
    @Parameter(property="includeJs", defaultValue="false")
    protected boolean includeJs;
    @Parameter(property="includeTestJsp", defaultValue="false")
    protected boolean includeTestJsp;
    @Parameter(property="testJspPathname", defaultValue="${projectName}.run.jsp")
    protected String testJspPathname;
    @Parameter(property="includeTestHtml", defaultValue="false")
    protected boolean includeTestHtml;
    @Parameter(property="testHtmlPathname", defaultValue="${projectName}.run.html")
    protected String testHtmlPathname;
    @Parameter(property="dataSourcesDir", defaultValue="WEB-INF/ds")
    protected String dataSourcesDir;
    @Parameter(property="mockDataSourcesDir", defaultValue="WEB-INF/ds/mock")
    protected String mockDataSourcesDir;
    @Parameter(property="skipValidationOnImport", defaultValue="false")
    protected boolean skipValidationOnImport;
    @Parameter(property="validationFailureThreshold", defaultValue="ERROR")
    protected ErrorMessage.Severity validationFailureThreshold;
    @Parameter(property="uiDir", defaultValue="WEB-INF/ui")
    protected String uiDir;
    @Parameter(property="projectFileDir", defaultValue="WEB-INF/ui")
    protected String projectFileDir;
    @Parameter(property="modifyWelcomeFiles", defaultValue="false")
    protected boolean modifyWelcomeFiles;
    @Parameter(property="drawOnWelcomeFiles", defaultValue="false")
    protected boolean drawOnWelcomeFiles;
    @Parameter(property="projectName", defaultValue="${project.artifactId}", required=true)
    protected String projectName;
    private String projectFileName;
    private String zipFileName;
    @Parameter(property="skipOverwriteProtection", defaultValue="false")
    private boolean skipOverwriteProtection;
    private UsernamePasswordCredentials credentials;
    private final Configuration freemarkerConfig;
    private Proxy proxy;
    private HttpHost host;
    private HttpRequestManager httpWorker;

    public ImportMojo() {
        ClassTemplateLoader ctl = new ClassTemplateLoader(((Object)((Object)this)).getClass(), "");
        this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_28);
        this.freemarkerConfig.setTemplateLoader((TemplateLoader)ctl);
        this.freemarkerConfig.setDefaultEncoding("UTF-8");
        this.freemarkerConfig.setLogTemplateExceptions(false);
        this.freemarkerConfig.setWrapUncheckedExceptions(true);
        this.freemarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (System.getProperty("host") != null) {
                this.serverUrl = System.getProperty("host");
            }
            this.setHost(this.serverUrl);
            this.zipFileName = this.projectName + ".proj.zip";
            this.projectFileName = this.projectName + ".proj.xml";
            if (!this.skipOverwriteProtection) {
                this.checkForLocalModifications();
            }
            if (this.credentials == null) {
                this.credentials = this.getCredentials(this.serverId);
            }
            if (this.credentials == null) {
                throw new MojoExecutionException("Reify credentials have not been configured.  Check Maven settings for the '" + this.serverId + "' server.");
            }
            this.httpWorker = new HttpRequestManager(this.host, this.credentials, this.settings != null ? this.settings.getActiveProxy() : this.proxy);
            this.httpWorker.login();
            Document project = this.downloadProjectDocument();
            File archive = this.downloadProjectArchive(project);
            this.getLog().info((CharSequence)String.format("Importing Reify project assets from download at '%s'...", archive.getCanonicalPath()));
            File unpacked = new File(this.workdir, this.projectName);
            ArchiveUtils.unzip(archive, unpacked);
            this.writeProjectFile(project, unpacked);
            FileUtils.copyDirectory((File)unpacked, (File)this.webappDir);
            if (this.modifyWelcomeFiles || this.drawOnWelcomeFiles) {
                this.modifyWelcomeFiles();
            }
            if (!this.skipValidationOnImport) {
                this.getLog().info((CharSequence)"Validating MockDataSources against any working DataSources...");
                this.validate();
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Import Error", e);
        }
        finally {
            try {
                this.httpWorker.logout();
            }
            catch (Exception exception) {}
        }
    }

    protected void validate() {
        try {
            ReifyDataSourceValidator validator = new ReifyDataSourceValidator(this.smartclientRuntimeDir.getCanonicalPath(), this.webappDir + "/" + this.dataSourcesDir);
            validator.setMockDataSourcesBasePath(this.webappDir + "/" + this.mockDataSourcesDir);
            List result = validator.verify();
            boolean fail = false;
            if (!result.isEmpty()) {
                for (ErrorReport report : result) {
                    for (String key : report.keySet()) {
                        List errors = report.getErrors(key);
                        for (ErrorMessage msg : errors) {
                            String output = key.equals(report.getDataSourceId()) ? String.format("%s: %s", report.getDataSourceId(), msg.getErrorString()) : String.format("%s.%s: %s", report.getDataSourceId(), key, msg.getErrorString());
                            ErrorMessage.Severity severity = msg.getSeverity();
                            if (severity.compareTo((Enum)this.validationFailureThreshold) >= 0) {
                                fail = true;
                            }
                            if (severity == ErrorMessage.Severity.INFO) {
                                this.getLog().info((CharSequence)output);
                            }
                            if (msg.getSeverity() == ErrorMessage.Severity.WARN) {
                                this.getLog().warn((CharSequence)output);
                            }
                            if (msg.getSeverity() != ErrorMessage.Severity.ERROR) continue;
                            this.getLog().error((CharSequence)output);
                        }
                    }
                }
            } else {
                this.getLog().info((CharSequence)"No validation errors were found.");
            }
            if (fail) {
                throw new MojoExecutionException("Mock DataSource validation failure.  Please refer to ReifyDataSourceValidator log output for detailed report.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkForLocalModifications() throws MojoExecutionException, Exception {
        File projectFile = new File(this.webappDir, this.projectFileDir + "/" + this.projectFileName);
        if (!projectFile.exists()) {
            this.getLog().info((CharSequence)String.format("Project file does not exist at '%s', but will be created during import.", projectFile.getCanonicalPath()));
            return;
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read(projectFile);
        String msg = "File '%s' appears to have been modified since the last import.  Aborting to provide an opprtunity to investigate.  \nYou can either revert your changes, delete the file, or remove its checksum from the project file to continue. \nYou can also disable the check for this and all other files using the skipOverwriteProtection parameter.";
        List<Node> screens = this.getScreenNodes(document);
        for (Node screen : screens) {
            String actual;
            File file;
            String expected = screen.valueOf("checksum");
            if (expected.isEmpty() || !(file = this.getScreen(screen, this.webappDir)).exists() || (actual = Files.asByteSource((File)file).hash(Hashing.sha256()).toString()).equals(expected)) continue;
            this.getLog().debug((CharSequence)String.format("Checksum mismatch - Expected: '%s' Actual: '%s'", expected, actual));
            throw new MojoExecutionException(String.format(msg, file.getCanonicalPath()));
        }
        List<Node> datasources = this.getDataSourceNodes(document);
        for (Node ds : datasources) {
            String actual;
            File file;
            String expected = ds.valueOf("checksum");
            if (expected.isEmpty() || !(file = this.getDataSource(ds, this.webappDir)).exists() || (actual = Files.asByteSource((File)file).hash(Hashing.sha256()).toString()).equals(expected)) continue;
            this.getLog().debug((CharSequence)String.format("Checksum mismatch - Expected: '%s' Actual: '%s'", expected, actual));
            throw new MojoExecutionException(String.format(msg, file.getCanonicalPath()));
        }
    }

    private Document downloadProjectDocument() throws Exception {
        this.getLog().info((CharSequence)"Contacting server for Reify project metadata...");
        HttpGet request = new HttpGet("/isomorphic/RESTHandler/isc_hostedProjects?fileName=" + URLEncoder.encode(this.projectName) + "&isc_dataFormat=xml");
        HttpResponse response = this.httpWorker.execute((HttpRequestBase)request);
        String body = null;
        try {
            body = EntityUtils.toString((HttpEntity)response.getEntity());
            Document metadata = DocumentHelper.parseText((String)body);
            Node fileContents = metadata.selectSingleNode("//fileContents");
            String project = fileContents.getText();
            return DocumentHelper.parseText((String)project);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Response from server:" + System.getProperty("line.separator") + body));
            throw new Exception(String.format("Unexpected response to request for project file.  Check that user '%s' is able to access the project named '%s'", this.credentials.getUserName(), this.projectName));
        }
    }

    private boolean isSmartGWTBuild() {
        return FileUtils.getFile((File)this.smartclientRuntimeDir, (String[])new String[]{"modules"}).exists();
    }

    private String getIsomorphicDirPath(String relativeToPath) {
        String[] parentDirectories = relativeToPath.split("/");
        int parentDirectoryCount = parentDirectories.length;
        StringBuilder prefix = new StringBuilder();
        for (int i = 1; i < parentDirectoryCount; ++i) {
            prefix.insert(0, "../");
        }
        String name = this.isSmartGWTBuild() ? this.smartclientRuntimeDir.getParentFile().getName() + "/" + this.smartclientRuntimeDir.getName() : this.smartclientRuntimeDir.getName();
        return prefix + name;
    }

    private File downloadProjectArchive(Document project) throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("projectName", this.projectName);
        context.put("datasourcesDir", this.dataSourcesDir);
        context.put("mockDatasourcesDir", this.mockDataSourcesDir);
        context.put("uiDir", this.uiDir);
        context.put("projectFileDir", this.projectFileDir);
        context.put("projectFileName", this.projectFileName);
        context.put("zipFileName", this.zipFileName);
        context.put("screens", this.getScreenNames(project));
        context.put("datasources", this.getDataSourceNames(project));
        context.put("includeJs", this.includeJs);
        context.put("includeTestJsp", this.includeTestJsp);
        context.put("testJspPathname", this.testJspPathname);
        StringWriter jspWriter = new StringWriter();
        this.freemarkerConfig.getTemplate("TestJspFileContent.ftl").process(context, (Writer)jspWriter);
        context.put("jspFileContent", StringEscapeUtils.escapeHtml4((String)jspWriter.toString()));
        context.put("includeTestHtml", this.includeTestHtml);
        context.put("testHtmlPathname", this.testHtmlPathname);
        StringWriter htmlWriter = new StringWriter();
        context.put("isomorphicDir", this.getIsomorphicDirPath(this.testHtmlPathname));
        context.put("modulesDir", this.isSmartGWTBuild() ? "modules" : "system/modules");
        this.freemarkerConfig.getTemplate("TestHtmlFileContent.ftl").process(context, (Writer)htmlWriter);
        context.put("htmlFileContent", StringEscapeUtils.escapeHtml4((String)htmlWriter.toString()));
        StringWriter messageWriter = new StringWriter();
        this.freemarkerConfig.getTemplate("ProjectExportRequestParameter.ftl").process(context, (Writer)messageWriter);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("_transaction", messageWriter.toString()));
        HttpPost request = new HttpPost("/isomorphic/IDACall?isc_rpc=1");
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        this.getLog().info((CharSequence)String.format("Downloading '%s' project export from '%s'...", this.projectName, this.host.getHostName()));
        HttpResponse response = this.httpWorker.execute((HttpRequestBase)request);
        HttpEntity entity = response.getEntity();
        if (!"application/zip".equals(entity.getContentType().getValue())) {
            throw new MojoExecutionException("Response does not contain zip file contents:\n" + EntityUtils.toString((HttpEntity)entity));
        }
        FileUtils.forceMkdir((File)this.workdir);
        FileUtils.cleanDirectory((File)this.workdir);
        File zip = new File(this.workdir + "/" + this.zipFileName);
        LoggingCountingOutputStream outputStream = null;
        try {
            outputStream = new LoggingCountingOutputStream(new FileOutputStream(zip), entity.getContentLength());
            entity.writeTo((OutputStream)((Object)outputStream));
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Error writing file to '" + zip.getAbsolutePath() + "'", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)((Object)outputStream));
        return zip;
    }

    private void writeProjectFile(Document project, File parent) throws Exception {
        org.dom4j.Element element;
        String checksum;
        File file;
        for (Node screen : this.getScreenNodes(project)) {
            file = this.getScreen(screen, parent);
            checksum = Files.asByteSource((File)file).hash(Hashing.sha256()).toString();
            element = ((org.dom4j.Element)screen).addElement("checksum");
            element.setText(checksum);
        }
        for (Node datasource : this.getDataSourceNodes(project)) {
            file = this.getDataSource(datasource, parent);
            checksum = Files.asByteSource((File)file).hash(Hashing.sha256()).toString();
            element = ((org.dom4j.Element)datasource).addElement("checksum");
            element.setText(checksum);
        }
        File projectFile = FileUtils.getFile((File)parent, (String[])new String[]{this.projectFileDir, this.projectFileName});
        OutputFormat purdy = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(projectFile), purdy);
        writer.write(project);
        writer.flush();
        writer.close();
    }

    private void modifyWelcomeFiles() throws Exception {
        File welcomeFilesConfig = new File(this.webappDir, "WEB-INF/web.xml");
        if (!welcomeFilesConfig.exists()) {
            String msg = String.format("No web.xml found at '%s'", welcomeFilesConfig.getCanonicalPath());
            throw new RuntimeException(msg);
        }
        ArrayList<File> welcomeFiles = new ArrayList<File>();
        SAXReader reader = new SAXReader();
        Document webXml = reader.read(welcomeFilesConfig);
        XPath xpath = webXml.createXPath("//jee:welcome-file");
        xpath.setNamespaceURIs((Map)ImmutableMap.of((Object)"jee", (Object)"http://java.sun.com/xml/ns/javaee"));
        List list = xpath.selectNodes((Object)webXml);
        for (Node node : list) {
            String val = node.getStringValue();
            File file = FileUtils.getFile((File)this.webappDir, (String[])new String[]{val});
            if (!file.exists()) {
                this.getLog().warn((CharSequence)String.format("Welcome file '%s' not found.  Skipping.", val));
                continue;
            }
            welcomeFiles.add(file);
        }
        if (welcomeFiles.isEmpty()) {
            File jsp = FileUtils.getFile((File)this.webappDir, (String[])new String[]{"index.jsp"});
            File html = FileUtils.getFile((File)this.webappDir, (String[])new String[]{"index.html"});
            if (jsp.exists()) {
                welcomeFiles.add(jsp);
            }
            if (html.exists()) {
                welcomeFiles.add(html);
            }
        }
        for (File file : welcomeFiles) {
            String extension = FilenameUtils.getExtension((String)file.getCanonicalPath()).toLowerCase();
            Source source = new Source(file);
            OutputDocument target = new OutputDocument(source);
            Element scriptElement = source.getElementById("isc-maven-plugin.reify-import.modifyWelcomeFiles");
            LinkedHashSet<String> projectNames = new LinkedHashSet<String>();
            if (scriptElement != null) {
                if ("jsp".equals(extension)) {
                    String html = scriptElement.toString().trim();
                    int start = html.toLowerCase().indexOf("name=\"") + 6;
                    int end = html.indexOf("\"", start);
                    String val = html.substring(start, end);
                    projectNames.addAll(Sets.newHashSet((Object[])val.split(",")));
                } else {
                    String src = scriptElement.getAttributeValue("src");
                    int start = src.indexOf("projectName=") + 12;
                    int end = src.indexOf("&", start);
                    String val = src.substring(start, end);
                    projectNames.addAll(Sets.newHashSet((Object[])val.split(",")));
                }
            }
            projectNames.add(this.projectName);
            String template = "LoadProjectScriptFragment.ftl";
            if ("jsp".equals(extension)) {
                template = "LoadProjectTagFragment.ftl";
            }
            ImmutableMap context = ImmutableMap.of((Object)"isomorphicDir", (Object)this.getIsomorphicDirPath(this.testHtmlPathname), (Object)"projects", (Object)projectNames.toArray(), (Object)"draw", (Object)this.drawOnWelcomeFiles);
            StringWriter tagWriter = new StringWriter();
            this.freemarkerConfig.getTemplate(template).process((Object)context, (Writer)tagWriter);
            if (scriptElement != null) {
                target.replace((Segment)scriptElement, (CharSequence)tagWriter.toString());
            } else {
                int index = source.getFirstElement("body").getEndTag().getBegin();
                target.insert(index, (CharSequence)tagWriter.toString());
            }
            FileUtils.write((File)file, (CharSequence)target.toString());
        }
    }

    private List<Node> getScreenNodes(Document project) {
        return project.selectNodes("/Project/screens/root/children/TreeNode");
    }

    private List<String> getScreenNames(Document project) {
        List<Node> nodes = this.getScreenNodes(project);
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : nodes) {
            names.add(this.getScreenName(node));
        }
        return names;
    }

    private String getScreenName(Node screen) {
        return screen.valueOf("fileName");
    }

    private File getScreen(Node metadata, File parent) {
        return FileUtils.getFile((File)parent, (String[])new String[]{this.uiDir, this.getScreenName(metadata) + ".ui.xml"});
    }

    private List<Node> getDataSourceNodes(Document project) {
        return project.selectNodes("/Project/datasources/Record");
    }

    private List<String> getDataSourceNames(Document project) {
        List<Node> nodes = this.getDataSourceNodes(project);
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : nodes) {
            names.add(this.getDataSourceName(node));
        }
        return names;
    }

    private String getDataSourceName(Node ds) {
        return ds.valueOf("dsName");
    }

    private File getDataSource(Node metadata, File parent) {
        String name = this.getDataSourceName(metadata);
        File file = FileUtils.getFile((File)parent, (String[])new String[]{this.mockDataSourcesDir, name + ".ds.xml"});
        if (!file.exists()) {
            file = FileUtils.getFile((File)parent, (String[])new String[]{this.dataSourcesDir, name + ".ds.xml"});
        }
        return file;
    }

    protected void setHost(String uri) {
        this.host = URIUtils.extractHost((URI)URI.create(uri));
    }

    protected void setWorkdir(File workdir) {
        this.workdir = workdir;
    }

    protected void setWebappDir(File webappDir) {
        this.webappDir = webappDir;
    }

    protected void setSmartclientRuntimeDir(File smartclientRuntimeDir) {
        this.smartclientRuntimeDir = smartclientRuntimeDir;
    }

    protected void setIncludeJs(boolean includeJs) {
        this.includeJs = includeJs;
    }

    protected void setIncludeTestJsp(boolean includeTestJsp) {
        this.includeTestJsp = includeTestJsp;
    }

    protected void setTestJspPathname(String testJspPathname) {
        this.testJspPathname = testJspPathname;
    }

    protected void setIncludeTestHtml(boolean includeTestHtml) {
        this.includeTestHtml = includeTestHtml;
    }

    protected void setTestHtmlPathname(String testHtmlPathname) {
        this.testHtmlPathname = testHtmlPathname;
    }

    protected void setDataSourcesDir(String dataSourcesDir) {
        this.dataSourcesDir = dataSourcesDir;
    }

    protected void setMockDataSourcesDir(String mockDataSourcesDir) {
        this.mockDataSourcesDir = mockDataSourcesDir;
    }

    protected void setSkipValidationOnImport(boolean skipValidationOnImport) {
        this.skipValidationOnImport = skipValidationOnImport;
    }

    protected void setValidationFailureThreshold(ErrorMessage.Severity validationFailureThreshold) {
        this.validationFailureThreshold = validationFailureThreshold;
    }

    protected void setUiDir(String uiDir) {
        this.uiDir = uiDir;
    }

    protected void setProjectFileDir(String projectFileDir) {
        this.projectFileDir = projectFileDir;
    }

    protected void setModifyWelcomeFiles(boolean modifyWelcomeFiles) {
        this.modifyWelcomeFiles = modifyWelcomeFiles;
    }

    protected void setDrawOnWelcomeFiles(boolean drawOnWelcomeFiles) {
        this.drawOnWelcomeFiles = drawOnWelcomeFiles;
    }

    protected void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    protected void setProjectFileName(String projectFileName) {
        this.projectFileName = projectFileName;
    }

    protected void setZipFileName(String zipFileName) {
        this.zipFileName = zipFileName;
    }

    protected void setSkipOverwriteProtection(boolean skipOverwriteProtection) {
        this.skipOverwriteProtection = skipOverwriteProtection;
    }

    protected void setCredentials(UsernamePasswordCredentials credentials) {
        this.credentials = credentials;
    }

    protected void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

