/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.mojo.reify;

import com.isomorphic.maven.mojo.reify.ImportMojo;
import com.isomorphic.maven.util.AntProjectLogger;
import com.isomorphic.util.ErrorMessage;
import java.io.File;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.maven.settings.Proxy;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ImportTask
extends Task {
    protected String serverUrl = "https://create.reify.com";
    protected String workdir;
    protected String webappDir = "war";
    protected String smartclientRuntimeDir;
    protected boolean includeTestJsp;
    protected String testJspPathname;
    protected boolean includeTestHtml;
    protected String testHtmlPathname;
    protected String dataSourcesDir = "WEB-INF/ds";
    protected String mockDataSourcesDir = "WEB-INF/ds/mock";
    protected boolean skipValidationOnImport;
    protected ErrorMessage.Severity validationFailureThreshold = ErrorMessage.Severity.ERROR;
    protected String uiDir = "WEB-INF/ui";
    protected String projectFileDir = "WEB-INF/ui";
    protected boolean modifyWelcomeFiles;
    protected boolean drawOnWelcomeFiles;
    protected String projectName;
    protected String projectFileName;
    protected String zipFileName;
    protected String username;
    protected String password;

    public void execute() throws BuildException {
        ImportMojo mojo = new ImportMojo();
        mojo.setLog(new AntProjectLogger(this.getProject()));
        if (this.username == null || this.password == null) {
            throw new BuildException("Username and password parameters required.");
        }
        if (this.projectName == null) {
            this.projectName = this.getProject().getName();
        }
        mojo.setHost(String.valueOf(this.serverUrl));
        mojo.setCredentials(new UsernamePasswordCredentials(this.username, this.password));
        mojo.setWorkdir(this.workdir != null ? new File(this.workdir) : new File(this.getProject().getBaseDir(), "build/reify"));
        mojo.setWebappDir(this.webappDir != null ? new File(this.webappDir) : new File(this.getProject().getBaseDir(), this.webappDir));
        mojo.setSmartclientRuntimeDir(this.smartclientRuntimeDir != null ? new File(this.smartclientRuntimeDir) : new File(this.getProject().getBaseDir(), "war/isomorphic"));
        mojo.setIncludeTestJsp(this.includeTestJsp);
        this.testJspPathname = this.testJspPathname != null ? this.testJspPathname : this.projectName + ".run.jsp";
        mojo.setTestJspPathname(this.testJspPathname);
        mojo.setIncludeTestHtml(this.includeTestHtml);
        this.testHtmlPathname = this.testHtmlPathname != null ? this.testHtmlPathname : this.projectName + ".run.html";
        mojo.setTestHtmlPathname(this.testHtmlPathname);
        mojo.setDataSourcesDir(this.dataSourcesDir);
        mojo.setMockDataSourcesDir(this.mockDataSourcesDir);
        mojo.setSkipValidationOnImport(this.skipValidationOnImport);
        mojo.setValidationFailureThreshold(this.validationFailureThreshold);
        mojo.setUiDir(this.uiDir);
        mojo.setProjectFileDir(this.projectFileDir);
        mojo.setModifyWelcomeFiles(this.modifyWelcomeFiles);
        mojo.setDrawOnWelcomeFiles(this.drawOnWelcomeFiles);
        mojo.setProjectName(this.projectName);
        mojo.setProjectFileName(this.projectFileName != null ? this.projectFileName : this.projectName + "proj.xml");
        mojo.setZipFileName(this.zipFileName != null ? this.zipFileName : this.projectName + "proj.zip");
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        String proxyUser = System.getProperty("http.proxyUser");
        String proxyPassword = System.getProperty("http.proxyPassword");
        String proxyBypass = System.getProperty("http.nonProxyHosts");
        if (proxyHost != null || proxyPort != null) {
            Proxy p = new Proxy();
            p.setHost(proxyHost != null ? proxyHost : "");
            p.setPort(Integer.valueOf(proxyPort != null ? proxyPort : "8080").intValue());
            p.setUsername(proxyUser != null ? proxyUser : "");
            p.setPassword(proxyPassword != null ? proxyPassword : "");
            p.setNonProxyHosts(proxyBypass != null ? proxyBypass : "localhost");
            p.setActive(true);
            mojo.setProxy(p);
        }
        try {
            mojo.execute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setWorkdir(String workdir) {
        this.workdir = workdir;
    }

    public void setWebappDir(String webappDir) {
        this.webappDir = webappDir;
    }

    public void setSmartclientRuntimeDir(String smartclientRuntimeDir) {
        this.smartclientRuntimeDir = smartclientRuntimeDir;
    }

    public void setIncludeTestJsp(boolean includeTestJsp) {
        this.includeTestJsp = includeTestJsp;
    }

    public void setTestJspPathname(String testJspPathname) {
        this.testJspPathname = testJspPathname;
    }

    public void setIncludeTestHtml(boolean includeTestHtml) {
        this.includeTestHtml = includeTestHtml;
    }

    public void setTestHtmlPathname(String testHtmlPathname) {
        this.testHtmlPathname = testHtmlPathname;
    }

    public void setDataSourcesDir(String dataSourcesDir) {
        this.dataSourcesDir = dataSourcesDir;
    }

    public void setMockDataSourcesDir(String mockDataSourcesDir) {
        this.mockDataSourcesDir = mockDataSourcesDir;
    }

    public void setSkipValidationOnImport(boolean skipValidationOnImport) {
        this.skipValidationOnImport = skipValidationOnImport;
    }

    public void setValidationFailureThreshold(ErrorMessage.Severity validationFailureThreshold) {
        this.validationFailureThreshold = validationFailureThreshold;
    }

    public void setUiDir(String uiDir) {
        this.uiDir = uiDir;
    }

    public void setProjectFileDir(String projectFileDir) {
        this.projectFileDir = projectFileDir;
    }

    public void setModifyWelcomeFiles(boolean modifyWelcomeFiles) {
        this.modifyWelcomeFiles = modifyWelcomeFiles;
    }

    public void setDrawOnWelcomeFiles(boolean drawOnWelcomeFiles) {
        this.drawOnWelcomeFiles = drawOnWelcomeFiles;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

