/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.packaging;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.isomorphic.maven.packaging.License;
import com.isomorphic.maven.packaging.Product;
import com.isomorphic.maven.util.AntPathMatcherFilter;
import com.isomorphic.maven.util.ArchiveUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public final class Distribution {
    private static final Logger LOGGER = LoggerFactory.getLogger(Distribution.class);
    private static final String LINK_SELECTOR = "(?i)\\.(zip|jar)";
    private static final String DOC_INCLUDES = "**/*.pdf";
    private static final String DOC_EXCLUDES = "**/apache-ant*/**";
    private static final String JAR_INCLUDES = "**/isc-*.jar, **/isomorphic_*.jar, **/smartgwt-*.jar, **/archetype-*.jar";
    private static final String JAR_EXCLUDES = "**/samples/**, **/*examples.jar, **/*tomcat*.jar, **/*isomorphic_web_services.jar, **/isomorphic_applets.jar";
    private static final String JAR_CONFLICTS = "**/smartgwtee.jar, **/isc-jakarta-oro*.jar, **/isomorphic_realtime_messaging.jar";
    private static final String POM_SMARTCLIENT = "**/smartclient-*resources.pom, **/smartclient-tools.xml, **/smartclient-messaging.xml, **/smartclient-analytics.xml";
    private static final String POM_SMARTGWT = "**/smartgwt-skins.pom, **/smartgwt-analytics.pom, **/smartgwt-messaging.pom";
    private static final String POM_SERVER = "**/isomorphic-*.pom, **/isomorphic-*.xml, **/dependencygroup-*.xml";
    private static final String POM_SHARED = "**/isc-*.pom, **/isc-*.xml, **/archetype-*.pom, **/archetype-*.xml";
    private static final String SELENIUM_INCLUDES = "**/selenium/**, **/batchReport.template";
    private static final String SMARTCLIENT_RUNTIME_INCLUDES = "**/smartclientRuntime/isomorphic/**, **/smartclientRuntime/WEB-INF/classes/**, **/smartclientRuntime/WEB-INF/iscTaglib.xml";
    private static final String SMARTCLIENT_SDK_INCLUDES = "**/smartclientSDK/tools/**";
    private static final String SMARTCLIENT_SDK_EXCLUDES = "**/dsBrowser.jsp,**/classBrowser.jsp,**/sqlBrowser.jsp,**/maven/**";
    private static final String SMARTCLIENT_JAVADOC = "**/smartclientSDK/isomorphic/system/reference/server/javadoc/**";
    private static final String SMARTGWT_CLIENT_JAVADOC = "**/doc/javadoc/**";
    private static final String SMARTGWT_SERVER_JAVADOC = "**/doc/server/javadoc/**";
    private static final Table<Product, License, Distribution> DISTRIBUTIONS = HashBasedTable.create();
    Product product;
    License license;
    private String remoteIndex = "/builds/#product/#version/#license/#date";
    private List<String> selectors = new ArrayList<String>();
    private Map<String, AntPathMatcherFilter> content = new HashMap<String, AntPathMatcherFilter>();
    private Set<File> files = new HashSet<File>();
    private Map<String, String> skinResources = new HashMap<String, String>();

    private static Distribution create(Product product, License license) {
        return Distribution.create(product, license, LINK_SELECTOR);
    }

    private static Distribution create(Product product, License license, String ... links) {
        Distribution distribution = new Distribution(product, license);
        distribution.include(links);
        ArrayList<String> pomIncludes = new ArrayList<String>();
        if (product == Product.SMARTCLIENT) {
            pomIncludes.add(POM_SMARTCLIENT);
            distribution.contents("sdk/#smartclientSDK", "**/smartclientSDK/**", SMARTCLIENT_SDK_EXCLUDES).contents("assembly/smartclient-resources/#smartclientRuntime", SMARTCLIENT_RUNTIME_INCLUDES, "**/ISC_Analytics*,**/modules*/ISC_RealtimeMessaging*").skins("/assembly/smartclient-resources.zip", "isomorphic/skins").contents("assembly/smartclient-analytics-resources/isomorphic/system/modules", "ISC_Analytics*,**/modules/ISC_Analytics*", null).contents("assembly/smartclient-analytics-resources/isomorphic/system/modules-debug", "**/modules-debug/ISC_Analytics*", null).contents("assembly/smartclient-messaging-resources/isomorphic/system/modules", "ISC_RealtimeMessaging*,**/modules/ISC_RealtimeMessaging*", null).contents("assembly/smartclient-messaging-resources/isomorphic/system/modules-debug", "**/modules-debug/ISC_RealtimeMessaging*", null).contents("assembly/smartclient-tools-resources/#smartclientSDK", SMARTCLIENT_SDK_INCLUDES, SMARTCLIENT_SDK_EXCLUDES);
        } else if (product == Product.SMARTGWT) {
            distribution.contents("lib/smartgwt-analytics.jar", "**/analytics.jar", null).contents("lib/smartgwt-messaging.jar", "**/messaging.jar", null).skins("/lib/smartgwt-skins.jar", "com/smartclient/theme").skins("/lib/smartgwt-" + license.getName() + ".jar", "com/smartclient/theme");
            pomIncludes.add(POM_SMARTGWT);
        }
        pomIncludes.add("**/" + product.getName() + "-" + license.getName() + "*");
        pomIncludes.add(POM_SHARED);
        if (license != License.LGPL) {
            pomIncludes.add(POM_SERVER);
        }
        distribution.contents("pom", Joiner.on((String)",").join(pomIncludes), null).contents("doc/user", DOC_INCLUDES, DOC_EXCLUDES).contents("doc/api/client/#javadoc", SMARTGWT_CLIENT_JAVADOC, null).contents("doc/api/server/#javadoc", product == Product.SMARTGWT ? SMARTGWT_SERVER_JAVADOC : SMARTCLIENT_JAVADOC, null).contents("lib", JAR_INCLUDES, "**/samples/**, **/*examples.jar, **/*tomcat*.jar, **/*isomorphic_web_services.jar, **/isomorphic_applets.jar, **/smartgwtee.jar, **/isc-jakarta-oro*.jar, **/isomorphic_realtime_messaging.jar").contents("lib/isc-jakarta-oro.jar", "**/isc-jakarta-oro*.jar", null).contents("lib/isomorphic-messaging.jar", "**/isomorphic_realtime_messaging.jar", null).contents("assembly/isc-selenium-resources", SELENIUM_INCLUDES, null);
        if (license == License.EVAL || license == License.POWER || license == License.ENTERPRISE) {
            distribution.contents("assembly/isc-batchuploader-resources/ds", "**/batchUpload.ds.xml", null);
        }
        DISTRIBUTIONS.put((Object)product, (Object)license, (Object)distribution);
        return distribution;
    }

    public static Distribution get(Product product, License license) {
        Distribution result = (Distribution)DISTRIBUTIONS.get((Object)product, (Object)license);
        if (result == null) {
            throw new IllegalArgumentException("Unknown distribution for product " + (Object)((Object)product) + " and license " + (Object)((Object)license) + ".");
        }
        return result;
    }

    private Distribution(Product product, License license) {
        this.product = product;
        this.license = license;
    }

    public Set<File> getFiles() {
        return this.files;
    }

    private Distribution contents(String key, String includes, String excludes) {
        this.content.put(key, new AntPathMatcherFilter(includes, excludes));
        return this;
    }

    private Distribution include(String ... links) {
        this.selectors.clear();
        for (String pattern : links) {
            this.selectors.add("a[href~=" + pattern + "]");
        }
        return this;
    }

    private Distribution index(String key, String replacement) {
        this.remoteIndex = this.remoteIndex.replaceAll(key, replacement);
        return this;
    }

    String getRemoteIndex(String buildNumber, String buildDate) {
        return this.remoteIndex.replaceAll("#product", this.product.toString()).replaceAll("#version", StringUtils.defaultString((String)buildNumber)).replaceAll("#license", this.license.toString()).replaceAll("#date", StringUtils.defaultString((String)buildDate));
    }

    String getRemoteIndexFilter() {
        return Joiner.on((String)",").join(this.selectors);
    }

    public void unpack(File to) throws IOException {
        File server;
        block0: for (File file : this.files) {
            String ext = FilenameUtils.getExtension((String)file.getName()).toUpperCase();
            if (!"ZIP".equals(ext)) {
                for (Map.Entry<String, AntPathMatcherFilter> filterEntry : this.content.entrySet()) {
                    AntPathMatcherFilter filter = filterEntry.getValue();
                    if (!filter.accept(file.getName())) continue;
                    File target = FileUtils.getFile((File)to, (String[])new String[]{ArchiveUtils.rewritePath(file.getName(), filterEntry.getKey())});
                    FileUtils.copyFile((File)file, (File)target);
                    LOGGER.debug("Copied file '{}' to file '{}'", (Object)file.getName(), (Object)target.getAbsolutePath());
                    continue block0;
                }
                FileUtils.copyFileToDirectory((File)file, (File)new File(to, "lib"));
                continue;
            }
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                for (Map.Entry<String, AntPathMatcherFilter> filterEntry : this.content.entrySet()) {
                    AntPathMatcherFilter filter = filterEntry.getValue();
                    if (!filter.accept(entry.getName())) continue;
                    File target = FileUtils.getFile((File)to, (String[])new String[]{ArchiveUtils.rewritePath(entry.getName(), filterEntry.getKey())});
                    FileUtils.copyInputStreamToFile((InputStream)zip.getInputStream(entry), (File)target);
                    LOGGER.debug("Copied input stream to file '{}'", (Object)target.getAbsolutePath());
                }
            }
            zip.close();
        }
        File assembliesDir = new File(to, "assembly");
        List assemblies = CollectionUtils.arrayToList((Object)assembliesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.isDirectory();
            }
        }));
        for (Object o : assemblies) {
            File assembly = (File)o;
            String name = FilenameUtils.getBaseName((String)assembly.getName());
            LOGGER.debug("Copying resources for assembly '{}'", (Object)name);
            ArchiveUtils.zip(assembly, FileUtils.getFile((File)assembliesDir, (String[])new String[]{name + ".zip"}));
            FileUtils.deleteQuietly((File)assembly);
        }
        LOGGER.debug("Repackaging Javadoc...");
        File docLib = new File(to, "doc/lib");
        File client = FileUtils.getFile((File)to, (String[])new String[]{"doc/api/client"});
        if (client.exists()) {
            ArchiveUtils.jar(client, new File(docLib, "smartgwt-javadoc.jar"));
        }
        if ((server = FileUtils.getFile((File)to, (String[])new String[]{"doc/api/server"})).exists()) {
            ArchiveUtils.jar(server, new File(docLib, "isomorphic-javadoc.jar"));
        }
    }

    private Distribution skins(String pathToFile, String pathToSkinDir) {
        this.skinResources.put(pathToFile, pathToSkinDir);
        return this;
    }

    public Map<String, String> getSkinResources() {
        return this.skinResources;
    }

    static {
        Distribution.create(Product.SMARTCLIENT, License.LGPL);
        Distribution.create(Product.SMARTCLIENT, License.EVAL);
        Distribution.create(Product.SMARTCLIENT, License.PRO);
        Distribution.create(Product.SMARTCLIENT, License.POWER);
        Distribution.create(Product.SMARTCLIENT, License.ENTERPRISE);
        Distribution.create(Product.SMARTCLIENT, License.ANALYTICS_MODULE);
        Distribution.create(Product.SMARTCLIENT, License.MESSAGING_MODULE);
        Distribution.create(Product.SMARTGWT, License.LGPL).include("smartgwt-.*\\.zip").contents("lib/smartgwt-lgpl.jar", "**/smartgwt.jar", null);
        Distribution.create(Product.SMARTGWT, License.EVAL).index("#license", "EnterpriseEval").contents("lib/smartgwt-eval.jar", "**/smartgwtee.jar", null);
        Distribution.create(Product.SMARTGWT, License.PRO).contents("lib/smartgwt-pro.jar", "**/smartgwtpro.jar", null);
        Distribution.create(Product.SMARTGWT, License.POWER).contents("lib/smartgwt-power.jar", "**/smartgwtpower.jar", null);
        Distribution.create(Product.SMARTGWT, License.ENTERPRISE).contents("lib/smartgwt-enterprise.jar", "**/smartgwtee.jar", null);
        Distribution.create(Product.SMARTGWT, License.ANALYTICS_MODULE);
        Distribution.create(Product.SMARTGWT, License.MESSAGING_MODULE);
        Distribution.create(Product.SMARTGWT_MOBILE, License.LGPL).include("smartgwt-.*\\.zip").contents("doc/user", "smartgwt-mobile*/user_guide.*", null);
    }
}

