/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.AntPathMatcher;

public class AntPathMatcherFilter {
    private static final AntPathMatcher matcher = new AntPathMatcher();
    private final List<String> includes = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();

    public AntPathMatcherFilter() {
        this.include("**/*");
    }

    public AntPathMatcherFilter(String includes, String excludes) {
        this.include(includes);
        this.exclude(excludes);
    }

    public AntPathMatcherFilter include(String patterns) {
        if (patterns != null) {
            String[] split;
            for (String pattern : split = patterns.split(",")) {
                this.includes.add(pattern.trim());
            }
        }
        return this;
    }

    public AntPathMatcherFilter exclude(String patterns) {
        if (patterns != null) {
            String[] split;
            for (String pattern : split = patterns.split(",")) {
                this.excludes.add(pattern.trim());
            }
        }
        return this;
    }

    public boolean accept(String path) {
        for (String exclusion : this.excludes) {
            if (!matcher.match(exclusion, path)) continue;
            return false;
        }
        boolean matched = false;
        for (String inclusion : this.includes) {
            if (!matcher.match(inclusion, path)) continue;
            matched = true;
            break;
        }
        return matched;
    }

    public AntPathMatcherFilter copy() {
        AntPathMatcherFilter source = this;
        AntPathMatcherFilter destination = new AntPathMatcherFilter();
        Collections.copy(destination.includes, source.includes);
        Collections.copy(destination.excludes, source.excludes);
        return destination;
    }
}

