/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.util;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;

public class ArchiveUtils {
    public static void jar(File directory, File output) throws IOException {
        JarArchiver ja = new JarArchiver();
        ja.addFileSet((FileSet)new DefaultFileSet(directory));
        ja.setDestFile(output);
        ja.createArchive();
    }

    public static void zip(File directory, File output) throws IOException {
        ZipArchiver za = new ZipArchiver();
        za.addFileSet((FileSet)new DefaultFileSet(directory));
        za.setDestFile(output);
        za.createArchive();
    }

    public static void unzip(File source, File target) throws IOException {
        ZipUnArchiver ua = new ZipUnArchiver(source);
        ua.setDestFile(target);
        ua.extract();
    }

    public static String rewritePath(String oldValue, String newValue) {
        String filename;
        String path = newValue;
        if ("".equals(FilenameUtils.getExtension((String)newValue))) {
            filename = FilenameUtils.getName((String)oldValue);
        } else {
            path = FilenameUtils.getPath((String)newValue);
            filename = FilenameUtils.getName((String)newValue);
        }
        Pattern p = Pattern.compile("(.*?)#(.*?)(?:$|(/.*))");
        Matcher m = p.matcher(path);
        if (m.find()) {
            String prefix = m.group(1);
            String dir = m.group(2);
            String suffix = m.group(3);
            int index = oldValue.indexOf(dir);
            int length = dir.length();
            String remainder = FilenameUtils.getPath((String)oldValue.substring(index + length));
            path = prefix != null && !prefix.equals("") ? prefix + remainder : remainder;
            if (suffix != null && !suffix.equals("")) {
                path = path + suffix;
            }
        }
        return FilenameUtils.normalize((String)(path + "/" + filename));
    }
}

