/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.util;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.StringUtils;

public class LoggingCountingOutputStream
extends CountingOutputStream {
    private final long expectedByteCount;
    private long snapshotStart = System.currentTimeMillis();
    private long snapshotBytes;
    private long bytesPerSecond;

    public LoggingCountingOutputStream(OutputStream out, long expectedByteCount) {
        super(out);
        this.expectedByteCount = expectedByteCount;
    }

    protected void afterWrite(int bytesWritten) throws IOException {
        super.afterWrite(bytesWritten);
        long byteCount = this.getByteCount();
        double progress = (double)byteCount / (double)this.expectedByteCount * 100.0;
        this.snapshotBytes += (long)bytesWritten;
        if (System.currentTimeMillis() - this.snapshotStart >= 1000L) {
            this.snapshotStart = System.currentTimeMillis();
            this.bytesPerSecond = this.snapshotBytes;
            this.snapshotBytes = 0L;
        }
        System.out.print("\r" + StringUtils.rightPad((String)(FileUtils.byteCountToDisplaySize((long)byteCount) + " / " + FileUtils.byteCountToDisplaySize((long)this.expectedByteCount) + " (" + FileUtils.byteCountToDisplaySize((long)this.bytesPerSecond) + "/second) " + String.format("%.1f%%", progress)), (int)60, (String)" "));
        if (progress >= 100.0) {
            System.out.println("Done!");
        }
    }
}

