/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken;

import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.utils.Array;
import com.isoterik.racken.GameCamera;
import com.isoterik.racken.GameObject;
import com.isoterik.racken.Scene;
import com.isoterik.racken.input.InputManager;

public class Component {
    protected GameObject gameObject;
    protected Scene scene;
    protected InputManager input;
    protected GameCamera renderCamera;
    protected boolean enabled = true;

    public void attach() {
    }

    public void start() {
    }

    public void resume() {
    }

    public void preUpdate(float deltaTime) {
    }

    public void update(float deltaTime) {
    }

    public void postUpdate(float deltaTime) {
    }

    public void resize(int newScreenWidth, int newScreenHeight) {
    }

    public void preRender() {
    }

    public void render() {
    }

    public void postRender() {
    }

    public void renderShapeLine(ShapeRenderer shapeRenderer) {
    }

    public void renderShapeFilled(ShapeRenderer shapeRenderer) {
    }

    public void renderShapePoint(ShapeRenderer shapeRenderer) {
    }

    public void pause() {
    }

    public void detach() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public GameCamera getRenderCamera() {
        return this.renderCamera;
    }

    public void setRenderCamera(GameCamera renderCamera) {
        this.renderCamera = renderCamera;
    }

    public void componentAdded(Component component) {
    }

    public void componentRemoved(Component component) {
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void __setGameObject(GameObject gameObject) {
        this.gameObject = gameObject;
    }

    public void __setHostScene(Scene scene) {
        this.scene = scene;
        this.input = scene != null ? scene.getInput() : null;
    }

    public GameObject getGameObject() {
        return this.gameObject;
    }

    public void addComponent(Component component) {
        if (this.gameObject != null) {
            this.gameObject.addComponent(component);
        }
    }

    public <T extends Component> T getComponent(Class<T> componentClass) {
        if (this.gameObject != null) {
            return this.gameObject.getComponent(componentClass);
        }
        return null;
    }

    public <T extends Component> Array<T> getComponents(Class<T> componentClass) {
        if (this.gameObject != null) {
            return this.gameObject.getComponents(componentClass);
        }
        return null;
    }

    public Array<Component> getComponents() {
        if (this.gameObject != null) {
            return this.gameObject.getComponents();
        }
        return null;
    }

    public <T extends Component> boolean hasComponent(Class<T> componentClass) {
        if (this.gameObject != null) {
            return this.gameObject.hasComponent(componentClass);
        }
        return false;
    }

    public boolean hasComponent(Component component) {
        if (this.gameObject != null) {
            return this.gameObject.hasComponent(component);
        }
        return false;
    }

    public <T extends Component> boolean removeComponent(Class<T> componentClass) {
        if (this.gameObject != null) {
            return this.gameObject.removeComponent(componentClass);
        }
        return false;
    }

    public <T extends Component> void removeComponents(Class<T> componentClass) {
        if (this.gameObject != null) {
            this.gameObject.removeComponents(componentClass);
        }
    }

    public boolean removeComponent(Component component) {
        if (this.gameObject != null) {
            return this.gameObject.removeComponent(component);
        }
        return false;
    }

    public boolean removeGameObject(GameObject gameObject) {
        if (this.scene != null) {
            return this.scene.removeGameObject(gameObject);
        }
        return false;
    }

    public void addGameObject(GameObject gameObject) {
        if (this.scene != null) {
            this.scene.addGameObject(gameObject);
        }
    }

    public GameObject findGameObject(String tag) {
        if (this.scene != null) {
            return this.scene.findGameObject(tag);
        }
        return null;
    }

    public void forEachGameObject(GameObject.GameObjectIterationListener iterationListener) {
        if (this.scene != null) {
            this.scene.forEachGameObject(iterationListener);
        }
    }
}

