/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.viewport.ExtendViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.isoterik.racken.utils.GameWorldUnits;

public abstract class GameCamera {
    protected Camera camera;
    protected Viewport viewport;
    protected boolean centerCameraOnResize = false;
    protected boolean centerCameraOnUpdate = false;
    protected Vector2 screenBoundsPositionRatio = new Vector2();
    protected Vector2 screenBoundsSizeRatio = new Vector2(1.0f, 1.0f);
    protected boolean screenJustResized = true;

    public GameCamera(Viewport viewport) {
        this.viewport = viewport;
        this.setup(viewport);
    }

    public GameCamera(GameWorldUnits gameWorldUnits, Camera camera) {
        this((Viewport)new ExtendViewport(gameWorldUnits.getWorldWidth(), gameWorldUnits.getWorldHeight(), camera));
    }

    public void setup(Viewport viewport) {
        this.viewport = viewport;
        this.camera = viewport.getCamera();
        viewport.update(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), true);
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public float getViewportWidth() {
        return this.camera.viewportWidth;
    }

    public float getViewportHeight() {
        return this.camera.viewportHeight;
    }

    public boolean isCenterCameraOnResize() {
        return this.centerCameraOnResize;
    }

    public void setCenterCameraOnResize(boolean centerCameraOnResize) {
        this.centerCameraOnResize = centerCameraOnResize;
    }

    public boolean isCenterCameraOnUpdate() {
        return this.centerCameraOnUpdate;
    }

    public void setCenterCameraOnUpdate(boolean centerCameraOnUpdate) {
        this.centerCameraOnUpdate = centerCameraOnUpdate;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setScreenBoundsRatio(float screenXRatio, float screenYRatio, float screenWidthRatio, float screenHeightRatio) {
        this.screenBoundsPositionRatio.set(screenXRatio, screenYRatio);
        this.screenBoundsSizeRatio.set(screenWidthRatio, screenHeightRatio);
    }

    public Vector2 getScreenBoundsPositionRatio() {
        return this.screenBoundsPositionRatio;
    }

    public Vector2 getScreenBoundsSizeRatio() {
        return this.screenBoundsSizeRatio;
    }

    public void __resize(int newScreenWidth, int newScreenHeight) {
        this.viewport.update(newScreenWidth, newScreenHeight, this.centerCameraOnResize);
        this.screenJustResized = true;
    }

    public void __preRender() {
        if (this.viewport != null) {
            if (this.screenJustResized) {
                int w = Gdx.graphics.getWidth();
                int h = Gdx.graphics.getHeight();
                int sx = (int)((float)w * this.screenBoundsPositionRatio.x);
                int sy = (int)((float)h * this.screenBoundsPositionRatio.y);
                int sw = (int)((float)w * this.screenBoundsSizeRatio.x);
                int sh = (int)((float)h * this.screenBoundsSizeRatio.y);
                this.viewport.setScreenBounds(sx, sy, sw, sh);
                this.screenJustResized = false;
            }
            this.viewport.apply(this.centerCameraOnUpdate);
        }
    }

    public abstract void __postRender();

    public abstract void __destroy();
}

