/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.isoterik.racken.Component;
import com.isoterik.racken.Scene;
import com.isoterik.racken.Transform;

public final class GameObject {
    private final SnapshotArray<Component> components = new SnapshotArray(Component.class);
    private final SnapshotArray<GameObject> children = new SnapshotArray(GameObject.class);
    public final Transform transform = new Transform();
    private String tag;
    private Scene hostScene;
    private GameObject parent;

    private GameObject() {
        this("Untagged");
    }

    private GameObject(String tag) {
        this.transform.__setGameObject(this);
        this.components.add((Object)this.transform);
        this.tag = tag;
    }

    public void addChildren(GameObject ... children) {
        for (GameObject child : children) {
            this.addChild(child);
        }
    }

    public void addChild(GameObject child) {
        if (child.hasParent()) {
            throw new IllegalStateException("A GameObject cannot have more than one parent: Tag=" + child.getTag());
        }
        if (!this.children.contains((Object)child, true)) {
            this.children.add((Object)child);
            child.setParent(this);
        }
    }

    public boolean removeChild(GameObject child) {
        boolean removed = this.children.removeValue((Object)child, true);
        if (removed) {
            child.setParent(null);
        }
        return removed;
    }

    public void clearChildren() {
        for (GameObject child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
    }

    public SnapshotArray<GameObject> getChildren() {
        return this.children;
    }

    public void __setHostScene(Scene hostScene) {
        this.hostScene = hostScene;
        for (Component comp : this.components) {
            comp.__setHostScene(hostScene);
            if (comp.getRenderCamera() != null) continue;
            comp.setRenderCamera(hostScene.getMainCamera());
        }
        this.forEachChild(gameObject -> gameObject.__setHostScene(hostScene));
    }

    public void setParent(GameObject parent) {
        this.parent = parent;
    }

    public GameObject getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Scene getHostScene() {
        return this.hostScene;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void __removeFromScene() {
        for (Component comp : this.components) {
            comp.stop();
        }
        this.forEachChild(GameObject::__removeFromScene);
    }

    public void addComponent(Component component) {
        if (this.components.contains((Object)component, true)) {
            return;
        }
        component.__setGameObject(this);
        component.attach();
        for (Component comp : this.components) {
            comp.componentAdded(component);
        }
        if (this.hostScene != null) {
            component.__setHostScene(this.hostScene);
            if (component.getRenderCamera() == null) {
                component.setRenderCamera(this.hostScene.getMainCamera());
            }
            component.start();
        }
        this.components.add((Object)component);
    }

    public boolean removeComponent(Component component) {
        if (this.components.contains((Object)component, true) && this.components.removeValue((Object)component, true)) {
            for (Component comp : this.components) {
                comp.componentRemoved(component);
            }
            component.detach();
            component.__setGameObject(null);
            return true;
        }
        return false;
    }

    public <T extends Component> boolean removeComponent(Class<T> componentClass) {
        return this.removeComponent((Component)this.getComponent(componentClass));
    }

    public <T extends Component> void removeComponents(Class<T> componentClass) {
        for (Component c : this.components) {
            if (!ClassReflection.isAssignableFrom(componentClass, c.getClass())) continue;
            this.removeComponent(c);
        }
    }

    public <T extends Component> T getComponent(Class<T> componentClass) {
        for (Component c : this.components) {
            if (!ClassReflection.isAssignableFrom(componentClass, c.getClass())) continue;
            return (T)c;
        }
        return null;
    }

    public <T extends Component> Array<T> getComponents(Class<T> componentClass) {
        Array comps = new Array();
        for (Component c : this.components) {
            if (!ClassReflection.isAssignableFrom(componentClass, c.getClass())) continue;
            comps.add((Object)c);
        }
        return comps;
    }

    public SnapshotArray<Component> getComponents() {
        return this.components;
    }

    public <T extends Component> boolean hasComponent(Class<T> componentClass) {
        return this.getComponent(componentClass) != null;
    }

    public boolean hasComponent(Component component) {
        return this.components.contains((Object)component, true);
    }

    public void forEachComponent(ComponentIterationListener iterationListener, boolean withChildren) {
        Component[] array;
        for (Component component : array = (Component[])this.components.begin()) {
            if (component == null) continue;
            iterationListener.onIterate(component);
        }
        this.components.end();
        if (withChildren) {
            this.forEachChild(gameObject -> gameObject.forEachComponent(iterationListener));
        }
    }

    public void forEachComponent(ComponentIterationListener iterationListener) {
        this.forEachComponent(iterationListener, true);
    }

    public void forEachChild(GameObjectIterationListener iterationListener) {
        GameObject[] array;
        for (GameObject gameObject : array = (GameObject[])this.children.begin()) {
            if (gameObject == null) continue;
            iterationListener.onIterate(gameObject);
        }
        this.children.end();
    }

    public boolean sameTag(String otherTag) {
        return this.tag.equals(otherTag);
    }

    public static GameObject newInstance(String tag) {
        return new GameObject(tag);
    }

    public static GameObject newInstance() {
        return new GameObject();
    }

    public static interface GameObjectIterationListener {
        public void onIterate(GameObject var1);
    }

    public static interface ComponentIterationListener {
        public void onIterate(Component var1);
    }
}

