/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.graphics.FPSLogger;
import com.isoterik.racken.Scene;
import com.isoterik.racken.SceneManager;
import com.isoterik.racken._2d.scenes.transition.ISceneTransition;
import com.isoterik.racken.asset.GameAssetsLoader;
import com.isoterik.racken.audio.AudioManager;
import com.isoterik.racken.input.InputManager;

public final class Racken {
    private static Racken instance;
    public final Application app = Gdx.app;
    public final Graphics graphics = Gdx.graphics;
    public final GameAssetsLoader assets;
    public final AudioManager audio;
    public final SceneManager sceneManager;
    public final DefaultSettings defaultSettings;
    private float deltaTime;
    private boolean logFPS;
    private final FPSLogger fpsLogger;

    public static void __init() {
        instance = new Racken();
    }

    public static Racken instance() {
        return instance;
    }

    private Racken() {
        AudioManager.__init();
        this.audio = AudioManager.instance();
        GameAssetsLoader.__init();
        this.assets = GameAssetsLoader.instance();
        SceneManager.__init();
        this.sceneManager = SceneManager.instance();
        InputManager.__initPools();
        this.defaultSettings = new DefaultSettings();
        this.fpsLogger = new FPSLogger();
    }

    public void setScene(Scene scene, ISceneTransition transition) {
        this.sceneManager.setCurrentScene(scene, transition);
    }

    public void setScene(Scene scene) {
        this.setScene(scene, null);
    }

    public void revertToPreviousScene(ISceneTransition transition) {
        this.sceneManager.revertToPreviousScene(transition);
    }

    public void revertToPreviousScene() {
        this.revertToPreviousScene(null);
    }

    public void exit() {
        this.app.exit();
    }

    public void __resume() {
        this.sceneManager.__resume();
    }

    public void __pause() {
        this.sceneManager.__pause();
    }

    public void __resize(int width, int height) {
        this.sceneManager.__resize(width, height);
    }

    public void __render() {
        this.deltaTime = Math.min(Gdx.graphics.getDeltaTime(), 0.016666668f);
        this.sceneManager.__render();
        if (this.logFPS) {
            this.fpsLogger.log();
        }
    }

    public void __dispose() {
        this.sceneManager.__dispose();
        this.assets.__dispose();
    }

    public float getDeltaTime() {
        return this.deltaTime;
    }

    public boolean isLogFPS() {
        return this.logFPS;
    }

    public void setLogFPS(boolean logFPS) {
        this.logFPS = logFPS;
    }

    public static class DefaultSettings {
        public float VIEWPORT_WIDTH = 1280.0f;
        public float VIEWPORT_HEIGHT = 720.0f;
        public float PIXELS_PER_UNIT = 100.0f;
        public float CAMERA_NEAR = 1.0f;
        public float CAMERA_FAR = 300.0f;
        public float CAMERA_FIELD_OF_VIEW = 67.0f;
    }
}

