/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.SnapshotArray;
import com.badlogic.gdx.utils.viewport.StretchViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.isoterik.racken.Component;
import com.isoterik.racken.GameCamera;
import com.isoterik.racken.GameObject;
import com.isoterik.racken.Racken;
import com.isoterik.racken._2d.GameCamera2d;
import com.isoterik.racken._2d.components.renderer.SpriteRenderer;
import com.isoterik.racken.input.InputManager;
import com.isoterik.racken.utils.GameWorldUnits;

public class Scene {
    protected Racken racken;
    protected GameWorldUnits gameWorldUnits;
    protected final InputManager input;
    private float deltaTime;
    protected GameObject.ComponentIterationListener startIter;
    protected GameObject.ComponentIterationListener pauseIter;
    protected GameObject.ComponentIterationListener preRenderIter;
    protected GameObject.ComponentIterationListener postRenderIter;
    protected GameObject.ComponentIterationListener resumeIter;
    protected GameObject.ComponentIterationListener preUpdateIter;
    protected GameObject.ComponentIterationListener updateIter;
    protected GameObject.ComponentIterationListener resizeIter;
    protected GameObject.ComponentIterationListener postUpdateIter;
    protected GameObject.ComponentIterationListener destroyIter;
    private boolean isActive;
    protected Stage uiCanvas;
    protected ShapeRenderer shapeRenderer;
    protected boolean renderCustomDebugLines;
    protected boolean stackable = true;
    protected GameCamera mainCamera;
    private int resizedWidth;
    private int resizedHeight;
    protected final SnapshotArray<GameObject> gameObjects = new SnapshotArray(GameObject.class);
    protected final Array<GameCamera> cameras = new Array();
    protected Color backgroundColor;

    public Scene() {
        this.racken = Racken.instance();
        this.onCreate();
        this.gameWorldUnits = new GameWorldUnits(this.racken.defaultSettings.VIEWPORT_WIDTH, this.racken.defaultSettings.VIEWPORT_HEIGHT, this.racken.defaultSettings.PIXELS_PER_UNIT);
        this.input = new InputManager(this);
        this.startIter = component -> {
            if (component.isEnabled()) {
                component.start();
            }
        };
        this.resumeIter = component -> {
            if (component.isEnabled()) {
                component.resume();
            }
        };
        this.pauseIter = component -> {
            if (component.isEnabled()) {
                component.pause();
            }
        };
        this.resizeIter = component -> {
            if (component.isEnabled()) {
                component.resize(this.resizedWidth, this.resizedHeight);
            }
        };
        this.preUpdateIter = component -> {
            if (component.isEnabled()) {
                component.preUpdate(this.deltaTime);
            }
        };
        this.updateIter = component -> {
            if (component.isEnabled()) {
                component.update(this.deltaTime);
            }
        };
        this.postUpdateIter = component -> {
            if (component.isEnabled()) {
                component.postUpdate(this.deltaTime);
            }
        };
        this.preRenderIter = component -> {
            if (component.isEnabled()) {
                component.preRender();
            }
        };
        this.postRenderIter = component -> {
            if (component.isEnabled()) {
                component.postRender();
            }
        };
        this.destroyIter = Component::destroy;
        this.backgroundColor = new Color(1.0f, 0.0f, 0.0f, 1.0f);
        this.mainCamera = new GameCamera2d();
        this.addCamera(this.mainCamera);
        this.setupUICanvas((Viewport)new StretchViewport(this.gameWorldUnits.getScreenWidth(), this.gameWorldUnits.getScreenHeight()));
        this.shapeRenderer = new ShapeRenderer();
    }

    protected void onCreate() {
    }

    public GameWorldUnits getGameWorldUnits() {
        return this.gameWorldUnits;
    }

    public boolean isStackable() {
        return this.stackable;
    }

    public void setStackable(boolean stackable) {
        this.stackable = stackable;
    }

    public void setRenderDebugLines(boolean renderCustomDebugLines) {
        this.renderCustomDebugLines = renderCustomDebugLines;
    }

    public boolean isRenderDebugLines() {
        return this.renderCustomDebugLines;
    }

    public void setupUICanvas(Viewport viewport) {
        if (this.uiCanvas != null) {
            this.input.getInputMultiplexer().removeProcessor((InputProcessor)this.uiCanvas);
        }
        this.uiCanvas = new Stage(viewport);
        this.input.getInputMultiplexer().addProcessor((InputProcessor)this.uiCanvas);
    }

    public Stage getUICanvas() {
        return this.uiCanvas;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public InputManager getInput() {
        return this.input;
    }

    public void setMainCamera(GameCamera mainCamera) {
        this.removeMainCamera();
        this.mainCamera = mainCamera;
        this.addCamera(mainCamera);
    }

    public GameCamera getMainCamera() {
        return this.mainCamera;
    }

    public void addCamera(GameCamera camera) {
        if (!this.cameras.contains((Object)camera, true)) {
            this.cameras.add((Object)camera);
        }
    }

    public void removeCamera(GameCamera camera) {
        this.cameras.removeValue((Object)camera, true);
    }

    public void removeMainCamera() {
        if (this.mainCamera != null) {
            this.mainCamera.__destroy();
            this.cameras.removeValue((Object)this.mainCamera, true);
            this.mainCamera = null;
        }
    }

    public void forEachGameObject(GameObject.GameObjectIterationListener iterationListener) {
        GameObject[] array;
        for (GameObject gameObject : array = (GameObject[])this.gameObjects.begin()) {
            if (gameObject == null) continue;
            iterationListener.onIterate(gameObject);
        }
        this.gameObjects.end();
    }

    public void addGameObject(GameObject gameObject) {
        if (gameObject.hasParent()) {
            throw new IllegalStateException("A GameObject with a parent cannot be added directly to the Scene, the parent should be added instead: GameObject's Tag=" + gameObject.getTag());
        }
        gameObject.__setHostScene(this);
        this.gameObjects.add((Object)gameObject);
        gameObject.forEachComponent(this.startIter);
    }

    public boolean removeGameObject(GameObject gameObject) {
        boolean removed = this.gameObjects.removeValue((Object)gameObject, true);
        if (removed) {
            gameObject.__removeFromScene();
            gameObject.__setHostScene(null);
        }
        return removed;
    }

    public SnapshotArray<GameObject> getGameObjects() {
        return this.gameObjects;
    }

    public GameObject findGameObject(String tag) {
        for (GameObject gameObject : this.gameObjects) {
            if (!gameObject.sameTag(tag)) continue;
            return gameObject;
        }
        return null;
    }

    public Array<GameObject> findGameObjects(String tag, Array<GameObject> out) {
        if (out == null) {
            out = new Array();
        }
        for (GameObject gameObject : this.gameObjects) {
            if (!gameObject.sameTag(tag)) continue;
            out.add((Object)gameObject);
        }
        return out;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void __resize(int width, int height) {
        this.resizedWidth = width;
        this.resizedHeight = height;
        for (GameCamera camera : this.cameras) {
            camera.__resize(width, height);
        }
        this.forEachGameObject(gameObject -> gameObject.forEachComponent(this.resizeIter));
        this.uiCanvas.getViewport().update(width, height, true);
    }

    public void __resume() {
        this.isActive = true;
        this.forEachGameObject(gameObject -> gameObject.forEachComponent(this.resumeIter));
    }

    public void __pause() {
        this.isActive = false;
        this.forEachGameObject(gameObject -> gameObject.forEachComponent(this.pauseIter));
    }

    private void updateComponents() {
        this.forEachGameObject(gameObject -> gameObject.forEachComponent(this.preUpdateIter));
        this.forEachGameObject(gameObject -> gameObject.forEachComponent(this.updateIter));
        this.forEachGameObject(gameObject -> gameObject.forEachComponent(this.postUpdateIter));
    }

    public void __update(float deltaTime) {
        this.deltaTime = deltaTime;
        this.input.__update();
        this.updateComponents();
        this.uiCanvas.act(deltaTime);
    }

    public void __render() {
        this.render();
        if (this.renderCustomDebugLines) {
            this.renderDebugDrawings();
        }
        this.uiCanvas.draw();
    }

    protected void render() {
        ScreenUtils.clear((Color)this.backgroundColor);
        this.forEachGameObject(gameObject -> gameObject.forEachComponent(this.preRenderIter));
        for (GameCamera camera : this.cameras) {
            camera.__preRender();
            this.forEachGameObject(gameObject -> gameObject.forEachComponent(component -> {
                if (component.isEnabled() && component.getRenderCamera() == camera) {
                    component.render();
                }
            }));
            camera.__postRender();
        }
        this.forEachGameObject(gameObject -> gameObject.forEachComponent(this.postRenderIter));
    }

    protected void renderDebugDrawings() {
        for (GameCamera camera : this.cameras) {
            camera.__preRender();
            this.shapeRenderer.setProjectionMatrix(camera.getCamera().combined);
            this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            this.forEachGameObject(gameObject -> gameObject.forEachComponent(component -> {
                if (component.isEnabled() && component.getRenderCamera() == camera) {
                    component.renderShapeFilled(this.shapeRenderer);
                }
            }));
            this.shapeRenderer.end();
            this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            this.forEachGameObject(gameObject -> gameObject.forEachComponent(component -> {
                if (component.isEnabled() && component.getRenderCamera() == camera) {
                    component.renderShapeLine(this.shapeRenderer);
                }
            }));
            this.shapeRenderer.end();
            this.shapeRenderer.begin(ShapeRenderer.ShapeType.Point);
            this.forEachGameObject(gameObject -> gameObject.forEachComponent(component -> {
                if (component.isEnabled() && component.getRenderCamera() == camera) {
                    component.renderShapePoint(this.shapeRenderer);
                }
            }));
            this.shapeRenderer.end();
            camera.__postRender();
        }
    }

    public void __destroy() {
        this.forEachGameObject(gameObject -> gameObject.forEachComponent(this.destroyIter));
        this.uiCanvas.dispose();
        for (GameCamera camera : this.cameras) {
            camera.__destroy();
        }
    }

    public void transitionedFromThisScene(Scene nextScene) {
    }

    public void transitionedToThisScene(Scene previousScene) {
    }

    public void pauseForTransition() {
    }

    public GameObject newSpriteObject(String tag, TextureRegion sprite, GameWorldUnits gameWorldUnits) {
        GameObject go = GameObject.newInstance(tag);
        SpriteRenderer sr = new SpriteRenderer(sprite, gameWorldUnits);
        go.addComponent(sr);
        return go;
    }

    public GameObject newSpriteObject(String tag, TextureRegion sprite) {
        return this.newSpriteObject(tag, sprite, this.gameWorldUnits);
    }

    public GameObject newSpriteObject(TextureRegion sprite, GameWorldUnits gameWorldUnits) {
        return this.newSpriteObject("Untagged", sprite, gameWorldUnits);
    }

    public GameObject newSpriteObject(TextureRegion sprite) {
        return this.newSpriteObject("Untagged", sprite);
    }

    public GameObject newSpriteObject(String tag, Texture sprite, GameWorldUnits gameWorldUnits) {
        return this.newSpriteObject(tag, new TextureRegion(sprite), gameWorldUnits);
    }

    public GameObject newSpriteObject(String tag, Texture sprite) {
        return this.newSpriteObject(tag, sprite, this.gameWorldUnits);
    }

    public GameObject newSpriteObject(Texture sprite) {
        return this.newSpriteObject("Untagged", sprite);
    }
}

