/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Array;
import com.isoterik.racken.Racken;
import com.isoterik.racken.Scene;
import com.isoterik.racken._2d.scenes.transition.ISceneTransition;

public class SceneManager {
    private boolean init;
    private Scene currScene;
    private Scene nextScene;
    private Scene prevScene;
    private FrameBuffer currFbo;
    private FrameBuffer nextFbo;
    private SpriteBatch batch;
    private float elapsedTime;
    private ISceneTransition sceneTransition;
    private final Array<Scene> sceneStack = new Array();
    private static SceneManager instance;

    public static void __init() {
        instance = new SceneManager();
    }

    public static SceneManager instance() {
        return instance;
    }

    private SceneManager() {
    }

    public void setCurrentScene(Scene scene) {
        this.setCurrentScene(scene, null);
    }

    public void setCurrentScene(Scene scene, ISceneTransition sceneTransition) {
        if (!this.init) {
            int w = Gdx.graphics.getWidth();
            int h = Gdx.graphics.getHeight();
            if (this.currFbo != null) {
                this.currFbo.dispose();
                this.nextFbo.dispose();
                this.batch.dispose();
            }
            this.currFbo = new FrameBuffer(Pixmap.Format.RGB888, w, h, false);
            this.nextFbo = new FrameBuffer(Pixmap.Format.RGB888, w, h, false);
            this.batch = new SpriteBatch();
            this.init = true;
        }
        this.nextScene = scene;
        this.nextScene.__resume();
        this.nextScene.__update(0.0f);
        this.nextScene.__render();
        if (this.currScene != null) {
            this.currScene.pauseForTransition();
        }
        Gdx.input.setInputProcessor(null);
        this.sceneTransition = sceneTransition;
        this.elapsedTime = 0.0f;
        this.prevScene = this.currScene;
        if (scene.isStackable()) {
            this.pushScene(scene);
        }
    }

    public void __render() {
        float deltaTime = Racken.instance().getDeltaTime();
        if (this.nextScene == null) {
            if (this.currScene != null) {
                this.currScene.__update(deltaTime);
                this.currScene.__render();
            }
        } else {
            float duration = 0.0f;
            if (this.sceneTransition != null) {
                duration = this.sceneTransition.getDuration();
            }
            this.elapsedTime = Math.min(this.elapsedTime + deltaTime, duration);
            if (this.sceneTransition == null || this.elapsedTime >= duration) {
                if (this.currScene != null) {
                    this.currScene.__pause();
                }
                this.nextScene.__resume();
                Gdx.input.setInputProcessor((InputProcessor)this.nextScene.getInput().getInputMultiplexer());
                Scene tempCurr = this.currScene;
                Scene tempNext = this.nextScene;
                ISceneTransition tempTransition = this.sceneTransition;
                if (this.currScene != null && !this.currScene.isStackable()) {
                    this.currScene.__destroy();
                }
                this.currScene = this.nextScene;
                this.nextScene = null;
                this.sceneTransition = null;
                if (tempCurr != null) {
                    tempCurr.transitionedFromThisScene(tempNext);
                }
                if (tempNext != null) {
                    tempNext.transitionedToThisScene(tempCurr);
                }
            } else {
                this.currFbo.begin();
                if (this.currScene != null) {
                    this.currScene.__render();
                }
                this.currFbo.end();
                this.nextFbo.begin();
                this.nextScene.__render();
                this.nextFbo.end();
                float alpha = this.elapsedTime / duration;
                this.sceneTransition.render(this.batch, (Texture)this.currFbo.getColorBufferTexture(), (Texture)this.nextFbo.getColorBufferTexture(), alpha);
            }
        }
    }

    public void __pause() {
        if (this.currScene != null) {
            this.currScene.__pause();
        }
    }

    public void __resize(int width, int height) {
        if (this.currScene != null) {
            this.currScene.__resize(width, height);
        }
    }

    public void __resume() {
        if (this.currScene != null) {
            this.currScene.__resume();
            Gdx.input.setInputProcessor((InputProcessor)this.currScene.getInput().getInputMultiplexer());
        }
    }

    public void __dispose() {
        if (this.currScene != null) {
            this.currScene.__destroy();
        }
        if (this.nextScene != null) {
            this.nextScene.__destroy();
        }
        if (this.sceneStack.contains((Object)this.currScene, true)) {
            this.sceneStack.removeValue((Object)this.currScene, true);
        }
        if (this.sceneStack.contains((Object)this.nextScene, true)) {
            this.sceneStack.removeValue((Object)this.nextScene, true);
        }
        for (Scene scene : this.sceneStack) {
            scene.__destroy();
        }
        this.sceneStack.clear();
        if (this.init) {
            this.currFbo.dispose();
            this.currScene = null;
            this.nextFbo.dispose();
            this.nextScene = null;
            this.batch.dispose();
            this.init = false;
        }
    }

    public Scene getPreviousScene() {
        return this.prevScene;
    }

    public Scene getCurrentScene() {
        return this.currScene;
    }

    public void revertToPreviousScene(ISceneTransition transition) {
        if (!this.canRevertToPreviousScene()) {
            return;
        }
        this.popScene();
        Scene temp = this.popScene();
        if (temp == null) {
            return;
        }
        this.setCurrentScene(temp, transition);
    }

    public void revertToPreviousScene() {
        this.revertToPreviousScene(null);
    }

    protected void pushScene(Scene scene) {
        if (this.sceneStack.contains((Object)scene, true)) {
            return;
        }
        this.sceneStack.add((Object)scene);
    }

    protected Scene popScene() {
        if (this.sceneStack.isEmpty()) {
            return null;
        }
        return (Scene)this.sceneStack.pop();
    }

    public boolean canRevertToPreviousScene() {
        return this.sceneStack.size >= 2;
    }
}

