/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector3;
import com.isoterik.racken.Component;
import com.isoterik.racken.GameObject;

public class Transform
extends Component {
    public final Vector3 position;
    public final Vector3 scale;
    public final Vector3 size;
    public final Vector3 origin;
    public final Vector3 rotation;
    private Transform world;
    protected final Vector3 temp = new Vector3();

    public Transform() {
        this.position = new Vector3(0.0f, 0.0f, 0.0f);
        this.scale = new Vector3(1.0f, 1.0f, 1.0f);
        this.size = new Vector3(0.0f, 0.0f, 0.0f);
        this.origin = new Vector3(0.0f, 0.0f, 0.0f);
        this.rotation = new Vector3(0.0f, 0.0f, 0.0f);
    }

    public void setOrigin(float originX, float originY, float originZ) {
        this.origin.set(originX, originY, originZ);
    }

    public void setOrigin(float originX, float originY) {
        this.setOrigin(originX, originY, this.origin.z);
    }

    public void setOriginPercent(float widthPercent, float heightPercent, float depthPercent) {
        this.origin.set(this.size.x * widthPercent, this.size.y * heightPercent, this.size.z * depthPercent);
    }

    public void setOriginPercent(float widthPercent, float heightPercent) {
        this.setOriginPercent(widthPercent, heightPercent, 0.0f);
    }

    public void setOriginPercent(float percent) {
        this.setOriginPercent(percent, percent, percent);
    }

    public void setSize(float width, float height, float depth) {
        this.size.set(width, height, depth);
    }

    public void setSize(float width, float height) {
        this.setSize(width, height, this.size.z);
    }

    public void setWidth(float width) {
        this.size.x = width;
    }

    public void setHeight(float height) {
        this.size.y = height;
    }

    public void setDepth(float depth) {
        this.size.z = depth;
    }

    public void setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
    }

    public void setPosition(float x, float y) {
        this.setPosition(x, y, this.position.z);
    }

    public void setX(float x) {
        this.position.x = x;
    }

    public void setY(float y) {
        this.position.y = y;
    }

    public void setZ(float z) {
        this.position.z = z;
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scale.set(scaleX, scaleY, scaleZ);
    }

    public void setScale(float scaleX, float scaleY) {
        this.setScale(scaleX, scaleY, this.scale.z);
    }

    public void setScaleX(float scaleX) {
        this.scale.x = scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scale.y = scaleY;
    }

    public void setScaleZ(float scaleZ) {
        this.scale.z = scaleZ;
    }

    public void setRotation(float rotationX, float rotationY, float rotationZ) {
        this.rotation.set(rotationX, rotationY, rotationZ);
    }

    public void setRotation(float rotation) {
        this.setRotation(0.0f, 0.0f, rotation);
    }

    public Vector3 getRotationVector() {
        return this.rotation;
    }

    public float getRotation() {
        return this.rotation.z;
    }

    public float getX() {
        return this.position.x;
    }

    public float getY() {
        return this.position.y;
    }

    public float getZ() {
        return this.position.z;
    }

    public float getScaleX() {
        return this.scale.x;
    }

    public float getScaleY() {
        return this.scale.y;
    }

    public float getScaleZ() {
        return this.scale.z;
    }

    public float getWidth() {
        return this.size.x;
    }

    public float getHeight() {
        return this.size.y;
    }

    public float getDepth() {
        return this.size.z;
    }

    public float getOriginX() {
        return this.origin.x;
    }

    public float getOriginY() {
        return this.origin.y;
    }

    public float getOriginZ() {
        return this.origin.x;
    }

    public float getRotationX() {
        return this.rotation.x;
    }

    public float getRotationY() {
        return this.rotation.y;
    }

    public float getRotationZ() {
        return this.rotation.z;
    }

    public void copyInto(Transform transform) {
        if (transform == null) {
            throw new IllegalArgumentException("Target transform cannot be null");
        }
        transform.position.set(this.position);
        transform.size.set(this.size);
        transform.origin.set(this.origin);
        transform.rotation.set(this.rotation);
        transform.scale.set(this.scale);
    }

    public Transform getWorldTransform(Transform out) {
        if (out == null) {
            out = new Transform();
        }
        this.copyInto(out);
        if (this.gameObject != null && this.gameObject.hasParent()) {
            GameObject parent = this.gameObject.getParent();
            Transform parentTransform = parent.transform;
            out.position.add(parentTransform.position);
            out.rotation.add(parentTransform.rotation);
            out.scale.add(parentTransform.scale);
        }
        return out;
    }

    public Transform world() {
        if (this.world == null) {
            this.world = new Transform();
        }
        this.getWorldTransform(this.world);
        return this.world;
    }

    public void translate(float x, float y, float z) {
        this.position.add(x, y, z);
    }

    public void translate(float x, float y) {
        this.translate(x, y, 0.0f);
    }

    public void rotate(float degAngle) {
        this.rotation.z += degAngle;
    }

    public float calcDiagonal() {
        float w = this.size.x;
        float h = this.size.y;
        float d = this.size.z;
        float scaleX = this.scale.x;
        float scaleY = this.scale.y;
        float scaleZ = this.scale.z;
        return (float)Math.sqrt(Math.pow(w * scaleX, 2.0) + Math.pow(h * scaleY, 2.0) + Math.pow(d * scaleZ, 2.0));
    }

    public boolean isInCameraFrustum(Camera camera) {
        float x = this.position.x;
        float y = this.position.y;
        float z = this.position.z;
        float w = this.size.x;
        float h = this.size.y;
        float d = this.size.z;
        this.temp.set(x + w * 0.5f, y + h * 0.5f, z + d * 0.5f);
        return camera.frustum.sphereInFrustum(this.temp, this.calcDiagonal() * 0.5f);
    }

    @Override
    public void attach() {
        if (this.hasComponent(Transform.class)) {
            throw new UnsupportedOperationException("There can only be one Transform component for a GameObject!");
        }
    }

    @Override
    public void detach() {
        throw new UnsupportedOperationException("You cannot detach the Transform component!");
    }

    @Override
    public void addComponent(Component component) {
        if (component instanceof Transform && this.hasComponent(Transform.class)) {
            throw new UnsupportedOperationException("There can only be one Transform component for a GameObject!");
        }
    }
}

