/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken._2d;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.isoterik.racken.GameCamera;
import com.isoterik.racken.Racken;
import com.isoterik.racken.utils.GameWorldUnits;

public class GameCamera2d
extends GameCamera {
    protected SpriteBatch spriteBatch = new SpriteBatch();

    public GameCamera2d(Viewport viewport) {
        super(viewport);
        this.centerCameraOnResize = true;
    }

    public GameCamera2d(GameWorldUnits gameWorldUnits) {
        this((Viewport)new FitViewport(gameWorldUnits.getWorldWidth(), gameWorldUnits.getWorldHeight()));
    }

    public GameCamera2d() {
        this(new GameWorldUnits(Racken.instance().defaultSettings.VIEWPORT_WIDTH, Racken.instance().defaultSettings.VIEWPORT_HEIGHT, Racken.instance().defaultSettings.PIXELS_PER_UNIT));
    }

    public void setSpriteBatch(SpriteBatch spriteBatch) {
        this.spriteBatch = spriteBatch;
    }

    public SpriteBatch getSpriteBatch() {
        return this.spriteBatch;
    }

    public OrthographicCamera getCamera() {
        return (OrthographicCamera)this.camera;
    }

    @Override
    public void setup(Viewport viewport) {
        if (this.camera == null || !(this.camera instanceof OrthographicCamera)) {
            this.camera = new OrthographicCamera(viewport.getWorldWidth(), viewport.getWorldHeight());
            this.getCamera().setToOrtho(false, viewport.getWorldWidth(), viewport.getWorldHeight());
            viewport.setCamera(this.camera);
            this.camera.update();
        }
        super.setup(viewport);
    }

    @Override
    public void __destroy() {
        if (this.spriteBatch != null) {
            this.spriteBatch.dispose();
            this.spriteBatch = null;
        }
    }

    @Override
    public void __preRender() {
        super.__preRender();
        this.spriteBatch.setProjectionMatrix(this.camera.combined);
        this.spriteBatch.begin();
    }

    @Override
    public void __postRender() {
        this.spriteBatch.end();
    }
}

