/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken._2d.components.debug;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.isoterik.racken.Component;
import com.isoterik.racken.Transform;

public abstract class BaseDebugRenderer
extends Component {
    public static final ShapeRenderer.ShapeType LINE_SHAPE = ShapeRenderer.ShapeType.Line;
    public static final ShapeRenderer.ShapeType FILLED_SHAPE = ShapeRenderer.ShapeType.Filled;
    public static final ShapeRenderer.ShapeType POINT_SHAPE = ShapeRenderer.ShapeType.Point;
    protected ShapeRenderer.ShapeType shapeType;
    protected Color color;
    protected Transform worldTransformCache;

    public BaseDebugRenderer(ShapeRenderer.ShapeType shapeType, Color color) {
        this.shapeType = shapeType;
        this.color = color;
    }

    public BaseDebugRenderer(ShapeRenderer.ShapeType shapeType) {
        this(shapeType, Color.WHITE);
    }

    public BaseDebugRenderer() {
        this(LINE_SHAPE);
    }

    public BaseDebugRenderer setColor(Color color) {
        this.color = color;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public BaseDebugRenderer setShapeType(ShapeRenderer.ShapeType shapeType) {
        this.shapeType = shapeType;
        return this;
    }

    public ShapeRenderer.ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public void postRender() {
        this.worldTransformCache = this.gameObject.transform.world();
    }

    @Override
    public void renderShapeLine(ShapeRenderer shapeRenderer) {
        if (this.shapeType == LINE_SHAPE) {
            shapeRenderer.setColor(this.color);
            this.draw(shapeRenderer);
        }
    }

    @Override
    public void renderShapeFilled(ShapeRenderer shapeRenderer) {
        if (this.shapeType == FILLED_SHAPE) {
            shapeRenderer.setColor(this.color);
            this.draw(shapeRenderer);
        }
    }

    @Override
    public void renderShapePoint(ShapeRenderer shapeRenderer) {
        if (this.shapeType == POINT_SHAPE) {
            shapeRenderer.setColor(this.color);
            this.draw(shapeRenderer);
        }
    }

    public abstract void draw(ShapeRenderer var1);
}

