/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken._2d.components.renderer;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.isoterik.racken.Component;
import com.isoterik.racken.Transform;
import com.isoterik.racken._2d.GameCamera2d;
import com.isoterik.racken.utils.GameWorldUnits;

public class SpriteRenderer
extends Component {
    protected TextureRegion sprite;
    protected Color color;
    protected boolean flipX;
    protected boolean flipY;
    protected boolean cull;
    protected boolean visible;
    protected GameWorldUnits gameWorldUnits;

    public SpriteRenderer(TextureRegion sprite, GameWorldUnits gameWorldUnits) {
        this.gameWorldUnits = gameWorldUnits;
        this.sprite = sprite;
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.flipX = false;
        this.flipY = false;
        this.cull = true;
        this.visible = true;
    }

    public SpriteRenderer(Texture sprite, GameWorldUnits gameWorldUnits) {
        this(new TextureRegion(sprite), gameWorldUnits);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setCull(boolean cull) {
        this.cull = cull;
    }

    public boolean isCull() {
        return this.cull;
    }

    public void setSprite(TextureRegion sprite, GameWorldUnits gameWorldUnits) {
        this.sprite = sprite;
        this.gameWorldUnits = gameWorldUnits;
        this.setWorldSize();
    }

    public void setSprite(TextureRegion sprite) {
        this.setSprite(sprite, this.gameWorldUnits);
    }

    public TextureRegion getSprite() {
        return this.sprite;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setOpacity(float opacity) {
        this.color.a = opacity;
    }

    public float getOpacity() {
        return this.color.a;
    }

    public void setFlipX(boolean flipX) {
        this.flipX = flipX;
    }

    public boolean isFlipX() {
        return this.flipX;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public boolean isFlipY() {
        return this.flipY;
    }

    public void setWorldSize() {
        if (this.gameObject == null) {
            return;
        }
        Vector2 worldSize = this.gameWorldUnits.toWorldUnit(this.sprite);
        this.gameObject.transform.setSize(worldSize.x, worldSize.y);
        this.gameObject.transform.setOrigin(worldSize.x * 0.5f, worldSize.y * 0.5f, 0.0f);
    }

    @Override
    public void attach() {
        this.setWorldSize();
    }

    @Override
    public void render() {
        if (!this.visible) {
            return;
        }
        if (this.renderCamera == null || !(this.renderCamera instanceof GameCamera2d)) {
            return;
        }
        if (this.cull) {
            if (this.gameObject.transform.isInCameraFrustum(this.renderCamera.getCamera())) {
                this.drawSprite((GameCamera2d)this.renderCamera);
            }
        } else {
            this.drawSprite((GameCamera2d)this.renderCamera);
        }
    }

    protected void drawSprite(GameCamera2d gameCamera) {
        SpriteBatch batch = gameCamera.getSpriteBatch();
        batch.setColor(this.color);
        Transform transform = this.gameObject.transform.world();
        Vector3 pos = transform.position;
        Vector3 size = transform.size;
        Vector3 scale = transform.scale;
        Vector3 origin = transform.origin;
        float rotation = transform.getRotation();
        batch.draw(this.sprite.getTexture(), pos.x, pos.y, origin.x, origin.y, size.x, size.y, scale.x, scale.y, rotation, this.sprite.getRegionX(), this.sprite.getRegionY(), this.sprite.getRegionWidth(), this.sprite.getRegionHeight(), this.flipX, this.flipY);
    }
}

