/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken._2d.components.renderer;

import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.MapRenderer;
import com.badlogic.gdx.maps.objects.CircleMapObject;
import com.badlogic.gdx.maps.objects.EllipseMapObject;
import com.badlogic.gdx.maps.objects.PolygonMapObject;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.maps.tiled.objects.TiledMapTileMapObject;
import com.badlogic.gdx.maps.tiled.renderers.OrthoCachedTiledMapRenderer;
import com.badlogic.gdx.utils.Array;
import com.isoterik.racken.Component;
import com.isoterik.racken._2d.GameCamera2d;
import java.util.Iterator;

public class TiledMapRenderer
extends Component {
    public final int mapWidth;
    public final int mapHeight;
    public final int tileWidth;
    public final int tileHeight;
    public final int horizontalTilesCount;
    public final int verticalTilesCount;
    protected final TiledMap tiledMap;
    protected final float unitScale;
    protected MapRenderer tiledMapRenderer;

    public TiledMapRenderer(TiledMap tiledMap, float unitScale) {
        this.tiledMap = tiledMap;
        this.unitScale = unitScale;
        this.tileWidth = (Integer)tiledMap.getProperties().get("tilewidth");
        this.tileHeight = (Integer)tiledMap.getProperties().get("tileheight");
        this.horizontalTilesCount = (Integer)tiledMap.getProperties().get("width");
        this.verticalTilesCount = (Integer)tiledMap.getProperties().get("height");
        this.mapWidth = this.tileWidth * this.horizontalTilesCount;
        this.mapHeight = this.tileHeight * this.verticalTilesCount;
        this.tiledMapRenderer = new OrthoCachedTiledMapRenderer(tiledMap, unitScale);
        ((OrthoCachedTiledMapRenderer)this.tiledMapRenderer).setBlending(true);
    }

    public TiledMapRenderer(String mapFileName, float unitScale) {
        this(new TmxMapLoader().load(mapFileName), unitScale);
    }

    protected void renderTiledMap() {
        this.tiledMapRenderer.render();
    }

    @Override
    public void preUpdate(float deltaTime) {
        if (this.renderCamera != null && this.renderCamera instanceof GameCamera2d) {
            this.tiledMapRenderer.setView(((GameCamera2d)this.renderCamera).getCamera());
        }
    }

    @Override
    public void render() {
        if (this.renderCamera != null && this.renderCamera instanceof GameCamera2d) {
            this.renderTiledMap();
        }
    }

    public MapRenderer getTiledMapRenderer() {
        return this.tiledMapRenderer;
    }

    public void setTiledMapRenderer(MapRenderer tiledMapRenderer) {
        this.tiledMapRenderer = tiledMapRenderer;
    }

    public <T> Array<RectangleMapObject> getRectangleObjects(MapLayer mapLayer, String propertyName, T value) {
        Array found = new Array();
        for (MapObject mapObject : mapLayer.getObjects()) {
            if (!(mapObject instanceof RectangleMapObject)) continue;
            if (propertyName.equals("*")) {
                found.add((Object)((RectangleMapObject)mapObject));
                continue;
            }
            MapProperties mapProperties = mapObject.getProperties();
            if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
            found.add((Object)((RectangleMapObject)mapObject));
        }
        return found;
    }

    public Array<RectangleMapObject> getRectangleObjects(MapLayer mapLayer) {
        return this.getRectangleObjects(mapLayer, "*", null);
    }

    public <T> Array<RectangleMapObject> getRectangleObjects(String propertyName, T value) {
        Array found = new Array();
        for (MapLayer mapLayer : this.tiledMap.getLayers()) {
            for (MapObject mapObject : mapLayer.getObjects()) {
                if (!(mapObject instanceof RectangleMapObject)) continue;
                if (propertyName.equals("*")) {
                    found.add((Object)((RectangleMapObject)mapObject));
                    continue;
                }
                MapProperties mapProperties = mapObject.getProperties();
                if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
                found.add((Object)((RectangleMapObject)mapObject));
            }
        }
        return found;
    }

    public Array<RectangleMapObject> getRectangleObjects() {
        return this.getRectangleObjects("*", null);
    }

    public <T> Array<CircleMapObject> getCircleObjects(MapLayer mapLayer, String propertyName, T value) {
        Array found = new Array();
        for (MapObject mapObject : mapLayer.getObjects()) {
            if (!(mapObject instanceof CircleMapObject)) continue;
            if (propertyName.equals("*")) {
                found.add((Object)((CircleMapObject)mapObject));
                continue;
            }
            MapProperties mapProperties = mapObject.getProperties();
            if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
            found.add((Object)((CircleMapObject)mapObject));
        }
        return found;
    }

    public Array<CircleMapObject> getCircleObjects(MapLayer mapLayer) {
        return this.getCircleObjects(mapLayer, "*", null);
    }

    public <T> Array<CircleMapObject> getCircleObjects(String propertyName, T value) {
        Array found = new Array();
        for (MapLayer mapLayer : this.tiledMap.getLayers()) {
            for (MapObject mapObject : mapLayer.getObjects()) {
                if (!(mapObject instanceof CircleMapObject)) continue;
                if (propertyName.equals("*")) {
                    found.add((Object)((CircleMapObject)mapObject));
                    continue;
                }
                MapProperties mapProperties = mapObject.getProperties();
                if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
                found.add((Object)((CircleMapObject)mapObject));
            }
        }
        return found;
    }

    public Array<CircleMapObject> getCircleObjects() {
        return this.getCircleObjects("*", null);
    }

    public <T> Array<EllipseMapObject> getEllipseObjects(MapLayer mapLayer, String propertyName, T value) {
        Array found = new Array();
        for (MapObject mapObject : mapLayer.getObjects()) {
            if (!(mapObject instanceof EllipseMapObject)) continue;
            if (propertyName.equals("*")) {
                found.add((Object)((EllipseMapObject)mapObject));
                continue;
            }
            MapProperties mapProperties = mapObject.getProperties();
            if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
            found.add((Object)((EllipseMapObject)mapObject));
        }
        return found;
    }

    public Array<EllipseMapObject> getEllipseObjects(MapLayer mapLayer) {
        return this.getEllipseObjects(mapLayer, "*", null);
    }

    public <T> Array<EllipseMapObject> getEllipseObjects(String propertyName, T value) {
        Array found = new Array();
        for (MapLayer mapLayer : this.tiledMap.getLayers()) {
            for (MapObject mapObject : mapLayer.getObjects()) {
                if (!(mapObject instanceof EllipseMapObject)) continue;
                if (propertyName.equals("*")) {
                    found.add((Object)((EllipseMapObject)mapObject));
                    continue;
                }
                MapProperties mapProperties = mapObject.getProperties();
                if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
                found.add((Object)((EllipseMapObject)mapObject));
            }
        }
        return found;
    }

    public Array<EllipseMapObject> getEllipseObjects() {
        return this.getEllipseObjects("*", null);
    }

    public <T> Array<PolygonMapObject> getPolygonObjects(MapLayer mapLayer, String propertyName, T value) {
        Array found = new Array();
        for (MapObject mapObject : mapLayer.getObjects()) {
            if (!(mapObject instanceof PolygonMapObject)) continue;
            if (propertyName.equals("*")) {
                found.add((Object)((PolygonMapObject)mapObject));
                continue;
            }
            MapProperties mapProperties = mapObject.getProperties();
            if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
            found.add((Object)((PolygonMapObject)mapObject));
        }
        return found;
    }

    public Array<PolygonMapObject> getPolygonObjects(MapLayer mapLayer) {
        return this.getPolygonObjects(mapLayer, "*", null);
    }

    public <T> Array<PolygonMapObject> getPolygonObjects(String propertyName, T value) {
        Array found = new Array();
        for (MapLayer mapLayer : this.tiledMap.getLayers()) {
            for (MapObject mapObject : mapLayer.getObjects()) {
                if (!(mapObject instanceof PolygonMapObject)) continue;
                if (propertyName.equals("*")) {
                    found.add((Object)((PolygonMapObject)mapObject));
                    continue;
                }
                MapProperties mapProperties = mapObject.getProperties();
                if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
                found.add((Object)((PolygonMapObject)mapObject));
            }
        }
        return found;
    }

    public Array<PolygonMapObject> getPolygonObjects() {
        return this.getPolygonObjects("*", null);
    }

    public <T> Array<PolylineMapObject> getPolylineObjects(MapLayer mapLayer, String propertyName, T value) {
        Array found = new Array();
        for (MapObject mapObject : mapLayer.getObjects()) {
            if (!(mapObject instanceof PolylineMapObject)) continue;
            if (propertyName.equals("*")) {
                found.add((Object)((PolylineMapObject)mapObject));
                continue;
            }
            MapProperties mapProperties = mapObject.getProperties();
            if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
            found.add((Object)((PolylineMapObject)mapObject));
        }
        return found;
    }

    public Array<PolylineMapObject> getPolylineObjects(MapLayer mapLayer) {
        return this.getPolylineObjects(mapLayer, "*", null);
    }

    public <T> Array<PolylineMapObject> getPolylineObjects(String propertyName, T value) {
        Array found = new Array();
        for (MapLayer mapLayer : this.tiledMap.getLayers()) {
            for (MapObject mapObject : mapLayer.getObjects()) {
                if (!(mapObject instanceof PolylineMapObject)) continue;
                if (propertyName.equals("*")) {
                    found.add((Object)((PolylineMapObject)mapObject));
                    continue;
                }
                MapProperties mapProperties = mapObject.getProperties();
                if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
                found.add((Object)((PolylineMapObject)mapObject));
            }
        }
        return found;
    }

    public Array<PolylineMapObject> getPolylineObjects() {
        return this.getPolylineObjects("*", null);
    }

    public <T> Array<TiledMapTileMapObject> getTileObjects(MapLayer mapLayer, String propertyName, T value) {
        Array found = new Array();
        for (MapObject mapObject : mapLayer.getObjects()) {
            if (!(mapObject instanceof TiledMapTileMapObject)) continue;
            MapProperties mapProperties = mapObject.getProperties();
            TiledMapTileMapObject tiledMapTileMapObject = (TiledMapTileMapObject)mapObject;
            TiledMapTile tiledMapTile = tiledMapTileMapObject.getTile();
            MapProperties defaultProperties = tiledMapTile.getProperties();
            if (propertyName.equals("*")) {
                found.add((Object)((TiledMapTileMapObject)mapObject));
                continue;
            }
            Iterator propertyKeys = defaultProperties.getKeys();
            while (propertyKeys.hasNext()) {
                String key = (String)propertyKeys.next();
                if (mapProperties.containsKey(key)) continue;
                mapProperties.put(key, defaultProperties.get(key));
            }
            if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
            found.add((Object)tiledMapTileMapObject);
        }
        return found;
    }

    public Array<TiledMapTileMapObject> getTileObjects(MapLayer mapLayer) {
        return this.getTileObjects(mapLayer, "*", null);
    }

    public <T> Array<TiledMapTileMapObject> getTileObjects(String propertyName, T value) {
        Array found = new Array();
        for (MapLayer mapLayer : this.tiledMap.getLayers()) {
            for (MapObject mapObject : mapLayer.getObjects()) {
                if (!(mapObject instanceof TiledMapTileMapObject)) continue;
                if (propertyName.equals("*")) {
                    found.add((Object)((TiledMapTileMapObject)mapObject));
                    continue;
                }
                MapProperties mapProperties = mapObject.getProperties();
                TiledMapTileMapObject tiledMapTileMapObject = (TiledMapTileMapObject)mapObject;
                TiledMapTile tiledMapTile = tiledMapTileMapObject.getTile();
                MapProperties defaultProperties = tiledMapTile.getProperties();
                Iterator propertyKeys = defaultProperties.getKeys();
                while (propertyKeys.hasNext()) {
                    String key = (String)propertyKeys.next();
                    mapProperties.put(key, defaultProperties.get(key));
                }
                if (!mapProperties.containsKey(propertyName) || !mapProperties.get(propertyName).equals(value)) continue;
                found.add((Object)tiledMapTileMapObject);
            }
        }
        return found;
    }

    public Array<TiledMapTileMapObject> getTileObjects() {
        return this.getTileObjects("*", null);
    }
}

