/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken._2d.components.utils;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.utils.Array;
import com.isoterik.racken.Component;
import com.isoterik.racken.GameCamera;
import com.isoterik.racken.Racken;
import com.isoterik.racken._2d.GameCamera2d;
import com.isoterik.racken.input.IKeyListener;
import com.isoterik.racken.input.ITouchListener;
import com.isoterik.racken.input.ITrigger;
import com.isoterik.racken.input.KeyEventData;
import com.isoterik.racken.input.KeyTrigger;
import com.isoterik.racken.input.TouchEventData;
import com.isoterik.racken.input.Trigger;

public class CameraController
extends Component
implements IKeyListener,
ITouchListener {
    protected float movementSpeed = 5.0f;
    protected float zoomSpeed = 1.0f;
    public static final String MAPPING_MOVE_CAMERA_LEFT = "RK__MAPPING_MOVE_CAMERA_LEFT__";
    public static final String MAPPING_MOVE_CAMERA_RIGHT = "RK__MAPPING_MOVE_CAMERA_RIGHT__";
    public static final String MAPPING_MOVE_CAMERA_UP = "RK__MAPPING_MOVE_CAMERA_UP__";
    public static final String MAPPING_MOVE_CAMERA_DOWN = "RK__MAPPING_MOVE_CAMERA_DOWN__";
    public static final String MAPPING_ZOOM_IN_CAMERA = "RK__MAPPING_ZOOM_IN_CAMERA__";
    public static final String MAPPING_ZOOM_OUT_CAMERA = "RK__MAPPING_ZOOM_OUT_CAMERA__";
    public final Array<Trigger> moveLeftTriggers;
    public final Array<Trigger> moveRightTriggers;
    public final Array<Trigger> moveUpTriggers;
    public final Array<Trigger> moveDownTriggers;
    public final Array<Trigger> zoomInTriggers;
    public final Array<Trigger> zoomOutTriggers;
    protected ChangeListener changeListener;

    public CameraController(ChangeListener changeListener) {
        this.changeListener = changeListener;
        this.moveLeftTriggers = new Array((Object[])new Trigger[]{KeyTrigger.keyDownTrigger(21).setPolled(true), KeyTrigger.keyDownTrigger(29).setPolled(true)});
        this.moveRightTriggers = new Array((Object[])new Trigger[]{KeyTrigger.keyDownTrigger(22).setPolled(true), KeyTrigger.keyDownTrigger(32).setPolled(true)});
        this.moveDownTriggers = new Array((Object[])new Trigger[]{KeyTrigger.keyDownTrigger(20).setPolled(true), KeyTrigger.keyDownTrigger(47).setPolled(true)});
        this.moveUpTriggers = new Array((Object[])new Trigger[]{KeyTrigger.keyDownTrigger(19).setPolled(true), KeyTrigger.keyDownTrigger(51).setPolled(true)});
        this.zoomInTriggers = new Array((Object[])new Trigger[]{KeyTrigger.keyDownTrigger(45).setPolled(true), KeyTrigger.keyDownTrigger(81).setPolled(true)});
        this.zoomOutTriggers = new Array((Object[])new Trigger[]{KeyTrigger.keyDownTrigger(33).setPolled(true), KeyTrigger.keyDownTrigger(69).setPolled(true)});
    }

    public CameraController() {
        this(null);
    }

    protected void setupMappings() {
        this.input.addMapping(MAPPING_MOVE_CAMERA_LEFT, (ITrigger[])this.moveLeftTriggers.toArray());
        this.input.addMapping(MAPPING_MOVE_CAMERA_RIGHT, (ITrigger[])this.moveRightTriggers.toArray());
        this.input.addMapping(MAPPING_MOVE_CAMERA_UP, (ITrigger[])this.moveUpTriggers.toArray());
        this.input.addMapping(MAPPING_MOVE_CAMERA_DOWN, (ITrigger[])this.moveDownTriggers.toArray());
        this.input.addMapping(MAPPING_ZOOM_IN_CAMERA, (ITrigger[])this.zoomInTriggers.toArray());
        this.input.addMapping(MAPPING_ZOOM_OUT_CAMERA, (ITrigger[])this.zoomOutTriggers.toArray());
        this.input.mapListener(MAPPING_MOVE_CAMERA_LEFT, this);
        this.input.mapListener(MAPPING_MOVE_CAMERA_DOWN, this);
        this.input.mapListener(MAPPING_MOVE_CAMERA_RIGHT, this);
        this.input.mapListener(MAPPING_MOVE_CAMERA_UP, this);
        this.input.mapListener(MAPPING_ZOOM_IN_CAMERA, this);
        this.input.mapListener(MAPPING_ZOOM_OUT_CAMERA, this);
    }

    protected void removeMappings() {
        this.input.removeMapping(MAPPING_MOVE_CAMERA_LEFT);
        this.input.removeMapping(MAPPING_MOVE_CAMERA_RIGHT);
        this.input.removeMapping(MAPPING_MOVE_CAMERA_UP);
        this.input.removeMapping(MAPPING_MOVE_CAMERA_DOWN);
        this.input.removeMapping(MAPPING_ZOOM_IN_CAMERA);
        this.input.removeMapping(MAPPING_ZOOM_OUT_CAMERA);
        this.input.removeMappedListeners(MAPPING_MOVE_CAMERA_DOWN);
        this.input.removeMappedListeners(MAPPING_MOVE_CAMERA_UP);
        this.input.removeMappedListeners(MAPPING_MOVE_CAMERA_RIGHT);
        this.input.removeMappedListeners(MAPPING_MOVE_CAMERA_LEFT);
        this.input.removeMappedListeners(MAPPING_ZOOM_IN_CAMERA);
        this.input.removeMappedListeners(MAPPING_ZOOM_OUT_CAMERA);
    }

    @Override
    public void start() {
        this.setupMappings();
    }

    @Override
    public void detach() {
        this.removeMappings();
    }

    @Override
    public void stop() {
        this.removeMappings();
    }

    @Override
    public void onKey(String mappingName, KeyEventData keyEventData) {
        float deltaTime = Racken.instance().getDeltaTime();
        boolean changed = false;
        switch (mappingName) {
            case "RK__MAPPING_MOVE_CAMERA_RIGHT__": {
                this.moveCameraRight(deltaTime);
                changed = true;
                break;
            }
            case "RK__MAPPING_MOVE_CAMERA_LEFT__": {
                this.moveCameraLeft(deltaTime);
                changed = true;
                break;
            }
            case "RK__MAPPING_MOVE_CAMERA_UP__": {
                this.moveCameraUp(deltaTime);
                changed = true;
                break;
            }
            case "RK__MAPPING_MOVE_CAMERA_DOWN__": {
                this.moveCameraDown(deltaTime);
                changed = true;
                break;
            }
            case "RK__MAPPING_ZOOM_IN_CAMERA__": {
                this.zoomInCamera(deltaTime);
                changed = true;
                break;
            }
            case "RK__MAPPING_ZOOM_OUT_CAMERA__": {
                this.zoomOutCamera(deltaTime);
                changed = true;
            }
        }
        if (changed && this.changeListener != null) {
            this.changeListener.onKeyChange(this.renderCamera, keyEventData);
        }
    }

    @Override
    public void onTouch(String mappingName, TouchEventData touchEventData) {
    }

    protected void moveCameraRight(float deltaTime) {
        this.renderCamera.getCamera().translate(this.movementSpeed * deltaTime, 0.0f, 0.0f);
    }

    protected void moveCameraLeft(float deltaTime) {
        this.renderCamera.getCamera().translate(-this.movementSpeed * deltaTime, 0.0f, 0.0f);
    }

    protected void moveCameraUp(float deltaTime) {
        this.renderCamera.getCamera().translate(0.0f, this.movementSpeed * deltaTime, 0.0f);
    }

    protected void moveCameraDown(float deltaTime) {
        this.renderCamera.getCamera().translate(0.0f, -this.movementSpeed * deltaTime, 0.0f);
    }

    protected void zoomInCamera(float deltaTime) {
        if (this.renderCamera instanceof GameCamera2d) {
            OrthographicCamera camera = ((GameCamera2d)this.renderCamera).getCamera();
            camera.zoom -= this.zoomSpeed * deltaTime;
        }
    }

    protected void zoomOutCamera(float deltaTime) {
        if (this.renderCamera instanceof GameCamera2d) {
            OrthographicCamera camera = ((GameCamera2d)this.renderCamera).getCamera();
            camera.zoom += this.zoomSpeed * deltaTime;
        }
    }

    public float getMovementSpeed() {
        return this.movementSpeed;
    }

    public void setMovementSpeed(float movementSpeed) {
        this.movementSpeed = movementSpeed;
    }

    public float getZoomSpeed() {
        return this.zoomSpeed;
    }

    public void setZoomSpeed(float zoomSpeed) {
        this.zoomSpeed = zoomSpeed;
    }

    public ChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public static interface ChangeListener {
        public void onKeyChange(GameCamera var1, KeyEventData var2);
    }
}

