/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken._2d.scenes.transition;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.utils.Array;
import com.isoterik.racken._2d.scenes.transition.ISceneTransition;

public class Slice
implements ISceneTransition {
    private static final Slice instance = new Slice();
    private float duration;
    private int direction;
    private Interpolation easing;
    private final Array<Integer> sliceIndex = new Array();

    public static Slice init(float duration, int direction, int numSlices, Interpolation easing) {
        Slice.instance.duration = duration;
        Slice.instance.direction = direction;
        Slice.instance.easing = easing;
        Slice.instance.sliceIndex.clear();
        for (int i = 0; i < numSlices; ++i) {
            Slice.instance.sliceIndex.add((Object)i);
        }
        Slice.instance.sliceIndex.shuffle();
        return instance;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public void render(SpriteBatch batch, Texture currScreen, Texture nextScreen, float alpha) {
        float w = currScreen.getWidth();
        float h = currScreen.getHeight();
        float y = 0.0f;
        int sliceWidth = (int)(w / (float)this.sliceIndex.size);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        batch.begin();
        batch.draw(currScreen, 0.0f, 0.0f, 0.0f, 0.0f, w, h, 1.0f, 1.0f, 0.0f, 0, 0, currScreen.getWidth(), currScreen.getHeight(), false, true);
        if (this.easing != null) {
            alpha = this.easing.apply(alpha);
        }
        for (int i = 0; i < this.sliceIndex.size; ++i) {
            float x = i * sliceWidth;
            float offsetY = h * (1.0f + (float)((Integer)this.sliceIndex.get(i)).intValue() / (float)this.sliceIndex.size);
            switch (this.direction) {
                case 2: {
                    y = -offsetY + offsetY * alpha;
                    break;
                }
                case 3: {
                    y = offsetY - offsetY * alpha;
                    break;
                }
                case 5: {
                    y = i % 2 == 0 ? -offsetY + offsetY * alpha : offsetY - offsetY * alpha;
                }
            }
            batch.draw(nextScreen, x, y, 0.0f, 0.0f, (float)sliceWidth, h, 1.0f, 1.0f, 0.0f, i * sliceWidth, 0, sliceWidth, nextScreen.getHeight(), false, true);
        }
        batch.end();
    }
}

