/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken._2d.scenes.transition;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.isoterik.racken._2d.scenes.transition.ISceneTransition;

public class Split
implements ISceneTransition {
    private static final Split instance = new Split();
    private float duration;
    private int direction;
    private boolean slideOut;
    private Interpolation easing;

    public static Split init(float duration, int direction, boolean slideOut, Interpolation easing) {
        Split.instance.duration = duration;
        Split.instance.direction = direction;
        Split.instance.slideOut = slideOut;
        Split.instance.easing = easing;
        return instance;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public void render(SpriteBatch batch, Texture currScreen, Texture nextScreen, float alpha) {
        float w = currScreen.getWidth();
        float h = currScreen.getHeight();
        float x1 = 0.0f;
        float x2 = 0.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        if (this.easing != null) {
            alpha = this.easing.apply(alpha);
        }
        switch (this.direction) {
            case 4: {
                x1 = -w / 2.0f * alpha;
                x2 = w / 2.0f * alpha + w / 2.0f;
                if (this.slideOut) break;
                x1 = w / 2.0f * alpha + w / 2.0f;
                x2 = -w / 2.0f * alpha;
                break;
            }
            case 5: {
                y1 = -h / 2.0f * alpha;
                y2 = h / 2.0f * alpha + h / 2.0f;
                if (this.slideOut) break;
                y1 = h / 2.0f * alpha + h / 2.0f;
                y2 = -h / 2.0f * alpha;
                break;
            }
            case 6: 
            case 7: {
                x1 = -w / 2.0f * alpha;
                x2 = w / 2.0f * alpha + w / 2.0f;
                if (!this.slideOut) {
                    x1 = w / 2.0f * alpha + w / 2.0f;
                    x2 = -w / 2.0f * alpha;
                }
                y1 = -h / 2.0f * alpha;
                y2 = h / 2.0f * alpha + h / 2.0f;
                if (this.slideOut) break;
                y1 = h / 2.0f * alpha + h / 2.0f;
                y2 = -h / 2.0f * alpha;
            }
        }
        Texture texBottom = this.slideOut ? nextScreen : currScreen;
        Texture texTop = this.slideOut ? currScreen : nextScreen;
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        batch.begin();
        batch.draw(texBottom, 0.0f, 0.0f, 0.0f, 0.0f, w, h, 1.0f, 1.0f, 0.0f, 0, 0, currScreen.getWidth(), currScreen.getHeight(), false, true);
        if (this.direction == 4 || this.direction == 6) {
            batch.draw(texTop, x1, y1, 0.0f, 0.0f, w / 2.0f, h, 1.0f, 1.0f, 0.0f, 0, 0, currScreen.getWidth() / 2, currScreen.getHeight(), false, true);
            batch.draw(texTop, x2, y2, 0.0f, 0.0f, w / 2.0f, h, 1.0f, 1.0f, 0.0f, (int)w / 2, 0, currScreen.getWidth() / 2, currScreen.getHeight(), false, true);
        } else {
            batch.draw(texTop, x1, y1, 0.0f, 0.0f, w, h / 2.0f, 1.0f, 1.0f, 0.0f, 0, 0, currScreen.getWidth(), currScreen.getHeight() / 2, false, true);
            batch.draw(texTop, x2, y2, 0.0f, 0.0f, w, h / 2.0f, 1.0f, 1.0f, 0.0f, 0, (int)h / 2, currScreen.getWidth(), currScreen.getHeight() / 2, false, true);
        }
        batch.end();
    }
}

