/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken.actor;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.MoveToAction;
import com.badlogic.gdx.scenes.scene2d.actions.ScaleToAction;
import com.badlogic.gdx.scenes.scene2d.actions.SizeToAction;
import com.isoterik.racken.Racken;
import com.isoterik.racken.Scene;
import com.isoterik.racken.utils.GameWorldUnits;

public final class ActorAnimation {
    private static ActorAnimation instance;
    private float screenWidth;
    private float screenHeight;
    public static final int UP = 2;
    public static final int DOWN = 3;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;

    private ActorAnimation() {
    }

    public static ActorAnimation instance() {
        Scene currentScene;
        if (instance == null) {
            instance = new ActorAnimation();
        }
        if ((currentScene = Racken.instance().sceneManager.getCurrentScene()) != null && currentScene.getGameWorldUnits() != null) {
            GameWorldUnits gameWorldUnits = currentScene.getGameWorldUnits();
            instance.setup(gameWorldUnits.getScreenWidth(), gameWorldUnits.getScreenHeight());
        }
        return instance;
    }

    public void setup(float screenWidth, float screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public void grow(Actor actor, float duration, Interpolation easing) {
        actor.setScale(0.0f, 0.0f);
        ScaleToAction grow = Actions.scaleTo((float)1.0f, (float)1.0f, (float)duration, (Interpolation)easing);
        actor.addAction((Action)grow);
    }

    public void resize(Actor actor, float duration, float fraction, Interpolation easing) {
        float w = actor.getWidth() * fraction;
        float h = actor.getHeight() * fraction;
        SizeToAction grow = Actions.sizeTo((float)w, (float)h, (float)duration, (Interpolation)easing);
        actor.addAction((Action)grow);
    }

    public void shrinkThenRemove(Actor actor, float duration, Interpolation easing) {
        ScaleToAction shrink = Actions.scaleTo((float)0.0f, (float)0.0f, (float)duration, (Interpolation)easing);
        actor.addAction((Action)Actions.sequence((Action)shrink, (Action)Actions.removeActor()));
    }

    public void shrink(Actor actor, float duration, Interpolation easing) {
        ScaleToAction shrink = Actions.scaleTo((float)0.0f, (float)0.0f, (float)duration, (Interpolation)easing);
        actor.addAction((Action)shrink);
    }

    public void slideIn(Actor actor, int direction, float duration, Interpolation easing) {
        float w = actor.getWidth();
        float h = actor.getHeight();
        float maxW = this.screenWidth;
        float maxH = this.screenHeight;
        float x = actor.getX();
        float y = actor.getY();
        float toX = x;
        float toY = y;
        switch (direction) {
            case 3: {
                y = maxH;
                break;
            }
            case 2: {
                y = -h;
                break;
            }
            case 0: {
                x = -w;
                break;
            }
            case 1: {
                x = maxW;
            }
        }
        actor.setPosition(x, y);
        MoveToAction slide = Actions.moveTo((float)toX, (float)toY, (float)duration, (Interpolation)easing);
        actor.addAction((Action)slide);
    }

    public void slideIn(Actor actor, int direction, float duration) {
        this.slideIn(actor, direction, duration, (Interpolation)Interpolation.swing);
    }

    public void slideOutThenRemove(Actor actor, int direction, float duration, Interpolation easing) {
        float w = actor.getWidth();
        float h = actor.getHeight();
        float maxW = this.screenWidth;
        float maxH = this.screenHeight;
        float x = actor.getX();
        float y = actor.getY();
        float toX = x;
        float toY = y;
        switch (direction) {
            case 2: {
                toY = maxH;
                break;
            }
            case 3: {
                toY = -h;
                break;
            }
            case 0: {
                toX = -w;
                break;
            }
            case 1: {
                toX = maxW;
            }
        }
        MoveToAction slide = Actions.moveTo((float)toX, (float)toY, (float)duration, (Interpolation)easing);
        actor.addAction((Action)Actions.sequence((Action)slide, (Action)Actions.removeActor()));
    }

    public void slideOutThenRemove(Actor actor, int direction, float duration) {
        this.slideOutThenRemove(actor, direction, duration, (Interpolation)Interpolation.pow5);
    }

    public void slideOut(Actor actor, int direction, float duration, Interpolation easing) {
        float w = actor.getWidth();
        float h = actor.getHeight();
        float maxW = this.screenWidth;
        float maxH = this.screenHeight;
        float x = actor.getX();
        float y = actor.getY();
        float toX = x;
        float toY = y;
        switch (direction) {
            case 2: {
                toY = maxH;
                break;
            }
            case 3: {
                toY = -h;
                break;
            }
            case 0: {
                toX = -w;
                break;
            }
            case 1: {
                toX = maxW;
            }
        }
        MoveToAction slide = Actions.moveTo((float)toX, (float)toY, (float)duration, (Interpolation)easing);
        actor.addAction((Action)slide);
    }

    public void slideOut(Actor actor, int direction, float duration) {
        this.slideOut(actor, direction, duration, (Interpolation)Interpolation.pow5);
    }
}

