/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken.actor;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.isoterik.racken.Component;
import com.isoterik.racken.Transform;
import com.isoterik.racken.utils.GameWorldUnits;

public class ActorGameObjectMapper
extends Component {
    protected Actor actor;
    protected GameWorldUnits unitConverter;
    protected MappingType mappingType = MappingType.MAP_FROM_ACTOR;

    public ActorGameObjectMapper(Actor actor, GameWorldUnits unitConverter) {
        this.actor = actor;
        this.unitConverter = unitConverter;
    }

    public ActorGameObjectMapper(Actor actor) {
        this(actor, null);
    }

    public ActorGameObjectMapper(GameWorldUnits unitConverter) {
        this(new Actor(), unitConverter);
    }

    public ActorGameObjectMapper() {
        this(new Actor());
    }

    protected GameWorldUnits resolveUnitConverter() {
        if (this.unitConverter == null) {
            if (this.scene != null) {
                return this.scene.getGameWorldUnits();
            }
            return null;
        }
        return this.unitConverter;
    }

    public Actor getActor() {
        return this.actor;
    }

    public void setActor(Actor actor) {
        this.actor = actor;
    }

    public GameWorldUnits getUnitConverter() {
        return this.unitConverter;
    }

    public void setUnitConverter(GameWorldUnits unitConverter) {
        this.unitConverter = unitConverter;
    }

    public MappingType getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(MappingType mappingType) {
        this.mappingType = mappingType;
    }

    protected void map(float deltaTime) {
        GameWorldUnits converter = this.resolveUnitConverter();
        if (converter != null && this.actor != null) {
            if (this.actor.getStage() == null) {
                this.actor.act(deltaTime);
            }
            Transform transform = this.gameObject.transform;
            if (this.mappingType == MappingType.MAP_FROM_ACTOR) {
                transform.setX(converter.toWorldUnit(this.actor.getX()));
                transform.setY(converter.toWorldUnit(this.actor.getY()));
                transform.setWidth(converter.toWorldUnit(this.actor.getWidth()));
                transform.setHeight(converter.toWorldUnit(this.actor.getHeight()));
                transform.setScale(this.actor.getScaleX(), this.actor.getScaleY());
                transform.setOrigin(converter.toWorldUnit(this.actor.getOriginX()), converter.toWorldUnit(this.actor.getOriginY()));
                transform.setRotation(this.actor.getRotation());
            } else {
                this.actor.setX(converter.toPixels(transform.getX()));
                this.actor.setY(converter.toPixels(transform.getY()));
                this.actor.setWidth(converter.toPixels(transform.getWidth()));
                this.actor.setHeight(converter.toPixels(transform.getHeight()));
                this.actor.setScale(transform.getScaleX(), transform.getScaleY());
                this.actor.setOrigin(converter.toPixels(transform.getOriginX()), converter.toPixels(transform.getOriginY()));
                this.actor.setRotation(transform.getRotation());
            }
        }
    }

    @Override
    public void postUpdate(float deltaTime) {
        this.map(deltaTime);
    }

    public static enum MappingType {
        MAP_FROM_GAME_OBJECT,
        MAP_FROM_ACTOR;

    }
}

