/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken.asset;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetErrorListener;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;

public class GameAssetsLoader {
    protected AssetManager assetManager = new AssetManager();
    protected boolean loadAssetsInBackground;
    protected Runnable onLoadAssets;
    private static GameAssetsLoader instance;

    public static void __init() {
        instance = new GameAssetsLoader();
    }

    public static GameAssetsLoader instance() {
        return instance;
    }

    private GameAssetsLoader() {
        this.setLoader((Class)TiledMap.class, (AssetLoader)new TmxMapLoader((FileHandleResolver)new InternalFileHandleResolver()));
    }

    public <T, P extends AssetLoaderParameters<T>> void setLoader(Class<T> assetClass, AssetLoader<T, P> loader) {
        this.assetManager.setLoader(assetClass, loader);
    }

    public <T> AssetLoader getLoader(Class<T> assetClass) {
        return this.assetManager.getLoader(assetClass);
    }

    public <T> AssetLoader getLoader(Class<T> assetClass, String filePath) {
        return this.assetManager.getLoader(assetClass, filePath);
    }

    public void setReferenceCount(String filePath, int refCount) {
        this.assetManager.setReferenceCount(filePath, refCount);
    }

    public int getReferenceCount(String filePath) {
        return this.assetManager.getReferenceCount(filePath);
    }

    public void setErrorListener(AssetErrorListener listener) {
        this.assetManager.setErrorListener(listener);
    }

    public int getLoadedAssetsCount() {
        return this.assetManager.getLoadedAssets();
    }

    public void loadAssetsInBackground(Runnable onLoadAssets) {
        this.loadAssetsInBackground = true;
        this.onLoadAssets = onLoadAssets;
    }

    public void update() {
        if (this.tickLoader() && this.loadAssetsInBackground) {
            if (this.onLoadAssets != null) {
                this.onLoadAssets.run();
            }
            this.loadAssetsInBackground = false;
        }
    }

    public void enqueueTexture(String filePath) {
        this.enqueueAsset(filePath, Texture.class);
    }

    public void enqueueSfxFolder(String folderPath) {
        for (FileHandle file : Gdx.files.internal(folderPath).list()) {
            Class<Sound> c = Sound.class;
            if (file.extension().equals("mp3")) {
                c = Music.class;
            }
            this.assetManager.load(file.path(), c);
        }
    }

    public <T> void enqueueFolderContents(String folderPath, Class<T> assetClass) {
        FileHandle dir = Gdx.files.internal(folderPath);
        if (!dir.isDirectory()) {
            this.assetManager.load(dir.path(), assetClass);
        } else {
            for (FileHandle file : dir.list()) {
                this.enqueueFolderContents(file.path(), assetClass);
            }
        }
    }

    public <T> void enqueueAsset(String path, Class<T> assetClass) {
        this.assetManager.load(path, assetClass);
    }

    public void enqueueSkin(String jsonPath) {
        this.enqueueAsset(jsonPath, Skin.class);
    }

    public void enqueueAtlas(String path) {
        this.enqueueAsset(path, TextureAtlas.class);
    }

    public boolean tickLoader() {
        return this.assetManager.update();
    }

    public float getProgressPercentage() {
        float t = this.assetManager.getProgress();
        return t * 100.0f;
    }

    public void loadAssetsNow() {
        this.assetManager.finishLoading();
    }

    public void loadAssetNow(String assetName) {
        this.assetManager.finishLoadingAsset(assetName);
    }

    public boolean isFinishedLoading() {
        return this.assetManager.isFinished();
    }

    public boolean isLoaded(String filePath) {
        return this.assetManager.isLoaded(filePath);
    }

    public boolean isLoaded(String filePath, Class assetClass) {
        return this.assetManager.isLoaded(filePath, assetClass);
    }

    public boolean contains(String filePath) {
        return this.assetManager.contains(filePath);
    }

    public boolean contains(String filePath, Class assetClass) {
        return this.assetManager.contains(filePath, assetClass);
    }

    public Texture getTexture(String name, boolean applyLinearFilter) {
        Texture texture = (Texture)this.assetManager.get(name, Texture.class);
        if (texture == null) {
            return null;
        }
        if (applyLinearFilter) {
            texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        } else {
            texture.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        }
        return texture;
    }

    public Texture getTexture(String name) {
        return this.getTexture(name, true);
    }

    public TextureRegion getRegion(String name) {
        return (TextureRegion)this.assetManager.get(name, TextureRegion.class);
    }

    public TextureAtlas getAtlas(String name) {
        return (TextureAtlas)this.assetManager.get(name, TextureAtlas.class);
    }

    public TextureRegion regionForTexture(String name, boolean applyLinearFilter) {
        return new TextureRegion(this.getTexture(name, applyLinearFilter));
    }

    public TextureRegion regionForTexture(String name) {
        return this.regionForTexture(name, true);
    }

    public Drawable drawableForTexture(String name, boolean applyLinearFilter) {
        return new TextureRegionDrawable(this.regionForTexture(name, applyLinearFilter));
    }

    public Drawable drawableForTexture(String name) {
        return this.drawableForTexture(name, true);
    }

    public Drawable patchDrawableForRegion(String regionName, String atlasName) {
        return new NinePatchDrawable(this.getAtlas(atlasName).createPatch(regionName));
    }

    public BitmapFont getFont(String name) {
        return (BitmapFont)this.assetManager.get(name, BitmapFont.class);
    }

    public <T> T getAsset(String path, Class<T> assetClass) {
        return (T)this.assetManager.get(path, assetClass);
    }

    public Skin getSkin(String jsonPath) {
        return this.getAsset(jsonPath, Skin.class);
    }

    public Music getMusic(String filePath) {
        return this.getAsset(filePath, Music.class);
    }

    public Sound getSound(String filePath) {
        return this.getAsset(filePath, Sound.class);
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public void __dispose() {
        this.assetManager.dispose();
    }
}

