/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken.input;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Pool;

public class GestureEventData
implements Pool.Poolable {
    public GestureEvent gestureEvent;
    public float x;
    public float y;
    public float flingVelocityX;
    public float flingVelocityY;
    public float panDeltaX;
    public float panDeltaY;
    public float initialZoomDistance;
    public float zoomDistance;
    public float zoomFactor;
    public boolean zoomedIn;
    public int pointer = -1;
    public int button = -10;
    public int tapCount;
    public Vector2 initialPinchPointer1;
    public Vector2 initialPinchPointer2;
    public Vector2 pinchPointer1;
    public Vector2 pinchPointer2;

    public GestureEventData(GestureEvent gestureEvent) {
        this.gestureEvent = gestureEvent;
    }

    public GestureEventData() {
    }

    public void reset() {
        this.gestureEvent = null;
        this.y = 0.0f;
        this.x = 0.0f;
        this.flingVelocityY = 0.0f;
        this.flingVelocityX = 0.0f;
        this.panDeltaY = 0.0f;
        this.panDeltaX = 0.0f;
        this.zoomDistance = 0.0f;
        this.initialZoomDistance = 0.0f;
        this.zoomFactor = 0.0f;
        this.zoomedIn = false;
        this.pointer = -1;
        this.button = -10;
        this.tapCount = 0;
        this.initialPinchPointer1 = null;
        this.initialPinchPointer2 = null;
        this.pinchPointer1 = null;
        this.pinchPointer2 = null;
    }

    public boolean sameEvent(GestureEvent secondEvent) {
        return this.gestureEvent == secondEvent;
    }

    public boolean sameEvent(GestureEventData secondData) {
        return this.sameEvent(secondData.gestureEvent);
    }

    public static GestureEventData flingEvent() {
        return new GestureEventData(GestureEvent.FLING);
    }

    public static GestureEventData longPressEvent() {
        return new GestureEventData(GestureEvent.LONG_PRESS);
    }

    public static GestureEventData panEvent() {
        return new GestureEventData(GestureEvent.PAN);
    }

    public static GestureEventData panStopEvent() {
        return new GestureEventData(GestureEvent.PAN_STOP);
    }

    public static GestureEventData pinchEvent() {
        return new GestureEventData(GestureEvent.PINCH);
    }

    public static GestureEventData pinchStopEvent() {
        return new GestureEventData(GestureEvent.PINCH_STOP);
    }

    public static GestureEventData tapEvent() {
        return new GestureEventData(GestureEvent.TAP);
    }

    public static GestureEventData doubleTapEvent() {
        return new GestureEventData(GestureEvent.DOUBLE_TAP);
    }

    public static GestureEventData zoomEvent() {
        return new GestureEventData(GestureEvent.ZOOM);
    }

    public static class DataPool
    extends Pool<GestureEventData> {
        protected GestureEventData newObject() {
            return new GestureEventData();
        }
    }

    public static enum GestureEvent {
        FLING,
        LONG_PRESS,
        PAN,
        PAN_STOP,
        PINCH,
        PINCH_STOP,
        TAP,
        DOUBLE_TAP,
        ZOOM;

    }
}

