/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.isoterik.racken.GameCamera;
import com.isoterik.racken.Scene;
import com.isoterik.racken.input.GestureEventData;
import com.isoterik.racken.input.GestureTrigger;
import com.isoterik.racken.input.IGestureListener;
import com.isoterik.racken.input.IKeyListener;
import com.isoterik.racken.input.ITouchListener;
import com.isoterik.racken.input.ITrigger;
import com.isoterik.racken.input.InputListener;
import com.isoterik.racken.input.KeyEventData;
import com.isoterik.racken.input.KeyTrigger;
import com.isoterik.racken.input.TouchEventData;
import com.isoterik.racken.input.TouchTrigger;

public class InputManager
extends InputAdapter
implements GestureDetector.GestureListener {
    private final Scene hostScene;
    private final ArrayMap<String, Array<ITrigger>> mappings;
    private final ArrayMap<String, Array<ITouchListener>> mappedTouchListeners;
    private final ArrayMap<String, Array<IKeyListener>> mappedKeyListeners;
    private final ArrayMap<String, Array<IGestureListener>> mappedGestureListeners;
    private final ArrayMap<TouchTrigger, ITouchListener> touchListeners;
    private final ArrayMap<KeyTrigger, IKeyListener> keyListeners;
    private final ArrayMap<GestureTrigger, IGestureListener> gestureListeners;
    private static TouchEventData.DataPool touchDataPool;
    private static KeyEventData.DataPool keyDataPool;
    private static GestureEventData.DataPool gestureDataPool;
    private final InputMultiplexer inputMultiplexer;
    private final GestureDetector gestureDetector;
    private final Vector2 tempVector = new Vector2();
    private final Vector3 tempVector3 = new Vector3();
    private GameCamera projectionCamera;
    private static final int[] MOUSE_BUTTONS;

    public InputManager(Scene hostScene) {
        this.hostScene = hostScene;
        this.mappings = new ArrayMap();
        this.mappedTouchListeners = new ArrayMap();
        this.mappedKeyListeners = new ArrayMap();
        this.mappedGestureListeners = new ArrayMap();
        this.touchListeners = new ArrayMap();
        this.keyListeners = new ArrayMap();
        this.gestureListeners = new ArrayMap();
        this.inputMultiplexer = new InputMultiplexer();
        this.gestureDetector = new GestureDetector((GestureDetector.GestureListener)this);
        this.inputMultiplexer.addProcessor((InputProcessor)this);
        this.inputMultiplexer.addProcessor((InputProcessor)this.gestureDetector);
    }

    public Scene getHostScene() {
        return this.hostScene;
    }

    public InputMultiplexer getInputMultiplexer() {
        return this.inputMultiplexer;
    }

    public void addProcessor(InputProcessor inputProcessor) {
        this.inputMultiplexer.addProcessor(inputProcessor);
    }

    public GameCamera getProjectionCamera() {
        return this.projectionCamera;
    }

    public void setProjectionCamera(GameCamera projectionCamera) {
        this.projectionCamera = projectionCamera;
    }

    public GestureDetector getGestureDetector() {
        return this.gestureDetector;
    }

    public boolean addMapping(String mappingName, ITrigger ... triggers) throws IllegalArgumentException {
        if (this.hasMapping(mappingName)) {
            return false;
        }
        if (triggers.length == 0) {
            throw new IllegalArgumentException("A mapping must have at least one trigger");
        }
        Array items = new Array((Object[])triggers);
        this.mappings.put((Object)mappingName, (Object)items);
        return true;
    }

    public boolean updateMapping(String mappingName, ITrigger trigger, ITrigger ... triggers) {
        if (!this.hasMapping(mappingName)) {
            return false;
        }
        Array<ITrigger> mappedTriggers = this.getMapping(mappingName);
        mappedTriggers.add((Object)trigger);
        mappedTriggers.addAll(Array.with((Object[])triggers));
        return true;
    }

    public Array<ITrigger> getMapping(String mappingName) {
        if (!this.hasMapping(mappingName)) {
            return null;
        }
        return (Array)this.mappings.get((Object)mappingName);
    }

    public boolean hasMapping(String mappingName) {
        return this.mappings.containsKey((Object)mappingName);
    }

    public boolean removedMappedTriggers(String mappingName) {
        if (!this.hasMapping(mappingName)) {
            return false;
        }
        this.getMapping(mappingName).clear();
        this.clearMappedListeners(mappingName);
        return true;
    }

    public void removeAllMappedTriggers() {
        ArrayMap.Keys keys = this.mappings.keys();
        for (String key : keys) {
            this.getMapping(key).clear();
        }
    }

    public void clearMappedListeners(String mappingName) {
        this.clearMappedTouchListeners(mappingName);
        this.clearMappedKeyListeners(mappingName);
        this.clearMappedGestureListeners(mappingName);
    }

    private void clearMappedTouchListeners(String mappingName) {
        if (!this.mappedTouchListeners.containsKey((Object)mappingName)) {
            return;
        }
        ((Array)this.mappedTouchListeners.get((Object)mappingName)).clear();
    }

    private void clearMappedKeyListeners(String mappingName) {
        if (!this.mappedKeyListeners.containsKey((Object)mappingName)) {
            return;
        }
        ((Array)this.mappedKeyListeners.get((Object)mappingName)).clear();
    }

    private void clearMappedGestureListeners(String mappingName) {
        if (!this.mappedGestureListeners.containsKey((Object)mappingName)) {
            return;
        }
        ((Array)this.mappedGestureListeners.get((Object)mappingName)).clear();
    }

    private void removeMappedTouchListeners(String mappingName) {
        if (!this.mappedTouchListeners.containsKey((Object)mappingName)) {
            return;
        }
        this.mappedTouchListeners.removeKey((Object)mappingName);
    }

    private void removeMappedTouchListener(String mappingName, ITouchListener touchListener) {
        if (!this.mappedTouchListeners.containsKey((Object)mappingName)) {
            return;
        }
        Array listeners = (Array)this.mappedTouchListeners.get((Object)mappingName);
        listeners.removeValue((Object)touchListener, true);
    }

    private void removeMappedKeyListeners(String mappingName) {
        if (!this.mappedKeyListeners.containsKey((Object)mappingName)) {
            return;
        }
        this.mappedKeyListeners.removeKey((Object)mappingName);
    }

    private void removeMappedKeyListener(String mappingName, IKeyListener keyListener) {
        if (!this.mappedKeyListeners.containsKey((Object)mappingName)) {
            return;
        }
        Array listeners = (Array)this.mappedKeyListeners.get((Object)mappingName);
        listeners.removeValue((Object)keyListener, true);
    }

    private void removeMappedGestureListeners(String mappingName) {
        if (!this.mappedGestureListeners.containsKey((Object)mappingName)) {
            return;
        }
        this.mappedGestureListeners.removeKey((Object)mappingName);
    }

    private void removeMappedGestureListener(String mappingName, IGestureListener gestureListener) {
        if (!this.mappedGestureListeners.containsKey((Object)mappingName)) {
            return;
        }
        Array listeners = (Array)this.mappedGestureListeners.get((Object)mappingName);
        listeners.removeValue((Object)gestureListener, true);
    }

    public void removeMappedListener(String mappingName, InputListener listener) {
        if (listener instanceof ITouchListener) {
            this.removeMappedTouchListener(mappingName, (ITouchListener)listener);
        } else if (listener instanceof IKeyListener) {
            this.removeMappedKeyListener(mappingName, (IKeyListener)listener);
        } else if (listener instanceof IGestureListener) {
            this.removeMappedGestureListener(mappingName, (IGestureListener)listener);
        }
    }

    public void removeMappedListeners(String mappingName) {
        this.removeMappedTouchListeners(mappingName);
        this.removeMappedKeyListeners(mappingName);
        this.removeMappedGestureListeners(mappingName);
    }

    public void removeAllMappedTouchListeners() {
        this.mappedTouchListeners.clear();
    }

    public void removeAllMappedKeyListeners() {
        this.mappedKeyListeners.clear();
    }

    public void removeAllMappedGestureListeners() {
        this.mappedGestureListeners.clear();
    }

    public void removeAllMappedListeners() {
        this.removeAllMappedTouchListeners();
        this.removeAllMappedKeyListeners();
        this.removeAllMappedGestureListeners();
    }

    public void removeMapping(String mappingName) {
        if (!this.hasMapping(mappingName)) {
            return;
        }
        this.mappings.removeKey((Object)mappingName);
    }

    public void removeAllMappings() {
        this.mappings.clear();
    }

    public void deactivateMappedTriggers(String mappingName) {
        this.changeTriggersState(mappingName, false);
    }

    public <T extends ITrigger> void deactivateMappedTriggers(String mappingName, Class<T> triggerClass) {
        this.changeTriggersState(mappingName, false, triggerClass);
    }

    public void activateMappedTriggers(String mappingName) {
        this.changeTriggersState(mappingName, true);
    }

    public <T extends ITrigger> void activateMappedTriggers(String mappingName, Class<T> triggerClass) {
        this.changeTriggersState(mappingName, true, triggerClass);
    }

    public void deactivateAllMappedTriggers() {
        ArrayMap.Keys keys = this.mappings.keys();
        for (String key : keys) {
            this.deactivateMappedTriggers(key);
        }
    }

    public <T extends ITrigger> void deactivateAllMappedTriggers(Class<T> triggerClass) {
        ArrayMap.Keys keys = this.mappings.keys();
        for (String key : keys) {
            this.deactivateMappedTriggers(key, triggerClass);
        }
    }

    public void activateAllMappedTriggers() {
        ArrayMap.Keys keys = this.mappings.keys();
        for (String key : keys) {
            this.activateMappedTriggers(key);
        }
    }

    public <T extends ITrigger> void activateAllMappedTriggers(Class<T> triggerClass) {
        ArrayMap.Keys keys = this.mappings.keys();
        for (String key : keys) {
            this.activateMappedTriggers(key, triggerClass);
        }
    }

    private void changeTriggersState(String mappingName, boolean active) {
        if (!this.hasMapping(mappingName)) {
            return;
        }
        Array<ITrigger> triggers = this.getMapping(mappingName);
        for (ITrigger trigger : triggers) {
            trigger.setActive(active);
        }
    }

    private <T extends ITrigger> void changeTriggersState(String mappingName, boolean active, Class<T> triggerClass) {
        if (!this.hasMapping(mappingName)) {
            return;
        }
        Array<ITrigger> triggers = this.getMapping(mappingName);
        for (ITrigger trigger : triggers) {
            if (trigger.getClass() != triggerClass) continue;
            trigger.setActive(active);
        }
    }

    public void mapTouchListener(String mappingName, ITouchListener listener) {
        Array listeners = this.mappedTouchListeners.containsKey((Object)mappingName) ? (Array)this.mappedTouchListeners.get((Object)mappingName) : new Array();
        listeners.add((Object)listener);
        if (!this.mappedTouchListeners.containsKey((Object)mappingName)) {
            this.mappedTouchListeners.put((Object)mappingName, (Object)listeners);
        }
    }

    public void mapKeyListener(String mappingName, IKeyListener listener) {
        Array listeners = this.mappedKeyListeners.containsKey((Object)mappingName) ? (Array)this.mappedKeyListeners.get((Object)mappingName) : new Array();
        listeners.add((Object)listener);
        if (!this.mappedKeyListeners.containsKey((Object)mappingName)) {
            this.mappedKeyListeners.put((Object)mappingName, (Object)listeners);
        }
    }

    public void mapGestureListener(String mappingName, IGestureListener listener) {
        Array listeners = this.mappedGestureListeners.containsKey((Object)mappingName) ? (Array)this.mappedGestureListeners.get((Object)mappingName) : new Array();
        listeners.add((Object)listener);
        if (!this.mappedGestureListeners.containsKey((Object)mappingName)) {
            this.mappedGestureListeners.put((Object)mappingName, (Object)listeners);
        }
    }

    public void mapListener(String mappingName, InputListener ... listeners) throws IllegalArgumentException {
        if (listeners.length == 0) {
            throw new IllegalArgumentException("At least one listener must be provided when mapping");
        }
        for (InputListener lst : listeners) {
            if (lst instanceof ITouchListener) {
                this.mapTouchListener(mappingName, (ITouchListener)lst);
            }
            if (lst instanceof IKeyListener) {
                this.mapKeyListener(mappingName, (IKeyListener)lst);
            }
            if (!(lst instanceof IGestureListener)) continue;
            this.mapGestureListener(mappingName, (IGestureListener)lst);
        }
    }

    public ArrayMap<String, Array<IKeyListener>> getMappedKeyListeners() {
        return this.mappedKeyListeners;
    }

    public Array<IKeyListener> getMappedKeyListeners(String mappingName) {
        if (!this.mappedKeyListeners.containsKey((Object)mappingName)) {
            return null;
        }
        return (Array)this.mappedKeyListeners.get((Object)mappingName);
    }

    public ArrayMap<String, Array<ITouchListener>> getMappedTouchListeners() {
        return this.mappedTouchListeners;
    }

    public Array<ITouchListener> getMappedTouchListeners(String mappingName) {
        if (!this.mappedTouchListeners.containsKey((Object)mappingName)) {
            return null;
        }
        return (Array)this.mappedTouchListeners.get((Object)mappingName);
    }

    public ArrayMap<String, Array<IGestureListener>> getMappedGestureListeners() {
        return this.mappedGestureListeners;
    }

    public Array<IGestureListener> getMappedGestureListeners(String mappingName) {
        if (!this.mappedGestureListeners.containsKey((Object)mappingName)) {
            return null;
        }
        return (Array)this.mappedGestureListeners.get((Object)mappingName);
    }

    public void addListener(ITrigger trigger, InputListener listener) {
        if (trigger instanceof TouchTrigger && listener instanceof ITouchListener) {
            this.addTouchListener((TouchTrigger)trigger, (ITouchListener)listener);
        }
        if (trigger instanceof KeyTrigger && listener instanceof IKeyListener) {
            this.addKeyListener((KeyTrigger)trigger, (IKeyListener)listener);
        }
        if (trigger instanceof GestureTrigger && listener instanceof IGestureListener) {
            this.addGestureListener((GestureTrigger)trigger, (IGestureListener)listener);
        }
    }

    public void addTouchListener(TouchTrigger trigger, ITouchListener listener) {
        if (this.touchListeners.containsKey((Object)trigger)) {
            return;
        }
        this.touchListeners.put((Object)trigger, (Object)listener);
    }

    public void addKeyListener(KeyTrigger trigger, IKeyListener listener) {
        if (this.keyListeners.containsKey((Object)trigger)) {
            return;
        }
        this.keyListeners.put((Object)trigger, (Object)listener);
    }

    public void addGestureListener(GestureTrigger trigger, IGestureListener listener) {
        if (this.gestureListeners.containsKey((Object)trigger)) {
            return;
        }
        this.gestureListeners.put((Object)trigger, (Object)listener);
    }

    public void removeListener(ITrigger trigger) {
        if (trigger instanceof TouchTrigger) {
            this.removeTouchListener((TouchTrigger)trigger);
        }
        if (trigger instanceof KeyTrigger) {
            this.removeKeyListener((KeyTrigger)trigger);
        }
        if (trigger instanceof GestureTrigger) {
            this.removeGestureListener((GestureTrigger)trigger);
        }
    }

    public void removeListener(InputListener listener) {
        if (listener instanceof ITouchListener) {
            this.removeTouchListener((ITouchListener)listener);
        }
        if (listener instanceof IKeyListener) {
            this.removeKeyListener((IKeyListener)listener);
        }
        if (listener instanceof IGestureListener) {
            this.removeGestureListener((IGestureListener)listener);
        }
    }

    private void removeTouchListener(TouchTrigger trigger) {
        if (!this.touchListeners.containsKey((Object)trigger)) {
            return;
        }
        this.touchListeners.removeKey((Object)trigger);
    }

    private void removeTouchListener(ITouchListener touchListener) {
        this.touchListeners.removeValue((Object)touchListener, true);
    }

    public void removeTouchListeners(TouchEventData.TouchEvent touchEvent) {
        ArrayMap.Keys triggers = this.touchListeners.keys();
        for (TouchTrigger trigger : triggers) {
            if (!trigger.touchEventData.sameEvent(touchEvent)) continue;
            this.touchListeners.removeKey((Object)trigger);
        }
    }

    public void removeKeyListeners(KeyEventData.KeyEvent keyEvent) {
        ArrayMap.Keys triggers = this.keyListeners.keys();
        for (KeyTrigger trigger : triggers) {
            if (!trigger.keyEventData.sameEvent(keyEvent)) continue;
            this.keyListeners.removeKey((Object)trigger);
        }
    }

    public void removeGestureListeners(GestureEventData.GestureEvent gestureEvent) {
        ArrayMap.Keys triggers = this.gestureListeners.keys();
        for (GestureTrigger trigger : triggers) {
            if (!trigger.gestureEventData.sameEvent(gestureEvent)) continue;
            this.gestureListeners.removeKey((Object)trigger);
        }
    }

    public void removeAllTouchListeners() {
        this.touchListeners.clear();
    }

    private void removeKeyListener(KeyTrigger trigger) {
        if (!this.keyListeners.containsKey((Object)trigger)) {
            return;
        }
        this.keyListeners.removeKey((Object)trigger);
    }

    private void removeKeyListener(IKeyListener keyListener) {
        this.keyListeners.removeValue((Object)keyListener, true);
    }

    public void removeAllKeyListeners() {
        this.keyListeners.clear();
    }

    private void removeGestureListener(GestureTrigger trigger) {
        if (!this.gestureListeners.containsKey((Object)trigger)) {
            return;
        }
        this.gestureListeners.removeKey((Object)trigger);
    }

    private void removeGestureListener(IGestureListener gestureListener) {
        this.gestureListeners.removeValue((Object)gestureListener, true);
    }

    public void removeAllGestureListeners() {
        this.gestureListeners.clear();
    }

    public void removeAllListeners() {
        this.removeAllTouchListeners();
        this.removeAllKeyListeners();
        this.removeAllGestureListeners();
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        Vector2 coords = this.getWorldCoords(screenX, screenY);
        TouchEventData eventData = InputManager.obtainTouchEventData();
        eventData.touchEvent = TouchEventData.TouchEvent.TOUCH_UP;
        eventData.touchX = coords.x;
        eventData.touchY = coords.y;
        eventData.pointer = pointer;
        eventData.button = button;
        this.invokeTouchListeners(eventData);
        this.invokeMappedTouchListeners(eventData);
        InputManager.recycleEventData(eventData);
        return super.touchUp(screenX, screenY, pointer, button);
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        Vector2 coords = this.getWorldCoords(screenX, screenY);
        TouchEventData eventData = InputManager.obtainTouchEventData();
        eventData.touchEvent = TouchEventData.TouchEvent.TOUCH_DOWN;
        eventData.touchX = coords.x;
        eventData.touchY = coords.y;
        eventData.pointer = pointer;
        eventData.button = button;
        this.invokeTouchListeners(eventData);
        this.invokeMappedTouchListeners(eventData);
        InputManager.recycleEventData(eventData);
        return super.touchDown(screenX, screenY, pointer, button);
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        Vector2 coords = this.getWorldCoords(screenX, screenY);
        TouchEventData eventData = InputManager.obtainTouchEventData();
        eventData.touchEvent = TouchEventData.TouchEvent.TOUCH_DRAGGED;
        eventData.touchX = coords.x;
        eventData.touchY = coords.y;
        eventData.pointer = pointer;
        for (int button : MOUSE_BUTTONS) {
            if (!this.isMouseDown(button)) continue;
            eventData.button = button;
            break;
        }
        this.invokeTouchListeners(eventData);
        this.invokeMappedTouchListeners(eventData);
        InputManager.recycleEventData(eventData);
        return super.touchDragged(screenX, screenY, pointer);
    }

    public boolean keyUp(int keyCode) {
        KeyEventData eventData = InputManager.obtainKeyEventData();
        eventData.keyEvent = KeyEventData.KeyEvent.KEY_UP;
        eventData.keyCode = keyCode;
        this.invokeKeyListeners(eventData);
        this.invokeMappedKeyListeners(eventData);
        InputManager.recycleEventData(eventData);
        return super.keyUp(keyCode);
    }

    public boolean keyDown(int keyCode) {
        KeyEventData eventData = InputManager.obtainKeyEventData();
        eventData.keyEvent = KeyEventData.KeyEvent.KEY_DOWN;
        eventData.keyCode = keyCode;
        this.invokeKeyListeners(eventData);
        this.invokeMappedKeyListeners(eventData);
        InputManager.recycleEventData(eventData);
        return super.keyDown(keyCode);
    }

    public boolean keyTyped(char keyChar) {
        KeyEventData eventData = InputManager.obtainKeyEventData();
        eventData.keyEvent = KeyEventData.KeyEvent.KEY_TYPED;
        eventData.keyChar = keyChar;
        this.invokeKeyListeners(eventData);
        this.invokeMappedKeyListeners(eventData);
        InputManager.recycleEventData(eventData);
        return super.keyTyped(keyChar);
    }

    public boolean tap(float x, float y, int count, int button) {
        Vector2 coords = this.getWorldCoords(x, y);
        GestureEventData eventData = InputManager.obtainGestureEventData();
        eventData.gestureEvent = GestureEventData.GestureEvent.TAP;
        eventData.x = coords.x;
        eventData.y = coords.y;
        eventData.tapCount = count;
        eventData.button = button;
        if (count == 2) {
            eventData.gestureEvent = GestureEventData.GestureEvent.DOUBLE_TAP;
        }
        this.invokeGestureListeners(eventData);
        this.invokeMappedGestureListeners(eventData);
        InputManager.recycleEventData(eventData);
        return false;
    }

    public boolean fling(float velocityX, float velocityY, int button) {
        Vector2 velocity = this.getWorldCoords(velocityX, velocityY);
        GestureEventData eventData = InputManager.obtainGestureEventData();
        eventData.gestureEvent = GestureEventData.GestureEvent.FLING;
        eventData.flingVelocityX = velocity.x;
        eventData.flingVelocityY = velocity.y;
        eventData.button = button;
        this.invokeGestureListeners(eventData);
        this.invokeMappedGestureListeners(eventData);
        InputManager.recycleEventData(eventData);
        return false;
    }

    public boolean longPress(float x, float y) {
        Vector2 coords = this.getWorldCoords(x, y);
        GestureEventData eventData = InputManager.obtainGestureEventData();
        eventData.gestureEvent = GestureEventData.GestureEvent.LONG_PRESS;
        eventData.x = coords.x;
        eventData.y = coords.y;
        this.invokeGestureListeners(eventData);
        this.invokeMappedGestureListeners(eventData);
        InputManager.recycleEventData(eventData);
        return false;
    }

    public boolean pinch(Vector2 initialPointer1, Vector2 initialPointer2, Vector2 pointer1, Vector2 pointer2) {
        GestureEventData eventData = InputManager.obtainGestureEventData();
        eventData.gestureEvent = GestureEventData.GestureEvent.PINCH;
        Vector2 worldPoint = this.getWorldCoords(initialPointer1);
        eventData.initialPinchPointer1 = initialPointer1.set(worldPoint);
        worldPoint = this.getWorldCoords(initialPointer2);
        eventData.initialPinchPointer2 = initialPointer2.set(worldPoint);
        worldPoint = this.getWorldCoords(pointer1);
        eventData.pinchPointer1 = pointer1.set(worldPoint);
        worldPoint = this.getWorldCoords(pointer2);
        eventData.pinchPointer2 = pointer2.set(worldPoint);
        this.invokeGestureListeners(eventData);
        this.invokeMappedGestureListeners(eventData);
        InputManager.recycleEventData(eventData);
        return false;
    }

    public void pinchStop() {
        GestureEventData eventData = InputManager.obtainGestureEventData();
        eventData.gestureEvent = GestureEventData.GestureEvent.PINCH_STOP;
        this.invokeGestureListeners(eventData);
        this.invokeMappedGestureListeners(eventData);
        InputManager.recycleEventData(eventData);
    }

    public boolean pan(float x, float y, float deltaX, float deltaY) {
        Vector2 coords = this.getWorldCoords(x, y);
        GestureEventData eventData = InputManager.obtainGestureEventData();
        eventData.gestureEvent = GestureEventData.GestureEvent.PAN;
        eventData.x = coords.x;
        eventData.y = coords.y;
        coords = this.getWorldCoords(deltaX, deltaY);
        eventData.panDeltaX = coords.x;
        eventData.panDeltaY = coords.y;
        this.invokeGestureListeners(eventData);
        this.invokeMappedGestureListeners(eventData);
        InputManager.recycleEventData(eventData);
        return false;
    }

    public boolean panStop(float x, float y, int pointer, int button) {
        Vector2 coords = this.getWorldCoords(x, y);
        GestureEventData eventData = InputManager.obtainGestureEventData();
        eventData.gestureEvent = GestureEventData.GestureEvent.PAN_STOP;
        eventData.x = coords.x;
        eventData.y = coords.y;
        eventData.pointer = pointer;
        this.invokeGestureListeners(eventData);
        this.invokeMappedGestureListeners(eventData);
        InputManager.recycleEventData(eventData);
        return false;
    }

    public boolean zoom(float initialDistance, float distance) {
        Vector2 worldPoint = this.getWorldCoords(initialDistance, distance);
        initialDistance = worldPoint.x;
        distance = worldPoint.y;
        GestureEventData eventData = InputManager.obtainGestureEventData();
        eventData.gestureEvent = GestureEventData.GestureEvent.ZOOM;
        eventData.initialZoomDistance = initialDistance;
        eventData.zoomDistance = distance;
        eventData.zoomFactor = initialDistance / distance;
        eventData.zoomedIn = distance > initialDistance;
        this.invokeGestureListeners(eventData);
        this.invokeMappedGestureListeners(eventData);
        InputManager.recycleEventData(eventData);
        return false;
    }

    public boolean touchDown(float p1, float p2, int p3, int p4) {
        return false;
    }

    public Vector2 getWorldCoords(float screenX, float screenY) {
        Camera camera;
        if (this.projectionCamera != null) {
            camera = this.projectionCamera.getCamera();
        } else {
            if (this.hostScene.getMainCamera() == null) {
                throw new IllegalStateException("There is no valid camera to use for translation");
            }
            camera = this.hostScene.getMainCamera().getCamera();
        }
        this.tempVector3.set(screenX, screenY, 0.0f);
        Vector3 touch = camera.unproject(this.tempVector3);
        return this.tempVector.set(touch.x, touch.y);
    }

    public Vector2 getWorldCoords(Vector2 screenCoords) {
        return this.getWorldCoords(screenCoords.x, screenCoords.y);
    }

    public void addOnBackPressedListener(IKeyListener listener) {
        this.addListener(KeyTrigger.keyDownTrigger(4), listener);
    }

    private void invokeMappedTouchListeners(TouchEventData eventData) {
        ArrayMap.Keys mappedListenerKeys = this.mappedTouchListeners.keys();
        for (String mappedKey : mappedListenerKeys) {
            if (!this.hasMapping(mappedKey)) continue;
            Array triggers = (Array)this.mappings.get((Object)mappedKey);
            Array listeners = (Array)this.mappedTouchListeners.get((Object)mappedKey);
            for (ITrigger trigger : triggers) {
                if (!trigger.isActive() || trigger.isPolled() || !(trigger instanceof TouchTrigger)) continue;
                TouchTrigger trigg = (TouchTrigger)trigger;
                if (!trigg.touchEventData.sameEvent(eventData)) continue;
                for (ITouchListener listener : listeners) {
                    listener.onTouch(mappedKey, eventData);
                }
            }
        }
    }

    private void invokeMappedKeyListeners(KeyEventData eventData) {
        ArrayMap.Keys mappedListenerKeys = this.mappedKeyListeners.keys();
        for (String mappedKey : mappedListenerKeys) {
            if (!this.hasMapping(mappedKey)) continue;
            Array triggers = (Array)this.mappings.get((Object)mappedKey);
            Array listeners = (Array)this.mappedKeyListeners.get((Object)mappedKey);
            for (ITrigger trigger : triggers) {
                if (!trigger.isActive() || trigger.isPolled() || !(trigger instanceof KeyTrigger)) continue;
                KeyTrigger trigg = (KeyTrigger)trigger;
                if (!trigg.keyEventData.sameEvent(eventData)) continue;
                for (IKeyListener listener : listeners) {
                    listener.onKey(mappedKey, eventData);
                }
            }
        }
    }

    private void invokeMappedGestureListeners(GestureEventData eventData) {
        ArrayMap.Keys mappedListenerKeys = this.mappedGestureListeners.keys();
        for (String mappedKey : mappedListenerKeys) {
            if (!this.hasMapping(mappedKey)) continue;
            Array triggers = (Array)this.mappings.get((Object)mappedKey);
            Array listeners = (Array)this.mappedGestureListeners.get((Object)mappedKey);
            for (ITrigger trigger : triggers) {
                if (!trigger.isActive() || trigger.isPolled() || !(trigger instanceof GestureTrigger)) continue;
                GestureTrigger trigg = (GestureTrigger)trigger;
                if (!trigg.gestureEventData.sameEvent(eventData)) continue;
                for (IGestureListener listener : listeners) {
                    listener.onGesture(mappedKey, eventData);
                }
            }
        }
    }

    private void invokeTouchListeners(TouchEventData eventData) {
        ArrayMap.Keys triggers = this.touchListeners.keys();
        for (TouchTrigger trigger : triggers) {
            if (!trigger.isActive() || trigger.isPolled() || !trigger.touchEventData.sameEvent(eventData)) continue;
            ((ITouchListener)this.touchListeners.get((Object)trigger)).onTouch(null, eventData);
        }
    }

    private void invokeKeyListeners(KeyEventData eventData) {
        ArrayMap.Keys triggers = this.keyListeners.keys();
        for (KeyTrigger trigger : triggers) {
            if (!trigger.isActive() || trigger.isPolled() || !trigger.keyEventData.sameEvent(eventData)) continue;
            ((IKeyListener)this.keyListeners.get((Object)trigger)).onKey(null, eventData);
        }
    }

    private void invokeGestureListeners(GestureEventData eventData) {
        ArrayMap.Keys triggers = this.gestureListeners.keys();
        for (GestureTrigger trigger : triggers) {
            if (!trigger.isActive() || trigger.isPolled() || !trigger.gestureEventData.sameEvent(eventData)) continue;
            ((IGestureListener)this.gestureListeners.get((Object)trigger)).onGesture(null, eventData);
        }
    }

    private void invokeMappedPolledTouchListeners(TouchEventData eventData) {
        ArrayMap.Keys mappedListenerKeys = this.mappedTouchListeners.keys();
        for (String mappedKey : mappedListenerKeys) {
            if (!this.hasMapping(mappedKey)) continue;
            Array triggers = (Array)this.mappings.get((Object)mappedKey);
            Array listeners = (Array)this.mappedTouchListeners.get((Object)mappedKey);
            for (ITrigger trigger : triggers) {
                if (!trigger.isActive() || !trigger.isPolled() || !(trigger instanceof TouchTrigger)) continue;
                TouchTrigger trigg = (TouchTrigger)trigger;
                if (!trigg.touchEventData.sameEvent(eventData)) continue;
                for (ITouchListener listener : listeners) {
                    listener.onTouch(mappedKey, eventData);
                }
            }
        }
    }

    private void invokeMappedPolledKeyListeners() {
        ArrayMap.Keys mappedListenerKeys = this.mappedKeyListeners.keys();
        for (String mappedKey : mappedListenerKeys) {
            if (!this.hasMapping(mappedKey)) continue;
            Array triggers = (Array)this.mappings.get((Object)mappedKey);
            Array listeners = (Array)this.mappedKeyListeners.get((Object)mappedKey);
            for (ITrigger trigger : triggers) {
                if (!trigger.isActive() || !trigger.isPolled() || !(trigger instanceof KeyTrigger)) continue;
                KeyTrigger trigg = (KeyTrigger)trigger;
                if (!this.isKeyDown(trigg.keyEventData.keyCode) || !trigg.keyEventData.sameEvent(KeyEventData.KeyEvent.KEY_DOWN)) continue;
                KeyEventData eventData = InputManager.obtainKeyEventData();
                eventData.keyCode = trigg.keyEventData.keyCode;
                for (IKeyListener listener : listeners) {
                    listener.onKey(mappedKey, eventData);
                }
                InputManager.recycleEventData(eventData);
            }
        }
    }

    private void invokeMappedPolledGestureListeners(GestureEventData eventData) {
        ArrayMap.Keys mappedListenerKeys = this.mappedGestureListeners.keys();
        for (String mappedKey : mappedListenerKeys) {
            if (!this.hasMapping(mappedKey)) continue;
            Array triggers = (Array)this.mappings.get((Object)mappedKey);
            Array listeners = (Array)this.mappedGestureListeners.get((Object)mappedKey);
            for (ITrigger trigger : triggers) {
                if (!trigger.isActive() || !trigger.isPolled() || !(trigger instanceof GestureTrigger)) continue;
                GestureTrigger trigg = (GestureTrigger)trigger;
                if (!trigg.gestureEventData.sameEvent(eventData)) continue;
                for (IGestureListener listener : listeners) {
                    listener.onGesture(mappedKey, eventData);
                }
            }
        }
    }

    private void invokePolledTouchListeners(TouchEventData eventData) {
        ArrayMap.Keys triggers = this.touchListeners.keys();
        for (TouchTrigger trigger : triggers) {
            if (!trigger.isActive() || !trigger.isPolled() || !trigger.touchEventData.sameEvent(eventData)) continue;
            ((ITouchListener)this.touchListeners.get((Object)trigger)).onTouch(null, eventData);
        }
    }

    private void invokePolledKeyListeners() {
        ArrayMap.Keys triggers = this.keyListeners.keys();
        for (KeyTrigger trigger : triggers) {
            if (!trigger.isActive() || !trigger.isPolled() || !this.isKeyDown(trigger.keyEventData.keyCode) || !trigger.keyEventData.sameEvent(KeyEventData.KeyEvent.KEY_DOWN)) continue;
            KeyEventData eventData = InputManager.obtainKeyEventData();
            eventData.keyCode = trigger.keyEventData.keyCode;
            ((IKeyListener)this.keyListeners.get((Object)trigger)).onKey(null, eventData);
            InputManager.recycleEventData(eventData);
        }
    }

    private void invokePolledGestureListeners(GestureEventData eventData) {
        ArrayMap.Keys triggers = this.gestureListeners.keys();
        for (GestureTrigger trigger : triggers) {
            if (!trigger.isActive() || !trigger.isPolled() || !trigger.gestureEventData.sameEvent(eventData)) continue;
            ((IGestureListener)this.gestureListeners.get((Object)trigger)).onGesture(null, eventData);
        }
    }

    public void __update() {
        int maxPointers = Gdx.input.getMaxPointers();
        for (int i = 0; i < maxPointers; ++i) {
            if (!this.isTouched(i)) continue;
            TouchEventData eventData = InputManager.obtainTouchEventData();
            eventData.touchEvent = TouchEventData.TouchEvent.TOUCH_DOWN;
            eventData.touchX = this.getTouchedX(i);
            eventData.touchY = this.getTouchedY(i);
            eventData.pointer = i;
            int[] nArray = MOUSE_BUTTONS;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int button = nArray[j];
                if (!this.isMouseDown(button)) continue;
                eventData.button = button;
                break;
            }
            this.invokePolledTouchListeners(eventData);
            this.invokeMappedPolledTouchListeners(eventData);
            InputManager.recycleEventData(eventData);
        }
        if (this.isLongPressed()) {
            GestureEventData eventData = InputManager.obtainGestureEventData();
            eventData.gestureEvent = GestureEventData.GestureEvent.LONG_PRESS;
            eventData.x = this.getTouchedX();
            eventData.y = this.getTouchedY();
            for (int button : MOUSE_BUTTONS) {
                if (!this.isMouseDown(button)) continue;
                eventData.button = button;
                break;
            }
            this.invokePolledGestureListeners(eventData);
            this.invokeMappedPolledGestureListeners(eventData);
            InputManager.recycleEventData(eventData);
        }
        if (this.isPanning()) {
            GestureEventData eventData = InputManager.obtainGestureEventData();
            eventData.gestureEvent = GestureEventData.GestureEvent.PAN;
            eventData.x = this.getTouchedX();
            eventData.y = this.getTouchedY();
            eventData.panDeltaX = this.getPanDeltaX();
            eventData.panDeltaY = this.getPanDeltaY();
            for (int button : MOUSE_BUTTONS) {
                if (!this.isMouseDown(button)) continue;
                eventData.button = button;
                break;
            }
            this.invokePolledGestureListeners(eventData);
            this.invokeMappedPolledGestureListeners(eventData);
            InputManager.recycleEventData(eventData);
        }
        this.invokePolledKeyListeners();
        this.invokeMappedPolledKeyListeners();
    }

    public boolean isMouseDown(int button) {
        return Gdx.input.isButtonPressed(button);
    }

    public boolean isMouseJustPressed(int button) {
        return Gdx.input.isButtonJustPressed(button);
    }

    public boolean isTouched(int pointer) {
        return Gdx.input.isTouched(pointer);
    }

    public boolean isTouched() {
        return Gdx.input.isTouched();
    }

    public boolean isKeyDown(int keyCode) {
        return Gdx.input.isKeyPressed(keyCode);
    }

    public boolean isKeyJustPressed(int keyCode) {
        return Gdx.input.isKeyJustPressed(keyCode);
    }

    public boolean isLongPressed(float maxTime) {
        return this.gestureDetector.isLongPressed(maxTime);
    }

    public boolean isLongPressed() {
        return this.gestureDetector.isLongPressed();
    }

    public boolean isPanning() {
        return this.gestureDetector.isPanning();
    }

    public float getTouchedX(int pointer) {
        return this.getWorldCoords((float)((float)Gdx.input.getX((int)pointer)), (float)0.0f).x;
    }

    public float getTouchedX() {
        return this.getTouchedX(0);
    }

    public float getTouchedY(int pointer) {
        return this.getWorldCoords((float)0.0f, (float)((float)Gdx.input.getY((int)pointer))).y;
    }

    public float getTouchedY() {
        return this.getTouchedY(0);
    }

    public float getPanDeltaX(int pointer) {
        return this.getWorldCoords((float)((float)Gdx.input.getDeltaX((int)pointer)), (float)0.0f).x;
    }

    public float getPanDeltaX() {
        return this.getWorldCoords((float)((float)Gdx.input.getDeltaX()), (float)0.0f).x;
    }

    public float getPanDeltaY(int pointer) {
        return this.getWorldCoords((float)0.0f, (float)((float)Gdx.input.getDeltaY((int)pointer))).y;
    }

    public float getPanDeltaY() {
        return this.getWorldCoords((float)0.0f, (float)((float)Gdx.input.getDeltaY())).y;
    }

    public float getAccelerationX() {
        return Gdx.input.getAccelerometerX() / 10.0f;
    }

    public float getAccelerationY() {
        return Gdx.input.getAccelerometerY() / 10.0f;
    }

    public float getAccelerationZ() {
        return Gdx.input.getAccelerometerZ() / 10.0f;
    }

    public void setCatchBackKey(boolean catchBackKey) {
        Gdx.input.setCatchKey(4, catchBackKey);
    }

    public void setCursorCatched(boolean cursorCatched) {
        Gdx.input.setCursorCatched(cursorCatched);
    }

    public void setCursorPosition(int x, int y) {
        Gdx.input.setCursorPosition(x, y);
    }

    public static void __initPools() {
        touchDataPool = new TouchEventData.DataPool();
        keyDataPool = new KeyEventData.DataPool();
        gestureDataPool = new GestureEventData.DataPool();
    }

    private static TouchEventData obtainTouchEventData() {
        if (touchDataPool == null) {
            throw new IllegalStateException("The Event Data Pools are not initialized yet!");
        }
        return (TouchEventData)touchDataPool.obtain();
    }

    private static KeyEventData obtainKeyEventData() {
        if (keyDataPool == null) {
            throw new IllegalStateException("The Event Data Pools are not initialized yet!");
        }
        return (KeyEventData)keyDataPool.obtain();
    }

    private static GestureEventData obtainGestureEventData() {
        if (gestureDataPool == null) {
            throw new IllegalStateException("The Event Data Pools are not initialized yet!");
        }
        return (GestureEventData)gestureDataPool.obtain();
    }

    private static void recycleEventData(TouchEventData eventData) {
        if (touchDataPool == null) {
            throw new IllegalStateException("The Event Data Pools are not initialized yet!");
        }
        touchDataPool.free(eventData);
    }

    private static void recycleEventData(KeyEventData eventData) {
        if (keyDataPool == null) {
            throw new IllegalStateException("The Event Data Pools are not initialized yet!");
        }
        keyDataPool.free(eventData);
    }

    private static void recycleEventData(GestureEventData eventData) {
        if (gestureDataPool == null) {
            throw new IllegalStateException("The Event Data Pools are not initialized yet!");
        }
        gestureDataPool.free(eventData);
    }

    static {
        MOUSE_BUTTONS = new int[]{3, 4, 0, 2, 1};
    }
}

