/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken.input;

import com.badlogic.gdx.utils.Pool;

public class KeyEventData
implements Pool.Poolable {
    public KeyEvent keyEvent;
    public int keyCode;
    public char keyChar;

    public KeyEventData(KeyEvent keyEvent, int keyCode) {
        this.keyEvent = keyEvent;
        this.keyCode = keyCode;
    }

    public KeyEventData(char keyChar) {
        this.keyEvent = KeyEvent.KEY_TYPED;
        this.keyChar = keyChar;
    }

    public KeyEventData() {
    }

    public void reset() {
        this.keyEvent = null;
        this.keyCode = 0;
        this.keyChar = '\u0000';
    }

    public boolean sameEvent(KeyEvent secondEvent) {
        return this.keyEvent == secondEvent;
    }

    public boolean sameEvent(KeyEventData secondData) {
        return this.keyEvent == secondData.keyEvent && this.keyCode == secondData.keyCode && this.keyChar == secondData.keyChar;
    }

    public static KeyEventData upEvent(int keyCode) {
        return new KeyEventData(KeyEvent.KEY_UP, keyCode);
    }

    public static KeyEventData downEvent(int keyCode) {
        return new KeyEventData(KeyEvent.KEY_DOWN, keyCode);
    }

    public static KeyEventData typedEvent(char keyChar) {
        return new KeyEventData(keyChar);
    }

    public static class DataPool
    extends Pool<KeyEventData> {
        protected KeyEventData newObject() {
            return new KeyEventData();
        }
    }

    public static enum KeyEvent {
        KEY_UP,
        KEY_DOWN,
        KEY_TYPED;

    }
}

