/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken.input;

import com.badlogic.gdx.utils.Pool;

public class TouchEventData
implements Pool.Poolable {
    public TouchEvent touchEvent;
    public float touchX;
    public float touchY;
    public int pointer = -1;
    public int button = -10;

    public TouchEventData(TouchEvent touchEvent) {
        this.touchEvent = touchEvent;
    }

    public TouchEventData() {
    }

    public boolean sameEvent(TouchEvent secondEvent) {
        return this.touchEvent == secondEvent;
    }

    public boolean sameEvent(TouchEventData secondData) {
        return this.sameEvent(secondData.touchEvent);
    }

    public void reset() {
        this.touchEvent = null;
        this.touchY = 0.0f;
        this.touchX = 0.0f;
        this.pointer = -1;
        this.button = -10;
    }

    public static TouchEventData upEvent() {
        return new TouchEventData(TouchEvent.TOUCH_UP);
    }

    public static TouchEventData downEvent() {
        return new TouchEventData(TouchEvent.TOUCH_DOWN);
    }

    public static TouchEventData draggedEvent() {
        return new TouchEventData(TouchEvent.TOUCH_DRAGGED);
    }

    public static class DataPool
    extends Pool<TouchEventData> {
        protected TouchEventData newObject() {
            return new TouchEventData();
        }
    }

    public static enum TouchEvent {
        TOUCH_UP,
        TOUCH_DOWN,
        TOUCH_DRAGGED;

    }
}

