/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class ArithmeticUtils {
    public static float vectorToAngle2d(Vector2 vector) {
        return (float)Math.atan2(-vector.x, vector.y);
    }

    public static Vector2 angleToVector2d(float angle, Vector2 outVector) {
        outVector.x = -((float)Math.sin(angle));
        outVector.y = (float)Math.cos(angle);
        return outVector;
    }

    public static float vectorToAngle3d(Vector3 vector) {
        return (float)Math.atan2(-vector.z, vector.x);
    }

    public static Vector3 angleToVector3d(float angle, Vector3 outVector) {
        outVector.z = -((float)Math.sin(angle));
        outVector.y = 0.0f;
        outVector.x = (float)Math.cos(angle);
        return outVector;
    }

    public static float randomBinomial() {
        return MathUtils.random() - MathUtils.random();
    }

    public static float wrapAngleAroundZero(float angle) {
        if (angle >= 0.0f) {
            float rotation = angle % ((float)Math.PI * 2);
            if (rotation > (float)Math.PI) {
                rotation -= (float)Math.PI * 2;
            }
            return rotation;
        }
        float rotation = -angle % ((float)Math.PI * 2);
        if (rotation > (float)Math.PI) {
            rotation -= (float)Math.PI * 2;
        }
        return -rotation;
    }

    public static int gcdPositive(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int aTwos = Integer.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b);
        b >>= bTwos;
        int shift = Math.min(aTwos, bTwos);
        while (a != b) {
            int delta = a - b;
            b = Math.min(a, b);
            a = delta < 0 ? -delta : delta;
            a >>= Integer.numberOfTrailingZeros(a);
        }
        return a << shift;
    }

    public static int lcmPositive(int a, int b) throws ArithmeticException {
        if (a == 0 || b == 0) {
            return 0;
        }
        int lcm = Math.abs(ArithmeticUtils.mulAndCheck(a / ArithmeticUtils.gcdPositive(a, b), b));
        if (lcm == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: lcm(" + a + ", " + b + ") > 2^31");
        }
        return lcm;
    }

    public static int mulAndCheck(int x, int y) throws ArithmeticException {
        long m = (long)x * (long)y;
        if (m < Integer.MIN_VALUE || m > Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return (int)m;
    }
}

