/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken.utils;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.isoterik.racken.Transform;

public class GameWorldUnits {
    private final float unit;
    private final float ppu;
    private final float worldWidth;
    private final float worldHeight;

    public GameWorldUnits(float pixelsWidth, float pixelsHeight, float pixelsPerUnit) {
        this.ppu = pixelsPerUnit;
        this.worldWidth = pixelsWidth / this.ppu;
        this.worldHeight = pixelsHeight / this.ppu;
        this.unit = 1.0f / this.ppu;
    }

    public float toWorldUnit(float pixels) {
        return this.unit * pixels;
    }

    public float toPixels(float unit) {
        return unit * this.ppu;
    }

    public Vector2 toWorldUnit(float pixelsX, float pixelsY) {
        return new Vector2(this.toWorldUnit(pixelsX), this.toWorldUnit(pixelsY));
    }

    public Vector2 toWorldUnit(TextureRegion region) {
        return this.toWorldUnit(region.getRegionWidth(), region.getRegionHeight());
    }

    public void toWorldUnitTransform(Transform transform) {
        float w = this.toWorldUnit(transform.size.x);
        float h = this.toWorldUnit(transform.size.y);
        float d = this.toWorldUnit(transform.size.z);
        float x = this.toWorldUnit(transform.position.x);
        float y = this.toWorldUnit(transform.position.y);
        float z = this.toWorldUnit(transform.position.z);
        transform.setSize(w, h, d);
        transform.setPosition(x, y, z);
        transform.setOrigin(w * 0.5f, h * 0.5f, d * 0.5f);
    }

    public float getWorldWidth() {
        return this.worldWidth;
    }

    public float getWorldHeight() {
        return this.worldHeight;
    }

    public float getScreenWidth() {
        return this.toPixels(this.worldWidth);
    }

    public float getScreenHeight() {
        return this.toPixels(this.worldHeight);
    }

    public float getPixelsPerUnit() {
        return this.ppu;
    }
}

