/*
 * Decompiled with CFR 0.152.
 */
package com.isoterik.racken.utils;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.StringBuilder;
import com.isoterik.racken.Racken;
import com.isoterik.racken.asset.GameAssetsLoader;

public class SpriteUtils {
    private static String forceDigits(int number, int digits, StringBuilder builder) {
        String str = String.valueOf(number);
        if (str.length() == digits) {
            return str;
        }
        int remainder = str.length() % digits;
        builder.clear();
        for (int i = 0; i <= remainder; ++i) {
            builder.append("0");
        }
        builder.append(number);
        String value = builder.toString();
        builder.clear();
        return value;
    }

    public static Array<TextureRegion> getSpriteSequence(String beforeIndex, String afterIndex, int startingIndex, int stoppingIndex, int digits, boolean linearFilter) {
        Array sequence = new Array();
        StringBuilder builder = new StringBuilder();
        GameAssetsLoader assets = Racken.instance().assets;
        for (int i = startingIndex; i <= stoppingIndex; ++i) {
            String index = SpriteUtils.forceDigits(i, digits, builder);
            builder.clear();
            builder.append(beforeIndex).append(index).append(afterIndex);
            String fileName = builder.toString();
            if (!assets.isLoaded(fileName, Texture.class)) continue;
            sequence.add((Object)assets.regionForTexture(fileName, linearFilter));
        }
        return sequence;
    }

    public static Array<TextureRegion> getSpriteSequence(String beforeIndex, String afterIndex, int startingIndex, int stoppingIndex, int digits) {
        return SpriteUtils.getSpriteSequence(beforeIndex, afterIndex, startingIndex, stoppingIndex, digits, true);
    }
}

