/*
 * Decompiled with CFR 0.152.
 */
package com.isuwang.dapeng.doc;

import com.isuwang.dapeng.core.metadata.Method;
import com.isuwang.dapeng.core.metadata.Service;
import com.isuwang.dapeng.core.metadata.Struct;
import com.isuwang.dapeng.core.metadata.TEnum;
import com.isuwang.dapeng.doc.cache.ServiceCache;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api"})
public class ApiServiceController {
    @Autowired
    private ServiceCache serviceCache;

    @ModelAttribute
    public void populateModel(Model model) {
        model.addAttribute("tagName", (Object)"api");
    }

    @RequestMapping(value={"index"}, method={RequestMethod.GET})
    public String api(HttpServletRequest request) {
        Map<String, Service> services = this.serviceCache.getServices();
        request.setAttribute("services", services.values());
        return "api/api";
    }

    @RequestMapping(value={"service/{serviceName}/{version}"}, method={RequestMethod.GET})
    @Transactional(value="isuwang_api", rollbackFor={Exception.class})
    public String service(HttpServletRequest request, @PathVariable String serviceName, @PathVariable String version) {
        request.setAttribute("service", (Object)this.serviceCache.getService(serviceName, version));
        request.setAttribute("services", this.serviceCache.getServices().values());
        return "api/service";
    }

    @RequestMapping(value={"method/{serviceName}/{version}/{methodName}"}, method={RequestMethod.GET})
    @Transactional(value="isuwang_api", rollbackFor={Exception.class})
    public String method(HttpServletRequest request, @PathVariable String serviceName, @PathVariable String version, @PathVariable String methodName) {
        Service service = this.serviceCache.getService(serviceName, version);
        Method seleted = null;
        List methods = service.getMethods();
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            seleted = method;
            break;
        }
        Collections.sort(methods, (arg0, arg1) -> arg0.getName().compareTo(arg1.getName()));
        request.setAttribute("service", (Object)service);
        request.setAttribute("methods", (Object)methods);
        request.setAttribute("method", (Object)seleted);
        return "api/method";
    }

    @RequestMapping(value={"findmethod/{serviceName}/{version}/{methodName}"}, method={RequestMethod.GET})
    @ResponseBody
    public Method findMethod(@PathVariable String serviceName, @PathVariable String version, @PathVariable String methodName) {
        Service service = this.serviceCache.getService(serviceName, version);
        List methods = service.getMethods();
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    @RequestMapping(value={"struct/{serviceName}/{version}/{ref}"}, method={RequestMethod.GET})
    @Transactional(value="isuwang_api", rollbackFor={Exception.class})
    public String struct(HttpServletRequest request, @PathVariable String serviceName, @PathVariable String version, @PathVariable String ref) {
        Service service = this.serviceCache.getService(serviceName, version);
        List structDefinitions = service.getStructDefinitions();
        for (Struct struct : structDefinitions) {
            String fullStructName = struct.getNamespace() + "." + struct.getName();
            if (!fullStructName.equals(ref)) continue;
            request.setAttribute("struct", (Object)struct);
            break;
        }
        request.setAttribute("service", (Object)service);
        request.setAttribute("structs", (Object)service.getStructDefinitions());
        return "api/struct";
    }

    @RequestMapping(value={"findstruct/{serviceName}/{version}/{fullStructName}"}, method={RequestMethod.GET})
    @ResponseBody
    public Struct findStruct(@PathVariable String serviceName, @PathVariable String version, @PathVariable String fullStructName) {
        Service service = this.serviceCache.getService(serviceName, version);
        List structDefinitions = service.getStructDefinitions();
        for (Struct struct : structDefinitions) {
            String fsname = struct.getNamespace() + "." + struct.getName();
            if (!fsname.equals(fullStructName)) continue;
            return struct;
        }
        return null;
    }

    @RequestMapping(value={"enum/{serviceName}/{version}/{ref}"}, method={RequestMethod.GET})
    @Transactional(value="isuwang_api", rollbackFor={Exception.class})
    public String anEnum(HttpServletRequest request, @PathVariable String serviceName, @PathVariable String version, @PathVariable String ref) {
        Service service = this.serviceCache.getService(serviceName, version);
        List enums = service.getEnumDefinitions();
        for (TEnum anEnum : enums) {
            String ename = anEnum.getNamespace() + "." + anEnum.getName();
            if (!ename.equals(ref)) continue;
            request.setAttribute("anEnum", (Object)anEnum);
            break;
        }
        request.setAttribute("service", (Object)service);
        request.setAttribute("enums", (Object)service.getEnumDefinitions());
        return "api/enum";
    }

    @RequestMapping(value={"test/{serviceName}/{version}/{methodName}"}, method={RequestMethod.GET})
    @Transactional(value="isuwang_api", rollbackFor={Exception.class})
    public String goTest(HttpServletRequest request, @PathVariable String serviceName, @PathVariable String version, @PathVariable String methodName) {
        Service service = this.serviceCache.getService(serviceName, version);
        Method seleted = null;
        List methods = service.getMethods();
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            seleted = method;
            break;
        }
        request.setAttribute("service", (Object)service);
        request.setAttribute("method", seleted);
        request.setAttribute("services", this.serviceCache.getServices().values());
        return "api/test";
    }

    @RequestMapping(value={"findService/{serviceName}/{version}"}, method={RequestMethod.GET})
    @ResponseBody
    public Service findService(@PathVariable String serviceName, @PathVariable String version) {
        Service service = this.serviceCache.getService(serviceName, version);
        return service;
    }

    @RequestMapping(value={"findServiceAfterRefresh/{serviceName}/{version}/{refresh}"}, method={RequestMethod.GET})
    @ResponseBody
    public Service findService(@PathVariable String serviceName, @PathVariable String version, @PathVariable boolean refresh) {
        if (refresh) {
            this.serviceCache.reloadServices();
        }
        Service service = this.serviceCache.getService(serviceName, version);
        return service;
    }
}

