/*
 * Decompiled with CFR 0.152.
 */
package com.isuwang.dapeng.doc;

import com.isuwang.dapeng.doc.cache.ServiceCache;
import java.util.ArrayList;
import java.util.NavigableSet;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"search"})
public class SearchController {
    @Autowired
    private ServiceCache serviceCache;

    @ModelAttribute
    public void populateModel(Model model) {
        model.addAttribute("tagName", (Object)"search");
    }

    @RequestMapping(method={RequestMethod.POST})
    public String index(HttpServletRequest request) {
        String searchText = request.getParameter("searchText");
        ArrayList<SearchResultItem> resultList = new ArrayList<SearchResultItem>();
        NavigableSet keys = ServiceCache.urlMappings.keySet();
        for (String key : keys) {
            if (!key.toUpperCase().contains(searchText.toUpperCase())) continue;
            NavigableSet results = ServiceCache.urlMappings.get((Object)key);
            for (String value : results) {
                SearchResultItem s = new SearchResultItem();
                s.setName(key);
                s.setUrl(value);
                resultList.add(s);
            }
        }
        request.setAttribute("services", this.serviceCache.getServices().values());
        request.setAttribute("resultList", resultList);
        return "api/search";
    }

    public class SearchResultItem {
        public String name = "";
        public String url = "";

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

