/*
 * Decompiled with CFR 0.152.
 */
package com.isuwang.dapeng.doc;

import com.isuwang.dapeng.core.SoaHeader;
import com.isuwang.dapeng.core.SoaSystemEnvProperties;
import com.isuwang.dapeng.core.metadata.Service;
import com.isuwang.dapeng.doc.cache.ServiceCache;
import com.isuwang.dapeng.remoting.fake.json.JSONPost;
import com.isuwang.dapeng.remoting.filter.LoadBalanceFilter;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"test"})
public class TestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private ServiceCache serviceCache;
    private JSONPost jsonPost;

    @ModelAttribute
    public void populateModel(Model model) {
        model.addAttribute("tagName", (Object)"test");
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public String test(HttpServletRequest req) {
        String jsonParameter = req.getParameter("parameter");
        String serviceName = req.getParameter("serviceName");
        String versionName = req.getParameter("version");
        String methodName = req.getParameter("methodName");
        Service service = this.serviceCache.getService(serviceName, versionName);
        SoaHeader header = new SoaHeader();
        header.setServiceName(serviceName);
        header.setVersionName(versionName);
        header.setMethodName(methodName);
        header.setCallerFrom(Optional.of("TestController"));
        String callerInfo = LoadBalanceFilter.getCallerInfo((String)serviceName, (String)versionName, (String)methodName);
        if (callerInfo == null && SoaSystemEnvProperties.SOA_REMOTING_MODE.equals("local")) {
            this.jsonPost = new JSONPost(SoaSystemEnvProperties.SOA_SERVICE_IP, SoaSystemEnvProperties.SOA_SERVICE_PORT, true);
        } else if (callerInfo != null) {
            String[] infos = callerInfo.split(":");
            this.jsonPost = new JSONPost(infos[0], Integer.valueOf(infos[1]), true);
        } else {
            return "{\"message\":\"\u6ca1\u627e\u5230\u53ef\u7528\u670d\u52a1\"}";
        }
        try {
            return this.jsonPost.callServiceMethod(header, jsonParameter, service);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

