/*
 * Decompiled with CFR 0.152.
 */
package com.isuwang.dapeng.doc.cache;

import com.google.common.collect.TreeMultimap;
import com.isuwang.dapeng.core.ProcessorKey;
import com.isuwang.dapeng.core.SoaBaseProcessor;
import com.isuwang.dapeng.core.metadata.Field;
import com.isuwang.dapeng.core.metadata.Method;
import com.isuwang.dapeng.core.metadata.Service;
import com.isuwang.dapeng.core.metadata.Struct;
import com.isuwang.dapeng.core.metadata.TEnum;
import com.isuwang.dapeng.registry.RegistryAgentProxy;
import com.isuwang.dapeng.remoting.fake.metadata.MetadataClient;
import com.isuwang.org.apache.thrift.TException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCache.class);
    private static Map<String, Service> services = new TreeMap<String, Service>();
    private static Map<String, Service> fullNameService = new TreeMap<String, Service>();
    public static TreeMultimap<String, String> urlMappings = TreeMultimap.create();

    public void init() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ServiceCache.this.reloadServices();
            }
        }.start();
    }

    public void reloadServices() {
        TreeMap<String, Service> services = new TreeMap<String, Service>();
        urlMappings.clear();
        Map processorMap = RegistryAgentProxy.getCurrentInstance((RegistryAgentProxy.Type)RegistryAgentProxy.Type.Server).getProcessorMap();
        Set keys = processorMap.keySet();
        for (ProcessorKey key : keys) {
            SoaBaseProcessor processor = (SoaBaseProcessor)processorMap.get(key);
            if (processor.getInterfaceClass().getClass() == null) continue;
            com.isuwang.dapeng.core.Service service = processor.getInterfaceClass().getAnnotation(com.isuwang.dapeng.core.Service.class);
            String serviceName = processor.getInterfaceClass().getName();
            String version = service.version();
            String metadata = "";
            try {
                metadata = new MetadataClient(serviceName, version).getServiceMetadata();
            }
            catch (TException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (metadata == null) continue;
            try {
                StringReader reader = new StringReader(metadata);
                Throwable throwable = null;
                try {
                    Service serviceData = (Service)JAXB.unmarshal((Reader)reader, Service.class);
                    this.loadResource(serviceData, services);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("\u751f\u6210SERVICE\u51fa\u9519", (Throwable)e);
            }
        }
        ServiceCache.services = services;
        LOGGER.info("size of urlMapping: " + urlMappings.size());
    }

    public void destory() {
        services.clear();
    }

    public void loadResource(Service service, Map<String, Service> services) {
        String key = this.getKey(service);
        services.put(key, service);
        String fullNameKey = this.getFullNameKey(service);
        fullNameService.put(fullNameKey, service);
        urlMappings.put((Object)service.getName(), (Object)("api/service/" + service.name + "/" + service.meta.version + ".htm"));
        List methods = service.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            Method method = (Method)methods.get(i);
            urlMappings.put((Object)method.name, (Object)("api/method/" + service.name + "/" + service.meta.version + "/" + method.name + ".htm"));
        }
        List structs = service.getStructDefinitions();
        for (int i = 0; i < structs.size(); ++i) {
            Struct struct = (Struct)structs.get(i);
            urlMappings.put((Object)struct.name, (Object)("api/struct/" + service.name + "/" + service.meta.version + "/" + struct.namespace + "." + struct.name + ".htm"));
            List fields = struct.getFields();
            for (int j = 0; j < fields.size(); ++j) {
                Field field = (Field)fields.get(j);
                urlMappings.put((Object)field.name, (Object)("api/struct/" + service.name + "/" + service.meta.version + "/" + struct.namespace + "." + struct.name + ".htm"));
            }
        }
        List tEnums = service.getEnumDefinitions();
        for (int i = 0; i < tEnums.size(); ++i) {
            TEnum tEnum = (TEnum)tEnums.get(i);
            urlMappings.put((Object)tEnum.name, (Object)("api/enum/" + service.name + "/" + service.meta.version + "/" + tEnum.namespace + "." + tEnum.name + ".htm"));
        }
    }

    public Service getService(String name, String version) {
        if (name.contains(".")) {
            return fullNameService.get(this.getKey(name, version));
        }
        return services.get(this.getKey(name, version));
    }

    private String getKey(Service service) {
        return this.getKey(service.getName(), service.getMeta().version);
    }

    private String getFullNameKey(Service service) {
        return this.getKey(service.getNamespace() + "." + service.getName(), service.getMeta().version);
    }

    private String getKey(String name, String version) {
        return name + ":" + version;
    }

    public Map<String, Service> getServices() {
        return services;
    }
}

