/*
 * Decompiled with CFR 0.152.
 */
package com.itangcent.intellij.jvm.kotlin;

import com.intellij.psi.PsiElement;
import com.itangcent.intellij.jvm.kotlin.KtPsiUtils;
import com.itangcent.intellij.jvm.standard.AbstractLinkExtractor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/itangcent/intellij/jvm/kotlin/KotlinLinkExtractor;", "Lcom/itangcent/intellij/jvm/standard/AbstractLinkExtractor;", "()V", "findLink", "", "doc", "psiElement", "Lcom/intellij/psi/PsiElement;", "resolver", "Lkotlin/Function1;", "intellij-kotlin-support"})
public class KotlinLinkExtractor
extends AbstractLinkExtractor {
    @NotNull
    public String findLink(@NotNull String doc, @NotNull PsiElement psiElement, @NotNull Function1<? super String, String> resolver) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        if (!KtPsiUtils.INSTANCE.isKtPsiInst(psiElement)) {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        if (StringsKt.contains$default((CharSequence)doc, (CharSequence)"@link", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)doc, (CharSequence)"[", (boolean)false, (int)2, null)) {
            Pattern pattern = Pattern.compile("\\{@link(.*?)}|\\[(.*?)]");
            Matcher matcher = pattern.matcher(doc);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String string;
                matcher.appendReplacement(sb, "");
                String string2 = matcher.group(1);
                if (string2 == null) {
                    string2 = matcher.group(2);
                }
                if (string2 == null) {
                    continue;
                }
                String linkClassAndMethod = string2;
                if ((String)resolver.invoke((Object)linkClassAndMethod) == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                sb.append(it);
            }
            matcher.appendTail(sb);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }
        return doc;
    }
}

