/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.redis.consumer;

import com.alibaba.fastjson.JSONObject;
import com.iteaj.iot.redis.consumer.BlockConsumerOpera;
import com.iteaj.iot.redis.consumer.ListConsumer;
import com.iteaj.iot.redis.consumer.RedisConsumer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class ListConsumerOpera
implements BlockConsumerOpera<ListConsumer, Integer> {
    private List<ListConsumer> consumers;

    public ListConsumerOpera(List<ListConsumer> consumers) {
        this.consumers = consumers;
    }

    @Override
    public List invoker(String key, long timeout) {
        Object o = this.template().opsForList().rightPop((Object)key, timeout, TimeUnit.SECONDS);
        if (o != null) {
            return Arrays.asList(o);
        }
        return null;
    }

    @Override
    public List invoker(String key, int size) {
        return this.template().opsForList().range((Object)key, 0L, (long)size);
    }

    @Override
    public List deserialize(List<?> value, Class clazz) {
        if (CollectionUtils.isEmpty(value)) {
            return null;
        }
        return value.stream().map(item -> {
            if (item instanceof JSONObject) {
                return ((JSONObject)item).toJavaObject(clazz);
            }
            return item;
        }).collect(Collectors.toList());
    }

    @Override
    public void remove(String key, Integer consumerNum) {
        if (consumerNum != null) {
            this.template().opsForList().trim((Object)key, (long)consumerNum.intValue(), -1L);
        }
    }

    @Override
    public List<RedisConsumer> blocks() {
        return this.consumers.stream().filter(item -> item.block()).collect(Collectors.toList());
    }

    @Override
    public List<ListConsumer> consumers() {
        return this.consumers.stream().filter(item -> !item.block()).collect(Collectors.toList());
    }
}

