/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.redis.consumer;

import com.iteaj.iot.redis.consumer.BlockConsumerOpera;
import com.iteaj.iot.redis.consumer.RedisConsumer;
import com.iteaj.iot.redis.consumer.RedisConsumerOpera;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.CollectionUtils;

public class RedisConsumerOperaManager
implements InitializingBean,
DisposableBean {
    private RedisProperties config;
    private Executor executor;
    private List<RedisConsumerOpera> operas;
    private ExecutorService blockExecutorService;
    List<RedisConsumerWrapper> consumers = new ArrayList<RedisConsumerWrapper>();
    List<RedisConsumerWrapper> blockConsumers = new ArrayList<RedisConsumerWrapper>();
    List<RedisConsumerWrapper> execConsumers = Collections.synchronizedList(new ArrayList());
    private ExecutorService consumerExecutorService = Executors.newFixedThreadPool(1);
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public RedisConsumerOperaManager(List<RedisConsumerOpera> operas, Executor executor, RedisProperties config) {
        this.operas = operas;
        this.config = config;
        this.executor = executor;
    }

    public void afterPropertiesSet() throws Exception {
        this.operas.forEach(opera -> {
            if (opera instanceof BlockConsumerOpera) {
                List<RedisConsumer> blocks = ((BlockConsumerOpera)opera).blocks();
                if (!CollectionUtils.isEmpty(blocks)) {
                    List wrappers = blocks.stream().map(item -> new RedisConsumerWrapper((RedisConsumer)item, (RedisConsumerOpera)opera)).collect(Collectors.toList());
                    this.blockConsumers.addAll(wrappers);
                } else {
                    List consumers = opera.consumers();
                    if (!CollectionUtils.isEmpty(consumers)) {
                        List wrappers = consumers.stream().map(item -> new RedisConsumerWrapper((RedisConsumer)item, (RedisConsumerOpera)opera)).collect(Collectors.toList());
                        this.consumers.addAll(wrappers);
                    }
                }
            } else {
                List consumers = opera.consumers();
                if (!CollectionUtils.isEmpty(consumers)) {
                    List wrappers = consumers.stream().map(item -> new RedisConsumerWrapper((RedisConsumer)item, (RedisConsumerOpera)opera)).collect(Collectors.toList());
                    this.consumers.addAll(wrappers);
                }
            }
        });
        if (!CollectionUtils.isEmpty(this.consumers)) {
            this.execConsumers.addAll(this.consumers);
            this.consumerExecutorService.execute(new ConsumerHandleTask());
        }
        if (!CollectionUtils.isEmpty(this.blockConsumers)) {
            this.blockExecutorService = Executors.newFixedThreadPool(this.blockConsumers.size());
            this.blockConsumers.forEach(item -> this.blockExecutorService.execute(new BlockHandleTask((RedisConsumerWrapper)item)));
        }
    }

    public void destroy() throws Exception {
        if (this.blockExecutorService != null) {
            this.blockExecutorService.shutdownNow();
        }
        if (!this.consumerExecutorService.isShutdown()) {
            this.consumerExecutorService.shutdownNow();
        }
    }

    class RedisConsumerWrapper
    implements RedisConsumer {
        private volatile boolean finish = true;
        private Class<?> valueClazz;
        private RedisConsumer consumer;
        private RedisConsumerOpera consumerOpera;

        public RedisConsumerWrapper(RedisConsumer consumer, RedisConsumerOpera consumerOpera) {
            this.consumer = consumer;
            this.consumerOpera = consumerOpera;
            Class[] typeArguments = GenericTypeResolver.resolveTypeArguments(consumer.getClass(), RedisConsumer.class);
            this.valueClazz = typeArguments != null && typeArguments.length != 0 ? typeArguments[0] : null;
        }

        @Override
        public String getKey() {
            return this.consumer.getKey();
        }

        public Object consumer(List v) {
            if (this.valueClazz != null) {
                v = this.consumerOpera.deserialize(v, this.valueClazz);
            }
            return this.consumer.consumer(v);
        }

        public RedisConsumer getConsumer() {
            return this.consumer;
        }

        public RedisConsumerOpera getConsumerOpera() {
            return this.consumerOpera;
        }

        public Class<?> getValueClazz() {
            return this.valueClazz;
        }

        public boolean isFinish() {
            return this.finish;
        }

        public void setFinish(boolean finish) {
            this.finish = finish;
        }
    }

    class ConsumerTask
    implements Runnable {
        private RedisConsumerWrapper consumerWrapper;

        public ConsumerTask(RedisConsumerWrapper consumerWrapper) {
            this.consumerWrapper = consumerWrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RedisConsumer consumer = this.consumerWrapper.consumer;
            try {
                List invoker = this.consumerWrapper.consumerOpera.invoker(consumer.getKey(), consumer.maxSize());
                if (!CollectionUtils.isEmpty((Collection)invoker)) {
                    Object r = this.consumerWrapper.consumer(invoker);
                    this.consumerWrapper.consumerOpera.remove(consumer.getKey(), r);
                }
            }
            catch (Exception e) {
                RedisConsumerOperaManager.this.logger.error("Redis\u6d88\u8d39\u7ba1\u7406\u5f02\u5e38({}) - key: {} - \u6d88\u8d39\u5bf9\u8c61: {}", new Object[]{e.getMessage(), consumer.getKey(), consumer.getClass(), e});
            }
            finally {
                this.consumerWrapper.setFinish(true);
            }
        }
    }

    class ConsumerHandleTask
    implements Runnable {
        ConsumerHandleTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int notFinishCount = 0;
                        for (RedisConsumerWrapper item : RedisConsumerOperaManager.this.execConsumers) {
                            if (item.isFinish()) {
                                item.setFinish(false);
                                RedisConsumerOperaManager.this.executor.execute(new ConsumerTask(item));
                                continue;
                            }
                            ++notFinishCount;
                        }
                        if (notFinishCount != RedisConsumerOperaManager.this.execConsumers.size()) continue;
                        if (RedisConsumerOperaManager.this.logger.isDebugEnabled()) {
                            RedisConsumerOperaManager.this.logger.debug("Redis\u6d88\u8d39\u7b97\u6cd5 \u6240\u6709\u6d88\u8d39\u4efb\u52a1\u90fd\u672a\u5b8c\u6210\u4f11\u77205\u79d2 - \u4e3a\u5b8c\u6210RedisConsumer\u5bf9\u8c61: {} - \u603bRedisConsumer\u5bf9\u8c61: {} - ", (Object)notFinishCount, (Object)RedisConsumerOperaManager.this.execConsumers.size());
                        }
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException e) {}
                catch (Exception e) {
                    RedisConsumerOperaManager.this.logger.error("Redis\u6d88\u8d39\u4efb\u52a1\u7b97\u6cd5\u5f02\u5e38({})", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    continue;
                }
                break;
            }
        }
    }

    class BlockHandleTask
    implements Runnable {
        private RedisConsumerWrapper consumerWrapper;

        public BlockHandleTask(RedisConsumerWrapper consumerWrapper) {
            this.consumerWrapper = consumerWrapper;
        }

        @Override
        public void run() {
            long timeout = RedisConsumerOperaManager.this.config.getTimeout().getSeconds();
            if (timeout > 5L) {
                timeout -= 2L;
            }
            RedisConsumer consumer = this.consumerWrapper.consumer;
            BlockConsumerOpera consumerOpera = (BlockConsumerOpera)this.consumerWrapper.consumerOpera;
            while (true) {
                try {
                    while (true) {
                        List invoker;
                        if (CollectionUtils.isEmpty((Collection)(invoker = consumerOpera.invoker(consumer.getKey(), timeout)))) {
                            continue;
                        }
                        this.consumerWrapper.consumer(invoker);
                        List list = consumerOpera.invoker(consumer.getKey(), consumer.maxSize());
                        Object r = this.consumerWrapper.consumer(list);
                        consumerOpera.remove(consumer.getKey(), r);
                    }
                }
                catch (Exception e) {
                    RedisConsumerOperaManager.this.logger.error("Redis\u6d88\u8d39\u7ba1\u7406\u5f02\u5e38({}) - key: {} - \u6d88\u8d39\u5bf9\u8c61: {}", new Object[]{e.getMessage(), consumer.getKey(), consumer.getClass(), e});
                    continue;
                }
                break;
            }
        }
    }
}

